/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.source.formatter.BNDSourceProcessor;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.CSSSourceProcessor;
import com.liferay.source.formatter.FTLSourceProcessor;
import com.liferay.source.formatter.GitException;
import com.liferay.source.formatter.GradleSourceProcessor;
import com.liferay.source.formatter.GroovySourceProcessor;
import com.liferay.source.formatter.JSONSourceProcessor;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.JSSourceProcessor;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.SHSourceProcessor;
import com.liferay.source.formatter.SQLSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.TLDSourceProcessor;
import com.liferay.source.formatter.XMLSourceProcessor;
import com.liferay.source.formatter.util.GitUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SourceFormatter {
    private final Set<String> _errorMessages = new ConcurrentSkipListSet<String>();
    private volatile SourceMismatchException _firstSourceMismatchException;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private final SourceFormatterArgs _sourceFormatterArgs;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            SourceFormatterArgs sourceFormatterArgs = new SourceFormatterArgs();
            boolean autoFix = GetterUtil.getBoolean(arguments.get("source.auto.fix"), true);
            sourceFormatterArgs.setAutoFix(autoFix);
            String baseDirName = GetterUtil.getString(arguments.get("source.base.dir"), "./");
            sourceFormatterArgs.setBaseDirName(baseDirName);
            boolean formatCurrentBranch = GetterUtil.getBoolean(arguments.get("format.current.branch"), false);
            sourceFormatterArgs.setFormatCurrentBranch(formatCurrentBranch);
            boolean formatLatestAuthor = GetterUtil.getBoolean(arguments.get("format.latest.author"), false);
            sourceFormatterArgs.setFormatLatestAuthor(formatLatestAuthor);
            boolean formatLocalChanges = GetterUtil.getBoolean(arguments.get("format.local.changes"), false);
            sourceFormatterArgs.setFormatLocalChanges(formatLocalChanges);
            if (formatCurrentBranch) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getCurrentBranchFileNames(baseDirName));
            } else if (formatLatestAuthor) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLatestAuthorFileNames(baseDirName));
            } else if (formatLocalChanges) {
                sourceFormatterArgs.setRecentChangesFileNames(GitUtil.getLocalChangesFileNames(baseDirName));
            }
            String copyrightFileName = GetterUtil.getString(arguments.get("source.copyright.file"), "copyright.txt");
            sourceFormatterArgs.setCopyrightFileName(copyrightFileName);
            Object[] fileNames = StringUtil.split(arguments.get("source.files"), ",");
            if (ArrayUtil.isNotEmpty(fileNames)) {
                sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
            }
            boolean printErrors = GetterUtil.getBoolean(arguments.get("source.print.errors"), true);
            sourceFormatterArgs.setPrintErrors(printErrors);
            boolean throwException = GetterUtil.getBoolean(arguments.get("source.throw.exception"), false);
            sourceFormatterArgs.setThrowException(throwException);
            boolean useProperties = GetterUtil.getBoolean(arguments.get("source.use.properties"), false);
            sourceFormatterArgs.setUseProperties(useProperties);
            SourceFormatter sourceFormatter = new SourceFormatter(sourceFormatterArgs);
            sourceFormatter.format();
        }
        catch (GitException ge) {
            System.out.println(ge.getMessage());
            System.exit(0);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public SourceFormatter(SourceFormatterArgs sourceFormatterArgs) {
        this._sourceFormatterArgs = sourceFormatterArgs;
    }

    public void format() throws Exception {
        ArrayList<BaseSourceProcessor> sourceProcessors = new ArrayList<BaseSourceProcessor>();
        sourceProcessors.add(new BNDSourceProcessor());
        sourceProcessors.add(new CSSSourceProcessor());
        sourceProcessors.add(new FTLSourceProcessor());
        sourceProcessors.add(new GradleSourceProcessor());
        sourceProcessors.add(new GroovySourceProcessor());
        sourceProcessors.add(new JavaSourceProcessor());
        sourceProcessors.add(new JSONSourceProcessor());
        sourceProcessors.add(new JSPSourceProcessor());
        sourceProcessors.add(new JSSourceProcessor());
        sourceProcessors.add(new PropertiesSourceProcessor());
        sourceProcessors.add(new SHSourceProcessor());
        sourceProcessors.add(new SQLSourceProcessor());
        sourceProcessors.add(new TLDSourceProcessor());
        sourceProcessors.add(new XMLSourceProcessor());
        ExecutorService executorService = Executors.newFixedThreadPool(sourceProcessors.size());
        ArrayList<Future> futures = new ArrayList<Future>(sourceProcessors.size());
        for (final SourceProcessor sourceProcessor : sourceProcessors) {
            Future future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    return null;
                }
            });
            futures.add(future);
        }
        ExecutionException ee1 = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException ee2) {
                if (ee1 == null) {
                    ee1 = ee2;
                    continue;
                }
                ee1.addSuppressed(ee2);
            }
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(20L);
        }
        if (ee1 != null) {
            throw ee1;
        }
        if (this._sourceFormatterArgs.isThrowException()) {
            if (!this._errorMessages.isEmpty()) {
                throw new Exception(StringUtil.merge(this._errorMessages, "\n"));
            }
            if (this._firstSourceMismatchException != null) {
                throw this._firstSourceMismatchException;
            }
        }
    }

    public List<String> getErrorMessages() {
        return new ArrayList<String>(this._errorMessages);
    }

    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    public SourceFormatterArgs getSourceFormatterArgs() {
        return this._sourceFormatterArgs;
    }

    public SourceMismatchException getSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    private void _runSourceProcessor(SourceProcessor sourceProcessor) throws Exception {
        sourceProcessor.setSourceFormatterArgs(this._sourceFormatterArgs);
        sourceProcessor.format();
        this._errorMessages.addAll(sourceProcessor.getErrorMessages());
        this._modifiedFileNames.addAll(sourceProcessor.getModifiedFileNames());
        if (this._firstSourceMismatchException == null) {
            this._firstSourceMismatchException = sourceProcessor.getFirstSourceMismatchException();
        }
    }
}

