/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.FTLImportsFormatter;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.ftl"};
    private final Pattern _liferayVariablePattern = Pattern.compile("^\t*<#assign liferay_.*>\n", 8);
    private final Pattern _liferayVariablesPattern = Pattern.compile("(^\t*<#assign liferay_.*>\n)+", 8);
    private final Pattern _multiParameterTagPattern = Pattern.compile("\n(\t*)<@.+=.+=.+/>");
    private final Pattern _singleParameterTagPattern = Pattern.compile("(<@[\\w\\.]+ \\w+)( )?=([^=]+?)/>");

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    protected void checkIfStatement(String line, String fileName, int lineCount) {
        if (!line.startsWith("<#elseif ") && !line.startsWith("<#if ") || !line.endsWith(">") || line.contains("?")) {
            return;
        }
        int pos = line.indexOf(" ");
        String ifClause = "if (" + line.substring(pos + 1, line.length() - 1) + ") {";
        this.checkIfClauseParentheses(ifClause, fileName, lineCount);
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String match;
        content = StringUtil.replace(content, " >\n", ">\n");
        content = this.sortLiferayVariables(content);
        Matcher matcher = this._singleParameterTagPattern.matcher(content);
        while (matcher.find()) {
            String group3;
            String replacement = match = matcher.group();
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            if (group2 != null) {
                replacement = StringUtil.replaceFirst(replacement, group1 + " ", group1);
            }
            if ((group3 = matcher.group(3)).startsWith(" ")) {
                replacement = StringUtil.replaceLast(replacement, group3, group3.substring(1));
            }
            content = StringUtil.replace(content, match, replacement);
        }
        matcher = this._multiParameterTagPattern.matcher(content);
        while (matcher.find()) {
            match = matcher.group();
            if (match.contains("><")) continue;
            String strippedMatch = this.stripQuotes(match, '\"');
            if (StringUtil.count(strippedMatch, '=') <= 1) continue;
            String replacement = match;
            String tabs = matcher.group(1);
            int x = -1;
            while ((x = replacement.indexOf("=", x + tabs.length() + 2)) != -1) {
                if (ToolsUtil.isInsideQuotes(replacement, x)) continue;
                int y = replacement.lastIndexOf(" ", x);
                if (y == -1) break;
                replacement = replacement.substring(0, y) + "\n" + tabs + "\t" + replacement.substring(y + 1);
            }
            if (match.equals(replacement)) continue;
            replacement = StringUtil.replaceLast(replacement, "/>", "\n" + tabs + "/>");
            content = StringUtil.replace(content, match, replacement);
        }
        FTLImportsFormatter importsFormatter = new FTLImportsFormatter();
        content = importsFormatter.format(content, null, null);
        return this.formatFTL(fileName, content);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/journal/dependencies/template.ftl", "**/service/builder/dependencies/props.ftl"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    protected String formatFTL(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line = this.trimLine(line, false));
                if (trimmedLine.startsWith("<#assign ")) {
                    line = this.formatWhitespace(line, trimmedLine, true);
                    line = this.formatIncorrectSyntax(line, "=[", "= [", false);
                    line = this.formatIncorrectSyntax(line, "+[", "+ [", false);
                }
                this.checkIfStatement(trimmedLine, fileName, lineCount);
                sb.append(line);
                sb.append("\n");
            }
        }
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    protected String sortLiferayVariables(String content) {
        Matcher matcher = this._liferayVariablesPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            Matcher matcher2 = this._liferayVariablePattern.matcher(match);
            String previousVariable = null;
            while (matcher2.find()) {
                String variable = matcher2.group();
                if (Validator.isNotNull(previousVariable) && previousVariable.compareTo(variable) > 0) {
                    String replacement = StringUtil.replaceFirst(match, previousVariable, variable);
                    replacement = StringUtil.replaceLast(replacement, variable, previousVariable);
                    return StringUtil.replace(content, match, replacement);
                }
                previousVariable = variable;
            }
        }
        return content;
    }
}

