/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaExtractTextMethodCheck
extends BaseFileCheck {
    private static final Pattern _extractTextPattern = Pattern.compile("HtmlUtil\\.extractText\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        String newContent = content;
        boolean replaced = false;
        Matcher extractTextMatcher = _extractTextPattern.matcher(content);
        while (extractTextMatcher.find()) {
            String methodCall = JavaSourceUtil.getMethodCall(content, extractTextMatcher.start());
            newContent = StringUtil.replace(newContent, methodCall, StringUtil.replace(methodCall, "HtmlUtil.extractText(", "_htmlParser.extractText("));
            replaced = true;
        }
        if (replaced) {
            newContent = JavaSourceUtil.addImport(newContent, "import com.liferay.portal.kernel.util.HtmlParser;", "import org.osgi.service.component.annotations.Reference;");
            newContent = StringUtil.replaceLast(newContent, '}', "\n\t@Reference\n\tprivate HtmlParser _htmlParser;\n}");
        }
        return newContent;
    }
}

