/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class UpgradeJavaCheck
extends BaseFileCheck {
    private Map<String, String> _importsMap;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        return this._fixImports(javaClass, content);
    }

    private String _fixImports(JavaClass javaClass, String content) throws Exception {
        Map<String, String> importsMap = this._getImportsMap();
        for (String importName : javaClass.getImportNames()) {
            String newImportName = importsMap.get(importName);
            if (newImportName == null) continue;
            content = StringUtil.replace(content, StringBundler.concat("import ", importName, ";"), StringBundler.concat("import ", newImportName, ";"));
        }
        return content;
    }

    private synchronized Map<String, String> _getImportsMap() throws Exception {
        if (this._importsMap == null) {
            this._importsMap = this._getMap("/imports.txt");
        }
        return this._importsMap;
    }

    private Map<String, String> _getMap(String fileName) throws Exception {
        String[] lines;
        HashMap<String, String> map = new HashMap<String, String>();
        File importsFile = SourceFormatterUtil.getFile(this.getBaseDirName(), "modules/util/source-formatter/src/main/resources/dependencies/" + fileName, this.getMaxDirLevel());
        if (importsFile == null) {
            return map;
        }
        for (String line : lines = StringUtil.splitLines(FileUtil.read(importsFile))) {
            int separatorIndex = line.indexOf("=");
            map.put(line.substring(0, separatorIndex), line.substring(separatorIndex + 1));
        }
        return map;
    }
}

