/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public abstract class BaseServiceImplCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    protected String getEntityName(String className) {
        if (className.indexOf("LocalServiceImpl") > 0) {
            return className.substring(0, className.indexOf("LocalServiceImpl"));
        }
        return className.substring(0, className.indexOf("ServiceImpl"));
    }

    protected List<String> getErcEnabledEntityNames(Document document) {
        if (document == null) {
            return Collections.emptyList();
        }
        Element serviceXMLElement = document.getRootElement();
        Iterator iterator = serviceXMLElement.elementIterator("entity");
        ArrayList<String> ercEnabledEntityNames = new ArrayList<String>();
        block0: while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element.attributeValue("external-reference-code") != null) {
                ercEnabledEntityNames.add(element.attributeValue("name"));
                continue;
            }
            Iterator columnIterator = element.elementIterator("column");
            while (columnIterator.hasNext()) {
                Element columnElement = (Element)columnIterator.next();
                if (!StringUtil.equals(columnElement.attributeValue("name"), "externalReferenceCode")) continue;
                ercEnabledEntityNames.add(element.attributeValue("name"));
                continue block0;
            }
        }
        return ercEnabledEntityNames;
    }

    protected Document getServiceXmlDocument(String absolutePath) throws DocumentException, IOException {
        Path serviceXmlPath = Paths.get(absolutePath, new String[0]);
        while (!(serviceXmlPath = serviceXmlPath.getParent()).endsWith("src")) {
        }
        serviceXmlPath = serviceXmlPath.getParent();
        File file = (serviceXmlPath = serviceXmlPath.resolve("service.xml")).toFile();
        if (!file.exists()) {
            return null;
        }
        return SourceUtil.readXML(FileUtil.read(file));
    }

    protected boolean isApplicableCheck(String entityName, String entityReturnType, String javaTermName) {
        return javaTermName.equals("add") || javaTermName.equals("add" + entityReturnType) || javaTermName.startsWith("add") && StringUtil.equals(entityName, entityReturnType);
    }

    protected boolean isInsideComment(String content, int pos) {
        String s = content.substring(pos);
        int x = s.indexOf("*/");
        if (x == -1) {
            return false;
        }
        return !(s = s.substring(0, x)).contains("/*");
    }
}

