/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.ExcludeSyntax;
import com.liferay.source.formatter.ExcludeSyntaxPattern;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.check.configuration.ConfigurationLoader;
import com.liferay.source.formatter.check.configuration.SourceCheckConfiguration;
import com.liferay.source.formatter.check.configuration.SourceFormatterConfiguration;
import com.liferay.source.formatter.check.configuration.SourceFormatterSuppressions;
import com.liferay.source.formatter.check.configuration.SuppressionsLoader;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.processor.BNDRunSourceProcessor;
import com.liferay.source.formatter.processor.BNDSourceProcessor;
import com.liferay.source.formatter.processor.CETSourceProcessor;
import com.liferay.source.formatter.processor.CQLSourceProcessor;
import com.liferay.source.formatter.processor.CSSSourceProcessor;
import com.liferay.source.formatter.processor.CodeownersSourceProcessor;
import com.liferay.source.formatter.processor.ConfigSourceProcessor;
import com.liferay.source.formatter.processor.DTDSourceProcessor;
import com.liferay.source.formatter.processor.DockerfileSourceProcessor;
import com.liferay.source.formatter.processor.FTLSourceProcessor;
import com.liferay.source.formatter.processor.GradleSourceProcessor;
import com.liferay.source.formatter.processor.GroovySourceProcessor;
import com.liferay.source.formatter.processor.HTMLSourceProcessor;
import com.liferay.source.formatter.processor.JSONSourceProcessor;
import com.liferay.source.formatter.processor.JSPSourceProcessor;
import com.liferay.source.formatter.processor.JSSourceProcessor;
import com.liferay.source.formatter.processor.JavaSourceProcessor;
import com.liferay.source.formatter.processor.LDIFSourceProcessor;
import com.liferay.source.formatter.processor.LFRBuildSourceProcessor;
import com.liferay.source.formatter.processor.MarkdownSourceProcessor;
import com.liferay.source.formatter.processor.PackageinfoSourceProcessor;
import com.liferay.source.formatter.processor.PoshiSourceProcessor;
import com.liferay.source.formatter.processor.PropertiesSourceProcessor;
import com.liferay.source.formatter.processor.PythonSourceProcessor;
import com.liferay.source.formatter.processor.SHSourceProcessor;
import com.liferay.source.formatter.processor.SQLSourceProcessor;
import com.liferay.source.formatter.processor.SourceProcessor;
import com.liferay.source.formatter.processor.SoySourceProcessor;
import com.liferay.source.formatter.processor.TFSourceProcessor;
import com.liferay.source.formatter.processor.TLDSourceProcessor;
import com.liferay.source.formatter.processor.TSSourceProcessor;
import com.liferay.source.formatter.processor.TXTSourceProcessor;
import com.liferay.source.formatter.processor.UpgradeSourceProcessor;
import com.liferay.source.formatter.processor.XMLSourceProcessor;
import com.liferay.source.formatter.processor.YMLSourceProcessor;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.JIRAUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SourceFormatter {
    private static final String _PROPERTIES_FILE_NAME = "source-formatter.properties";
    private static final int _SUBREPOSITORY_MAX_DIR_LEVEL = 3;
    private List<String> _allFileNames;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private List<String> _pluginsInsideModulesDirectoryNames;
    private boolean _portalSource;
    private String _projectPathPrefix;
    private Map<String, Properties> _propertiesMap;
    private final SourceFormatterArgs _sourceFormatterArgs;
    private SourceFormatterConfiguration _sourceFormatterConfiguration;
    private final SourceFormatterExcludes _sourceFormatterExcludes = new SourceFormatterExcludes();
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new ConcurrentSkipListSet<SourceFormatterMessage>();
    private SourceFormatterSuppressions _sourceFormatterSuppressions;
    private final List<SourceMismatchException> _sourceMismatchExceptions = new CopyOnWriteArrayList<SourceMismatchException>();
    private final List<SourceProcessor> _sourceProcessors = new ArrayList<SourceProcessor>();
    private boolean _subrepository;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            Object[] sourceFormatterProperties;
            SourceFormatterArgs sourceFormatterArgs = new SourceFormatterArgs();
            sourceFormatterArgs.setAutoFix(ArgumentsUtil.getBoolean(arguments, "source.auto.fix", true));
            String baseDirName = ArgumentsUtil.getString(arguments, "source.base.dir", "./");
            sourceFormatterArgs.setBaseDirName(baseDirName);
            sourceFormatterArgs.setCheckCategoryNames(ListUtil.fromString(ArgumentsUtil.getString(arguments, "source.check.category.names", null), ","));
            sourceFormatterArgs.setCheckNames(ListUtil.fromString(ArgumentsUtil.getString(arguments, "source.check.names", null), ","));
            sourceFormatterArgs.setFailOnAutoFix(ArgumentsUtil.getBoolean(arguments, "source.fail.on.auto.fix", false));
            sourceFormatterArgs.setFailOnHasWarning(ArgumentsUtil.getBoolean(arguments, "source.fail.on.has.warning", true));
            sourceFormatterArgs.setFormatCurrentBranch(ArgumentsUtil.getBoolean(arguments, "format.current.branch", false));
            sourceFormatterArgs.setFormatLatestAuthor(ArgumentsUtil.getBoolean(arguments, "format.latest.author", false));
            sourceFormatterArgs.setFormatLocalChanges(ArgumentsUtil.getBoolean(arguments, "format.local.changes", false));
            sourceFormatterArgs.setGitWorkingBranchName(ArgumentsUtil.getString(arguments, "git.working.branch.name", "master"));
            int commitCount = ArgumentsUtil.getInteger(arguments, "commit.count", 0);
            sourceFormatterArgs.setCommitCount(commitCount);
            if (commitCount > 0) {
                sourceFormatterArgs.addRecentChangesFileNames(GitUtil.getModifiedFileNames(baseDirName, commitCount), baseDirName);
            } else if (sourceFormatterArgs.isFormatCurrentBranch()) {
                sourceFormatterArgs.addRecentChangesFileNames(GitUtil.getCurrentBranchFileNames(baseDirName, sourceFormatterArgs.getGitWorkingBranchName(), false), baseDirName);
            } else if (sourceFormatterArgs.isFormatLatestAuthor()) {
                sourceFormatterArgs.addRecentChangesFileNames(GitUtil.getLatestAuthorFileNames(baseDirName, false), baseDirName);
            } else if (sourceFormatterArgs.isFormatLocalChanges()) {
                sourceFormatterArgs.addRecentChangesFileNames(GitUtil.getLocalChangesFileNames(baseDirName, false), baseDirName);
            }
            Object[] fileNames = StringUtil.split(ArgumentsUtil.getString(arguments, "source.files", ""), ",");
            if (ArrayUtil.isNotEmpty(fileNames)) {
                sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
            } else {
                String fileExtensionsString = ArgumentsUtil.getString(arguments, "source.file.extensions", "");
                String[] fileExtensions = StringUtil.split(fileExtensionsString, ",");
                sourceFormatterArgs.setFileExtensions(Arrays.asList(fileExtensions));
            }
            sourceFormatterArgs.setIncludeGeneratedFiles(ArgumentsUtil.getBoolean(arguments, "include.generated.files", false));
            boolean includeSubrepositories = ArgumentsUtil.getBoolean(arguments, "include.subrepositories", false);
            for (String recentChangesFileName : sourceFormatterArgs.getRecentChangesFileNames()) {
                if (!recentChangesFileName.endsWith("ci-merge")) continue;
                includeSubrepositories = true;
                break;
            }
            sourceFormatterArgs.setIncludeSubrepositories(includeSubrepositories);
            sourceFormatterArgs.setJavaParserEnabled(ArgumentsUtil.getBoolean(arguments, "java.parser.enabled", true));
            sourceFormatterArgs.setMaxLineLength(ArgumentsUtil.getInteger(arguments, "max.line.length", 80));
            sourceFormatterArgs.setMaxDirLevel(Math.max(7, StringUtil.count(baseDirName, '/') + 1));
            sourceFormatterArgs.setOutputFileName(ArgumentsUtil.getString(arguments, "output.file.name", SourceFormatterArgs.OUTPUT_FILE_NAME));
            sourceFormatterArgs.setPrintErrors(ArgumentsUtil.getBoolean(arguments, "source.print.errors", true));
            sourceFormatterArgs.setProcessorThreadCount(ArgumentsUtil.getInteger(arguments, "processor.thread.count", 5));
            sourceFormatterArgs.setShowDebugInformation(ArgumentsUtil.getBoolean(arguments, "show.debug.information", false));
            Object[] skipCheckNames = StringUtil.split(ArgumentsUtil.getString(arguments, "skip.check.names", ""), ",");
            if (ArrayUtil.isNotEmpty(skipCheckNames)) {
                sourceFormatterArgs.setSkipCheckNames(Arrays.asList(skipCheckNames));
            }
            if (ArrayUtil.isNotEmpty(sourceFormatterProperties = StringUtil.split(ArgumentsUtil.getString(arguments, "source.formatter.properties", ""), "\\n"))) {
                sourceFormatterArgs.setSourceFormatterProperties(Arrays.asList(sourceFormatterProperties));
            }
            sourceFormatterArgs.setValidateCommitMessages(ArgumentsUtil.getBoolean(arguments, "validate.commit.messages", false));
            SourceFormatter sourceFormatter = new SourceFormatter(sourceFormatterArgs);
            sourceFormatter.format();
        }
        catch (Exception exception) {
            if (exception instanceof GitException) {
                System.out.println(exception.getMessage());
            } else {
                CheckstyleException checkstyleException = SourceFormatter._getNestedCheckstyleException(exception);
                if (checkstyleException != null) {
                    checkstyleException.printStackTrace();
                } else {
                    exception.printStackTrace();
                }
            }
            System.exit(1);
        }
    }

    public SourceFormatter(SourceFormatterArgs sourceFormatterArgs) {
        this._sourceFormatterArgs = sourceFormatterArgs;
        System.setProperty("java.awt.headless", "true");
    }

    public void format() throws Exception {
        String string;
        System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        this._init();
        if (this._sourceFormatterArgs.isValidateCommitMessages()) {
            this._validateCommitMessages();
        }
        if (!this._sourceFormatterArgs.isJavaParserEnabled()) {
            System.out.println(StringBundler.concat("WARNING: Setting property 'java.parser.enabled' to ", "'false' may prevent certain Java/JSP checks from working ", "properly."));
        }
        this._sourceProcessors.add(new BNDRunSourceProcessor());
        this._sourceProcessors.add(new BNDSourceProcessor());
        this._sourceProcessors.add(new CodeownersSourceProcessor());
        this._sourceProcessors.add(new ConfigSourceProcessor());
        this._sourceProcessors.add(new CQLSourceProcessor());
        this._sourceProcessors.add(new CSSSourceProcessor());
        this._sourceProcessors.add(new DockerfileSourceProcessor());
        this._sourceProcessors.add(new DTDSourceProcessor());
        this._sourceProcessors.add(new FTLSourceProcessor());
        this._sourceProcessors.add(new GradleSourceProcessor());
        this._sourceProcessors.add(new GroovySourceProcessor());
        this._sourceProcessors.add(new HTMLSourceProcessor());
        this._sourceProcessors.add(new JavaSourceProcessor());
        this._sourceProcessors.add(new JSONSourceProcessor());
        this._sourceProcessors.add(new JSPSourceProcessor());
        this._sourceProcessors.add(new JSSourceProcessor());
        this._sourceProcessors.add(new LDIFSourceProcessor());
        this._sourceProcessors.add(new LFRBuildSourceProcessor());
        this._sourceProcessors.add(new MarkdownSourceProcessor());
        this._sourceProcessors.add(new PackageinfoSourceProcessor());
        this._sourceProcessors.add(new PoshiSourceProcessor());
        this._sourceProcessors.add(new PropertiesSourceProcessor());
        this._sourceProcessors.add(new PythonSourceProcessor());
        this._sourceProcessors.add(new SHSourceProcessor());
        this._sourceProcessors.add(new SoySourceProcessor());
        this._sourceProcessors.add(new SQLSourceProcessor());
        this._sourceProcessors.add(new TFSourceProcessor());
        this._sourceProcessors.add(new TLDSourceProcessor());
        this._sourceProcessors.add(new TSSourceProcessor());
        this._sourceProcessors.add(new TXTSourceProcessor());
        this._sourceProcessors.add(new UpgradeSourceProcessor());
        this._sourceProcessors.add(new XMLSourceProcessor());
        this._sourceProcessors.add(new YMLSourceProcessor());
        this._sourceProcessors.add(new CETSourceProcessor());
        ExecutorService executorService = Executors.newFixedThreadPool(this._sourceProcessors.size());
        ArrayList<Future> futures = new ArrayList<Future>(this._sourceProcessors.size());
        for (final SourceProcessor sourceProcessor : this._sourceProcessors) {
            Future future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    return null;
                }
            });
            futures.add(future);
        }
        ExecutionException executionException1 = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException executionException2) {
                if (executionException1 == null) {
                    executionException1 = executionException2;
                    continue;
                }
                executionException1.addSuppressed(executionException2);
            }
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(20L);
        }
        if (this._sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.printSourceFormatterInformation();
        }
        if (executionException1 != null) {
            throw executionException1;
        }
        if (!(this._sourceFormatterMessages.isEmpty() && this._sourceMismatchExceptions.isEmpty() || (string = this._sourceFormatterArgs.getOutputFileName()) == null)) {
            File directory;
            File file = null;
            int pos = string.lastIndexOf(File.separator);
            if (pos != -1 && (directory = new File(string.substring(0, pos))).exists()) {
                file = new File(string);
            }
            if (file == null) {
                file = new File(this._sourceFormatterArgs.getBaseDirName() + string);
            }
            FileUtil.write(file, this._getOutputFileContent());
        }
        if (this._sourceFormatterArgs.isFailOnAutoFix() && !this._sourceMismatchExceptions.isEmpty() || this._sourceFormatterArgs.isFailOnHasWarning() && !this._sourceFormatterMessages.isEmpty()) {
            throw new Exception(this._getExceptionMessage());
        }
    }

    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    public SourceFormatterArgs getSourceFormatterArgs() {
        return this._sourceFormatterArgs;
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return this._sourceFormatterMessages;
    }

    public List<SourceMismatchException> getSourceMismatchExceptions() {
        return this._sourceMismatchExceptions;
    }

    private static CheckstyleException _getNestedCheckstyleException(Exception exception) {
        Throwable throwable = exception;
        while (throwable != null) {
            if (throwable instanceof CheckstyleException) {
                return (CheckstyleException)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    private Set<String> _addDependentFileName(Set<String> dependentFileNames, String fileName) {
        File file = new File(this._sourceFormatterArgs.getBaseDirName() + fileName);
        if (file.exists()) {
            dependentFileNames.add(this._sourceFormatterArgs.getBaseDirName() + fileName);
        }
        return dependentFileNames;
    }

    private Set<String> _addDependentFileName(Set<String> dependentFileNames, String fileName, String dependentFileName) {
        String dirName = fileName.substring(0, fileName.lastIndexOf(47));
        while (true) {
            String dependentFilePathName;
            File file;
            if ((file = new File(dependentFilePathName = dirName + "/" + dependentFileName)).exists()) {
                dependentFileNames.add(dependentFilePathName);
                return dependentFileNames;
            }
            int pos = dirName.lastIndexOf(47);
            if (pos == -1) {
                return dependentFileNames;
            }
            dirName = dirName.substring(0, pos);
        }
    }

    private void _addDependentFileNames() throws Exception {
        Set<String> recentChangesFileNames = this._sourceFormatterArgs.getRecentChangesFileNames();
        if (recentChangesFileNames == null) {
            return;
        }
        Set<String> dependentFileNames = new HashSet<String>();
        boolean buildPropertiesAdded = false;
        boolean tagJavaFilesAdded = false;
        for (String string : recentChangesFileNames) {
            if (!buildPropertiesAdded && string.endsWith(".lfrbuild-portal")) {
                dependentFileNames = this._addDependentFileName(dependentFileNames, "build.properties");
                buildPropertiesAdded = true;
            }
            if (string.contains("/modules/apps/archived/")) {
                dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/source-formatter.properties", "**/test.properties"}, this._sourceFormatterExcludes, false));
            }
            if (string.endsWith(".java") && string.contains("/upgrade/")) {
                dependentFileNames = this._addDependentFileName(dependentFileNames, string, "bnd.bnd");
                continue;
            }
            if (string.endsWith("ServiceImpl.java")) {
                dependentFileNames = this._addDependentFileName(dependentFileNames, string, "service.xml");
                continue;
            }
            if (!tagJavaFilesAdded && string.endsWith(".tld")) {
                dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/*Tag.java"}, this._sourceFormatterExcludes, false));
                tagJavaFilesAdded = true;
                continue;
            }
            if (string.endsWith("/modules/source-formatter.properties")) {
                dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/build.gradle"}, this._sourceFormatterExcludes, false));
                continue;
            }
            if (string.endsWith(this._sourceFormatterArgs.getBaseDirName() + "release.properties")) {
                dependentFileNames.add(this._sourceFormatterArgs.getBaseDirName() + "/modules/sdk/ant-bnd/src/main/java/com/liferay/ant/bnd/social/SocialAnalyzerPlugin.java");
                dependentFileNames.add(this._sourceFormatterArgs.getBaseDirName() + "/portal-impl/src/com/liferay/portal/util/EntityResolver.java");
                dependentFileNames.add(this._sourceFormatterArgs.getBaseDirName() + "/portal-impl/src/com/liferay/portlet/social/util/SocialConfigurationImpl.java");
                continue;
            }
            if (!this._isFrontendPackageChanges(string)) continue;
            dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/package.json"}, this._sourceFormatterExcludes, false));
        }
        if (this._sourceFormatterArgs.isFormatCurrentBranch()) {
            List<String> deletedFileNames;
            if (!buildPropertiesAdded) {
                List<String> fileNames = GitUtil.getCurrentBranchFileNames(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getGitWorkingBranchName(), true);
                for (String fileName : fileNames) {
                    if (buildPropertiesAdded || !fileName.endsWith(".lfrbuild-portal")) continue;
                    dependentFileNames = this._addDependentFileName(dependentFileNames, "build.properties");
                    break;
                }
            }
            if (!(deletedFileNames = GitUtil.getCurrentBranchDeletedFileNames(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getGitWorkingBranchName())).isEmpty()) {
                dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/source-formatter.properties", "**/source-formatter-suppressions.xml"}, this._sourceFormatterExcludes, false));
            }
            if (this._isFeatureFlagChanges()) {
                File file = SourceFormatterUtil.getPortalDir(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getMaxLineLength());
                dependentFileNames.add(file + "/portal-impl/src/portal.properties");
            }
        }
        this._sourceFormatterArgs.addRecentChangesFileNames(dependentFileNames, null);
    }

    private boolean _containsDir(String dirName) {
        File directory = SourceFormatterUtil.getFile(this._sourceFormatterArgs.getBaseDirName(), dirName, this._sourceFormatterArgs.getMaxDirLevel());
        return directory != null;
    }

    private void _excludeWorkingDirCheckoutPrivateApps(File portalDir) throws Exception {
        File file = new File(portalDir, "working.dir.properties");
        if (!file.exists()) {
            return;
        }
        Properties properties = this._getProperties(file);
        for (Object key : properties.keySet()) {
            String s = (String)key;
            if (!s.matches("working.dir.checkout.private.apps.(\\w)+.dirs")) continue;
            List<String> dirs = ListUtil.fromString(properties.getProperty(s), ",");
            for (String dir : dirs) {
                this._sourceFormatterExcludes.addDefaultExcludeSyntaxPatterns(this._getExcludeSyntaxPatterns("**/" + dir + "/**"));
            }
        }
    }

    private List<String> _getCheckNames() {
        ArrayList<String> checkNames = new ArrayList<String>();
        for (String sourceProcessorName : this._sourceFormatterConfiguration.getSourceProcessorNames()) {
            for (SourceCheckConfiguration sourceCheckConfiguration : this._sourceFormatterConfiguration.getSourceCheckConfigurations(sourceProcessorName)) {
                checkNames.add(sourceCheckConfiguration.getName());
            }
        }
        return checkNames;
    }

    private String _getExceptionMessage() {
        int size = this._sourceFormatterMessages.size() + this._sourceMismatchExceptions.size();
        StringBundler sb = new StringBundler(size * 4);
        int index = 1;
        if (this._sourceFormatterArgs.isFailOnHasWarning()) {
            for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
                sb.append(index);
                sb.append(": ");
                sb.append(sourceFormatterMessage.toString());
                sb.append("\n");
                ++index;
            }
        }
        if (this._sourceFormatterArgs.isFailOnAutoFix()) {
            for (SourceMismatchException sourceMismatchException : this._sourceMismatchExceptions) {
                String message = sourceMismatchException.getMessage();
                if (Objects.isNull(message)) continue;
                sb.append(index);
                sb.append(": ");
                sb.append(message);
                sb.append("\n");
                ++index;
            }
        }
        return StringBundler.concat("Found ", index - 1, " formatting issues:\n", sb.toString());
    }

    private List<ExcludeSyntaxPattern> _getExcludeSyntaxPatterns(String sourceFormatterExcludes) {
        ArrayList<ExcludeSyntaxPattern> excludeSyntaxPatterns = new ArrayList<ExcludeSyntaxPattern>();
        List<String> excludes = ListUtil.fromString(sourceFormatterExcludes, ",");
        for (String exclude : excludes) {
            excludeSyntaxPatterns.add(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        String systemExcludes = System.getProperty("source.formatter.excludes");
        excludes = ListUtil.fromString(GetterUtil.getString(systemExcludes));
        for (String exclude : excludes) {
            excludeSyntaxPatterns.add(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        return excludeSyntaxPatterns;
    }

    private String _getOutputFileContent() {
        JSONObjectImpl jsonObject = new JSONObjectImpl();
        JSONArrayImpl modifiedFilesJSONArray = new JSONArrayImpl();
        for (SourceMismatchException sourceMismatchException : this._sourceMismatchExceptions) {
            modifiedFilesJSONArray.put(sourceMismatchException.getFileName());
        }
        jsonObject.put("modifiedFileNames", modifiedFilesJSONArray);
        JSONArrayImpl checksJSONArray = new JSONArrayImpl();
        JSONObject checkJSONObject = null;
        String currentCheckName = null;
        JSONArrayImpl violationsJSONArray = null;
        TreeSet<SourceFormatterMessage> sortedSourceFormatterMessages = new TreeSet<SourceFormatterMessage>(new SourceFormatterMessageCheckNameComparator());
        sortedSourceFormatterMessages.addAll(this._sourceFormatterMessages);
        int violationsCount = 0;
        for (SourceFormatterMessage sourceFormatterMessage : sortedSourceFormatterMessages) {
            String checkName = sourceFormatterMessage.getCheckName();
            if (checkName == null) continue;
            if (!Objects.equals(checkName, currentCheckName)) {
                if (currentCheckName != null) {
                    checkJSONObject.put("violations", violationsJSONArray);
                    checksJSONArray.put(checkJSONObject);
                }
                checkJSONObject = new JSONObjectImpl();
                checkJSONObject.put("name", checkName);
                String documentationURLString = sourceFormatterMessage.getDocumentationURLString();
                if (documentationURLString != null) {
                    checkJSONObject.put("documentationURLString", sourceFormatterMessage.getDocumentationURLString());
                }
                violationsJSONArray = new JSONArrayImpl();
                currentCheckName = checkName;
            }
            JSONObjectImpl violationJSONObject = new JSONObjectImpl();
            violationJSONObject.put("fileName", sourceFormatterMessage.getFileName()).put("lineNumber", sourceFormatterMessage.getLineNumber()).put("message", sourceFormatterMessage.getMessage());
            ++violationsCount;
            violationsJSONArray.put(violationJSONObject);
        }
        if (checkJSONObject != null) {
            checkJSONObject.put("violations", violationsJSONArray);
            checksJSONArray.put(checkJSONObject);
            jsonObject.put("checks", checksJSONArray);
        }
        jsonObject.put("violationsCount", violationsCount);
        return JSONUtil.toString(jsonObject);
    }

    private List<String> _getPluginsInsideModulesDirectoryNames() {
        ArrayList<String> pluginsInsideModulesDirectoryNames = new ArrayList<String>();
        List<String> pluginBuildFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/modules/apps/**/build.xml", "**/modules/dxp/apps/**/build.xml", "**/modules/private/apps/**/build.xml"}, this._sourceFormatterExcludes, true);
        for (String pluginBuildFileName : pluginBuildFileNames) {
            String absolutePath = SourceUtil.getAbsolutePath(pluginBuildFileName = StringUtil.replace(pluginBuildFileName, '\\', '/'));
            int x = absolutePath.indexOf("/modules/apps/");
            if (x == -1) {
                x = absolutePath.indexOf("/modules/dxp/apps/");
            }
            if (x == -1) {
                x = absolutePath.indexOf("/modules/private/apps/");
            }
            int y = absolutePath.lastIndexOf("/");
            pluginsInsideModulesDirectoryNames.add(absolutePath.substring(x, y + 1));
        }
        return pluginsInsideModulesDirectoryNames;
    }

    private String _getPortalBranchName() {
        for (Map.Entry<String, Properties> entry : this._propertiesMap.entrySet()) {
            Properties properties = entry.getValue();
            if (!properties.containsKey("git.liferay.portal.branch")) continue;
            return properties.getProperty("git.liferay.portal.branch");
        }
        return null;
    }

    private String _getProjectPathPrefix() throws Exception {
        if (!this._subrepository) {
            return null;
        }
        String fileName = "gradle.properties";
        for (int i = 0; i < this._sourceFormatterArgs.getMaxDirLevel(); ++i) {
            File file = new File(this._sourceFormatterArgs.getBaseDirName() + fileName);
            if (file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                if (properties.containsKey("project.path.prefix")) {
                    return properties.getProperty("project.path.prefix");
                }
            }
            fileName = "../" + fileName;
        }
        return null;
    }

    private Properties _getProperties(File file) throws Exception {
        Properties properties = new Properties();
        if (file.exists()) {
            properties.load(new FileInputStream(file));
        }
        return properties;
    }

    private List<String> _getPropertyValues(String key) {
        ArrayList<String> propertyValues = new ArrayList<String>();
        for (Map.Entry<String, Properties> entry : this._propertiesMap.entrySet()) {
            Properties properties = entry.getValue();
            if (!properties.containsKey(key)) continue;
            propertyValues.addAll(ListUtil.fromString(properties.getProperty(key), ","));
        }
        return propertyValues;
    }

    private void _init() throws Exception {
        this._sourceFormatterExcludes.addDefaultExcludeSyntaxPatterns(ListUtil.fromArray(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.git/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.gradle/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.idea/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.m2/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.settings/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/bin/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/build/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/classes/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/liferay-theme.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/npm-shrinkwrap.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/package-lock.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-classes/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-coverage/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-results/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/tmp/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/node_modules_cache/**"), new ExcludeSyntaxPattern(ExcludeSyntax.REGEX, ".*/frontend-theme-unstyled/.*/_unstyled/css/clay/.+"), new ExcludeSyntaxPattern(ExcludeSyntax.REGEX, ".*/frontend-theme-unstyled/.*/_unstyled/images/(aui|clay|lexicon)/.+"), new ExcludeSyntaxPattern(ExcludeSyntax.REGEX, ".*/tests?/.*/dependencies/.+\\.(jar|lar|war|zip)/.+"), new ExcludeSyntaxPattern(ExcludeSyntax.REGEX, "^((?!/frontend-js-node-shims/src/).)*/node_modules/.*")));
        this._portalSource = this._containsDir("portal-impl");
        if (this._portalSource) {
            this._excludeWorkingDirCheckoutPrivateApps(SourceFormatterUtil.getPortalDir(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getMaxLineLength()));
        }
        this._propertiesMap = new HashMap<String, Properties>();
        String parentDirName = this._sourceFormatterArgs.getBaseDirName();
        for (int i = 0; i < this._sourceFormatterArgs.getMaxDirLevel(); ++i) {
            this._readProperties(new File(parentDirName + _PROPERTIES_FILE_NAME));
            parentDirName = parentDirName + "../";
        }
        this._allFileNames = SourceFormatterUtil.scanForFiles(this._sourceFormatterArgs.getBaseDirName(), new String[0], new String[]{"**/*.*", "**/CODEOWNERS", "**/Dockerfile", "**/packageinfo"}, this._sourceFormatterExcludes, this._sourceFormatterArgs.isIncludeSubrepositories());
        List<String> modulePropertiesFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/source-formatter.properties"}, this._sourceFormatterExcludes, true);
        for (String modulePropertiesFileName : modulePropertiesFileNames) {
            this._readProperties(new File(modulePropertiesFileName));
        }
        for (Properties properties : this._propertiesMap.values()) {
            if (!GetterUtil.getBoolean(properties.get("liferay.source"))) continue;
            this._portalSource = true;
            break;
        }
        if (!this._portalSource && this._containsDir("modules/private/apps")) {
            String propertiesContent = SourceFormatterUtil.getGitContent(_PROPERTIES_FILE_NAME, this._getPortalBranchName());
            this._readProperties(propertiesContent, SourceUtil.getAbsolutePath(this._sourceFormatterArgs.getBaseDirName()));
        }
        for (String sourceFormatterProperty : this._sourceFormatterArgs.getSourceFormatterProperties()) {
            this._readProperties(sourceFormatterProperty, SourceUtil.getAbsolutePath(this._sourceFormatterArgs.getBaseDirName()));
        }
        this._addDependentFileNames();
        this._pluginsInsideModulesDirectoryNames = this._getPluginsInsideModulesDirectoryNames();
        this._subrepository = this._isSubrepository();
        this._projectPathPrefix = this._getProjectPathPrefix();
        this._sourceFormatterSuppressions = SuppressionsLoader.loadSuppressions(this._sourceFormatterArgs.getBaseDirName(), SourceFormatterUtil.getSuppressionsFiles(this._sourceFormatterArgs.getBaseDirName(), this._allFileNames, this._sourceFormatterExcludes, this._sourceFormatterArgs.getMaxDirLevel()), this._propertiesMap);
        this._sourceFormatterConfiguration = ConfigurationLoader.loadConfiguration("sourcechecks.xml");
        if (this._sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.addCheckNames(CheckType.SOURCE_CHECK, this._getCheckNames());
        }
    }

    private boolean _isFeatureFlagChanges() throws Exception {
        String currentBranchDiff = GitUtil.getCurrentBranchDiff(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getGitWorkingBranchName());
        for (String line : StringUtil.split(currentBranchDiff, "\n")) {
            if (!line.startsWith("-") && !line.startsWith("+") || !line.contains("feature.flag") && !line.contains("Liferay-Site-Initializer-Feature-Flag:")) continue;
            return true;
        }
        return false;
    }

    private boolean _isFrontendPackageChanges(String recentChangesFileName) {
        return recentChangesFileName.endsWith("/modules/apps/frontend-js/frontend-js-metal-web/package.json") || recentChangesFileName.endsWith("/modules/apps/frontend-js/frontend-js-react-web/package.json") || recentChangesFileName.endsWith("/modules/apps/frontend-js/frontend-js-spa-web/package.json") || recentChangesFileName.endsWith("/modules/apps/frontend-taglib/frontend-taglib-clay/package.json");
    }

    private boolean _isSubrepository() throws Exception {
        if (this._portalSource) {
            return false;
        }
        String baseDirAbsolutePath = SourceUtil.getAbsolutePath(this._sourceFormatterArgs.getBaseDirName());
        File baseDir = new File(baseDirAbsolutePath);
        for (int i = 0; i < 3; ++i) {
            String content;
            if (baseDir == null || !baseDir.exists()) {
                return false;
            }
            File gradlePropertiesFile = new File(baseDir, "gradle.properties");
            File gradlewFile = new File(baseDir, "gradlew");
            if (gradlePropertiesFile.exists() && gradlewFile.exists() && (content = FileUtil.read(gradlePropertiesFile)).contains("project.path.prefix=")) {
                return true;
            }
            baseDir = baseDir.getParentFile();
        }
        return false;
    }

    private void _readProperties(File propertiesFile) throws Exception {
        Properties properties = this._getProperties(propertiesFile);
        if (properties.isEmpty()) {
            return;
        }
        String propertiesFileLocation = SourceUtil.getAbsolutePath(propertiesFile);
        int pos = propertiesFileLocation.lastIndexOf("/");
        propertiesFileLocation = propertiesFileLocation.substring(0, pos);
        this._readProperties(properties, propertiesFileLocation);
    }

    private void _readProperties(Properties properties, String propertiesFileLocation) {
        Properties existingProperties;
        String value = properties.getProperty("source.formatter.excludes");
        if (value != null) {
            if (FileUtil.exists(propertiesFileLocation + "portal-impl")) {
                this._sourceFormatterExcludes.addDefaultExcludeSyntaxPatterns(this._getExcludeSyntaxPatterns(value));
            } else {
                this._sourceFormatterExcludes.addExcludeSyntaxPatterns(propertiesFileLocation, this._getExcludeSyntaxPatterns(value));
            }
            properties.remove("source.formatter.excludes");
        }
        if ((existingProperties = this._propertiesMap.get(propertiesFileLocation)) == null) {
            this._propertiesMap.put(propertiesFileLocation, properties);
        } else {
            existingProperties.putAll((Map<?, ?>)properties);
            this._propertiesMap.put(propertiesFileLocation, existingProperties);
        }
    }

    private void _readProperties(String content, String propertiesFileLocation) throws Exception {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        if (properties.isEmpty()) {
            return;
        }
        this._readProperties(properties, propertiesFileLocation);
    }

    private void _runSourceProcessor(SourceProcessor sourceProcessor) throws Exception {
        sourceProcessor.setAllFileNames(this._allFileNames);
        sourceProcessor.setPluginsInsideModulesDirectoryNames(this._pluginsInsideModulesDirectoryNames);
        sourceProcessor.setPortalSource(this._portalSource);
        sourceProcessor.setProjectPathPrefix(this._projectPathPrefix);
        sourceProcessor.setPropertiesMap(this._propertiesMap);
        sourceProcessor.setSourceFormatterArgs(this._sourceFormatterArgs);
        sourceProcessor.setSourceFormatterConfiguration(this._sourceFormatterConfiguration);
        sourceProcessor.setSourceFormatterExcludes(this._sourceFormatterExcludes);
        sourceProcessor.setSourceFormatterSuppressions(this._sourceFormatterSuppressions);
        sourceProcessor.setSubrepository(this._subrepository);
        sourceProcessor.format();
        this._modifiedFileNames.addAll(sourceProcessor.getModifiedFileNames());
        this._sourceFormatterMessages.addAll(sourceProcessor.getSourceFormatterMessages());
        this._sourceMismatchExceptions.addAll(sourceProcessor.getSourceMismatchExceptions());
    }

    private void _validateCommitMessages() throws Exception {
        List<String> commitMessages = GitUtil.getCurrentBranchCommitMessages(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getGitWorkingBranchName());
        JIRAUtil.validateJIRAProjectNames(commitMessages, this._getPropertyValues("jira.project.keys"));
        JIRAUtil.validateJIRATicketIds(commitMessages, 20);
        for (String commitMessage : commitMessages) {
            for (String keyword : this._getPropertyValues("git.commit.vulnerability.keywords")) {
                Pattern pattern = Pattern.compile("\\b_*(" + keyword + ")_*\\b", 2);
                Matcher matcher = pattern.matcher(commitMessage);
                if (!matcher.find()) continue;
                throw new Exception(StringBundler.concat("Found formatting issues:\n", "The commit '", commitMessage, "' contains the word '", keyword, "', which could reveal potential security ", "vulnerablities. Please see the vulnerability ", "keywords that are specified in source-formatter.", "properties in the liferay-portal repository."));
            }
        }
    }

    private static class SourceFormatterMessageCheckNameComparator
    implements Comparator<SourceFormatterMessage> {
        private SourceFormatterMessageCheckNameComparator() {
        }

        @Override
        public int compare(SourceFormatterMessage sourceFormatterMessage1, SourceFormatterMessage sourceFormatterMessage2) {
            String checkName1 = sourceFormatterMessage1.getCheckName();
            String checkName2 = sourceFormatterMessage2.getCheckName();
            if (checkName1 != null && checkName2 != null && !checkName1.equals(checkName2)) {
                return checkName1.compareTo(checkName2);
            }
            return sourceFormatterMessage1.compareTo(sourceFormatterMessage2);
        }
    }
}

