/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;

public class ResourcePermissionCheck
extends BaseCheck {
    private static final String _MSG_REMOVE_SERVICE_RANKING_PROPERTY = "remove.service.ranking.property";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String className = this.getName(detailAST);
        if (className.endsWith("ModelResourcePermission")) {
            this._checkModelResourcePermission(detailAST);
        }
    }

    private void _checkModelResourcePermission(DetailAST detailAST) {
        List<String> importNames = this.getImportNames(detailAST);
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || !importNames.contains("org.osgi.service.component.annotations.Component")) {
            return;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null) {
            return;
        }
        DetailAST propertyAnnotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "property");
        if (propertyAnnotationMemberValuePairDetailAST == null) {
            return;
        }
        DetailAST annotationArrayInitDetailAST = propertyAnnotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST == null) {
            return;
        }
        List<DetailAST> expressionDetailASTList = this.getAllChildTokens(annotationArrayInitDetailAST, false, 28);
        for (DetailAST expressionDetailAST : expressionDetailASTList) {
            String value;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139 || !(value = firstChildDetailAST.getText()).startsWith("\"service.ranking:")) continue;
            this.log(annotationArrayInitDetailAST, _MSG_REMOVE_SERVICE_RANKING_PROPERTY, new Object[]{value});
        }
    }
}

