/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class PropertiesLanguageKeysOrderCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/content/Language.properties")) {
            return content;
        }
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            TreeMap<String, String> messagesMap = new TreeMap<String, String>(new NaturalOrderStringComparator(true, true));
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] array = line.split("=", 2);
                if (array.length > 1) {
                    messagesMap.put(array[0], array[1]);
                    continue;
                }
                for (Map.Entry entry : messagesMap.entrySet()) {
                    sb.append((String)entry.getKey());
                    sb.append("=");
                    sb.append((String)entry.getValue());
                    sb.append("\n");
                }
                if (!messagesMap.isEmpty()) {
                    messagesMap.clear();
                }
                sb.append(line);
                sb.append("\n");
            }
            for (Map.Entry entry : messagesMap.entrySet()) {
                sb.append((String)entry.getKey());
                sb.append("=");
                sb.append((String)entry.getValue());
                sb.append("\n");
            }
            if (!messagesMap.isEmpty()) {
                messagesMap.clear();
            }
        }
        return StringUtil.trim(sb.toString());
    }
}

