/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;

public class JavaVerifyUpgradeConnectionCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (absolutePath.contains("/test/") || fileName.endsWith("DBUpgrader.java") || fileName.endsWith("Test.java") || fileName.endsWith("UpgradeTableListener.java") || content.contains("Callable<Void>")) {
            return content;
        }
        String className = JavaSourceUtil.getClassName(fileName);
        if (className.contains("Upgrade") || className.contains("Verify")) {
            this._checkConnectionField(fileName, content, "getConnection");
            this._checkConnectionField(fileName, content, "getUpgradeOptimizedConnection");
        }
        return content;
    }

    private void _checkConnectionField(String fileName, String content, String methodName) {
        int x = -1;
        while ((x = content.indexOf("DataAccess." + methodName, x + 1)) != -1) {
            this.addMessage(fileName, "Use existing connection field instead of DataAccess." + methodName, this.getLineNumber(content, x));
        }
    }
}

