/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDLiferayEnterpriseAppCheck
extends BaseFileCheck {
    private static final String _ENTERPRISE_APP_MODULE_PATH_NAMES_KEY = "enterpriseAppModulePathNames";
    private static final Pattern _dxpOnlyPattern = Pattern.compile("dxp.only=([^;]*)");

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("/bnd.bnd") || absolutePath.contains("-test/") || absolutePath.contains("-test-util/")) {
            return content;
        }
        List<String> enterpriseAppModulePathNames = this.getAttributeValues(_ENTERPRISE_APP_MODULE_PATH_NAMES_KEY, absolutePath);
        if (enterpriseAppModulePathNames.isEmpty()) {
            return content;
        }
        for (String enterpriseAppModulePathName : enterpriseAppModulePathNames) {
            if (!absolutePath.contains(enterpriseAppModulePathName)) continue;
            String liferayEnterpriseApp = BNDSourceUtil.getDefinitionValue(content, "Liferay-Enterprise-App");
            if (liferayEnterpriseApp == null) {
                this.addMessage(fileName, "Missing Liferay-Enterprise-App");
            }
            this._checkProperties(fileName, enterpriseAppModulePathName, liferayEnterpriseApp);
            return BNDSourceUtil.updateInstruction(content, "Liferay-Enterprise-App", this._sortProperties(liferayEnterpriseApp));
        }
        return content;
    }

    private void _checkProperties(String fileName, String absolutePath, String liferayEnterpriseApp) {
        Matcher matcher = _dxpOnlyPattern.matcher(liferayEnterpriseApp);
        if (absolutePath.contains("modules/dxp/apps/")) {
            if (!matcher.find() || !Objects.equals(matcher.group(1), "true")) {
                this.addMessage(fileName, "Enterprise apps in 'dxp/apps/' directory should always set 'dxp.only=true' in 'Liferay-Enterprise-App'");
            }
        } else if (matcher.find()) {
            this.addMessage(fileName, "Enterprise apps not in 'dxp/apps/' directory should not set 'dxp.only' in 'Liferay-Enterprise-App'");
        }
    }

    private String _sortProperties(String liferayEnterpriseApp) {
        String[] propertiesArray = StringUtil.split(liferayEnterpriseApp, ";");
        PropertyComparator propertyComparator = new PropertyComparator();
        for (int i = 1; i < propertiesArray.length; ++i) {
            String previousProperty = propertiesArray[i - 1];
            String property = propertiesArray[i];
            if (propertyComparator.compare(previousProperty, property) <= 0) continue;
            liferayEnterpriseApp = StringUtil.replaceFirst(liferayEnterpriseApp, previousProperty, property);
            liferayEnterpriseApp = StringUtil.replaceLast(liferayEnterpriseApp, property, previousProperty);
        }
        return liferayEnterpriseApp;
    }

    private class PropertyComparator
    extends NaturalOrderStringComparator {
        private PropertyComparator() {
        }

        @Override
        public int compare(String property1, String property2) {
            return super.compare(this._getPropertyName(property1), this._getPropertyName(property2));
        }

        private String _getPropertyName(String property) {
            int x = property.indexOf("=");
            if (x != -1) {
                return property.substring(0, x);
            }
            return property;
        }
    }
}

