/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseAsUsedCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class AssignAsUsedCheck
extends BaseAsUsedCheck {
    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> assignDetailASTList = this.getAllChildTokens(detailAST, true, 80);
        for (DetailAST assignDetailAST : assignDetailASTList) {
            DetailAST parentDetailAST = assignDetailAST.getParent();
            if (parentDetailAST.getType() != 28 || (parentDetailAST = parentDetailAST.getParent()).getType() != 7) continue;
            this._checkAssign(detailAST, assignDetailAST, this.getEndLineNumber(parentDetailAST));
        }
    }

    private void _checkAssign(DetailAST detailAST, DetailAST assignDetailAST, int endRange) {
        if (this.hasParentWithTokenType(assignDetailAST, 156, 35)) {
            return;
        }
        DetailAST nameDetailAST = assignDetailAST.findFirstToken(58);
        if (nameDetailAST == null) {
            return;
        }
        String variableName = nameDetailAST.getText();
        DetailAST typeDetailAST = this.getVariableTypeDetailAST(assignDetailAST, variableName, false);
        if (typeDetailAST == null) {
            return;
        }
        DetailAST parentDetailAST = typeDetailAST.getParent();
        if (parentDetailAST.getType() != 10) {
            return;
        }
        List<DetailAST> dependentIdentDetailASTList = this.getDependentIdentDetailASTList(parentDetailAST, parentDetailAST.getLineNo());
        if (dependentIdentDetailASTList.isEmpty()) {
            return;
        }
        int endLineNumber = this.getEndLineNumber(assignDetailAST);
        for (DetailAST dependentIdentDetailAST : dependentIdentDetailASTList) {
            List<String> names;
            int actionLineNumber;
            int lineNumber = dependentIdentDetailAST.getLineNo();
            if (lineNumber <= endLineNumber) continue;
            if (lineNumber > endRange) {
                return;
            }
            if (!this.hasParentWithTokenType(assignDetailAST, 91, 84) && (actionLineNumber = this.getActionLineNumber(assignDetailAST)) != assignDetailAST.getLineNo()) {
                this.checkMoveAfterBranchingStatement(detailAST, assignDetailAST, variableName, dependentIdentDetailAST, actionLineNumber);
                this.checkMoveInsideIfStatement(assignDetailAST, nameDetailAST, variableName, dependentIdentDetailAST, dependentIdentDetailASTList.get(dependentIdentDetailASTList.size() - 1), actionLineNumber);
            }
            if ((parentDetailAST = this.getParentWithTokenType(assignDetailAST, 91, 84)) != null && !(names = this.getNames(parentDetailAST, true)).contains(variableName)) {
                this.checkInline(assignDetailAST, variableName, dependentIdentDetailAST, dependentIdentDetailASTList);
            }
            return;
        }
    }
}

