/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLLog4jLoggersCheck
extends BaseFileCheck {
    private final Set<String> _srcPaths = new HashSet<String>();

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (this.isPortalSource() && (fileName.endsWith("-log4j-ext.xml") || fileName.endsWith("-log4j.xml"))) {
            this._checkLoggers(fileName, content);
        }
        return content;
    }

    private void _checkLoggers(String fileName, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        Set<String> srcPaths = this._getSrcPaths();
        for (Element loggersElement : rootElement.elements("Loggers")) {
            for (Element loggerElement : loggersElement.elements("Logger")) {
                String path;
                String name = loggerElement.attributeValue("name");
                if (!name.startsWith("com.liferay") || this._srcPaths.contains(path = StringUtil.replace(name, '.', '/'))) continue;
                boolean exists = false;
                for (String srcPath : srcPaths) {
                    if (!srcPath.startsWith(path)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.addMessage(fileName, "Class/package does not exist: " + name);
            }
        }
    }

    private Set<String> _getSrcPaths() throws Exception {
        if (!this._srcPaths.isEmpty()) {
            return this._srcPaths;
        }
        File file = this.getPortalDir();
        List<String> fileNames = this.getFileNames(file.getAbsolutePath(), new String[0], new String[]{"**/com/liferay/**/*.java"});
        for (String fileName : fileNames) {
            this._srcPaths.add(fileName.substring(fileName.indexOf("com/liferay/")));
        }
        return this._srcPaths;
    }
}

