/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.script;

import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.script.UnbalancedCodeException;
import com.liferay.poshi.core.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiScriptParserUtil {
    private static final Map<Character, Character> _codeBoundariesMap = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('('), Character.valueOf(')'));
            this.put(Character.valueOf('['), Character.valueOf(']'));
            this.put(Character.valueOf('\"'), Character.valueOf('\"'));
            this.put(Character.valueOf('\''), Character.valueOf('\''));
            this.put(Character.valueOf('`'), Character.valueOf('`'));
            this.put(Character.valueOf('{'), Character.valueOf('}'));
        }
    };

    public static List<String> getMethodParameterValues(String content, Pattern pattern, PoshiNode poshiNode) throws PoshiScriptParserException {
        ArrayList<String> methodParameterValues = new ArrayList<String>();
        if (content.length() == 0) {
            return methodParameterValues;
        }
        boolean expectedComma = false;
        StringBuilder sb = new StringBuilder();
        String methodParameterValue = sb.toString();
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < content.length(); ++i) {
            Character c1 = Character.valueOf(content.charAt(i));
            Character c2 = null;
            Character c3 = null;
            if (i + 2 < content.length()) {
                c2 = Character.valueOf(content.charAt(i + 1));
                c3 = Character.valueOf(content.charAt(i + 2));
            }
            if (c1.charValue() == ',' && expectedComma && PoshiScriptParserUtil._patternIsNullOrMatches(pattern, methodParameterValue)) {
                methodParameterValues.add(methodParameterValue);
                sb.setLength(0);
            } else {
                sb.append(c1);
                methodParameterValue = sb.toString();
            }
            if (c1.charValue() == '`') continue;
            if (!stack.isEmpty()) {
                Character topCodeBoundary = (Character)stack.peek();
                if (PoshiScriptParserUtil._isMultilineVariableBoundary(c1, c2, c3)) {
                    c1 = Character.valueOf('`');
                }
                if (c1 == _codeBoundariesMap.get(topCodeBoundary) && content.charAt(i - 1) != '\\') {
                    stack.pop();
                    if (!stack.isEmpty()) continue;
                    expectedComma = true;
                    continue;
                }
                if (topCodeBoundary.charValue() == '\"' || topCodeBoundary.charValue() == '\'' || topCodeBoundary.charValue() == '`') continue;
            }
            if (_codeBoundariesMap.containsKey(c1)) {
                if (PoshiScriptParserUtil._isMultilineVariableBoundary(c1, c2, c3)) {
                    c1 = Character.valueOf('`');
                    sb.append(c2);
                    sb.append(c3);
                    methodParameterValue = sb.toString();
                    i += 2;
                }
                stack.push(c1);
                continue;
            }
            if (!expectedComma) continue;
            if (c1.charValue() == ',') {
                expectedComma = false;
                continue;
            }
            if (Character.isWhitespace(c1.charValue())) continue;
            PoshiScriptParserException poshiScriptParserException = new PoshiScriptParserException("Missing comma in Poshi file call", poshiNode);
            int additionalLines = Math.max(StringUtil.count(content, "\n", i) - 1, 0);
            poshiScriptParserException.setErrorLineNumber(poshiScriptParserException.getErrorLineNumber() + additionalLines);
            throw poshiScriptParserException;
        }
        if (!PoshiScriptParserUtil._patternIsNullOrMatches(pattern, methodParameterValue)) {
            throw new PoshiScriptParserException("Invalid Poshi Script parameter syntax", poshiNode);
        }
        methodParameterValues.add(methodParameterValue);
        return methodParameterValues;
    }

    public static List<String> getMethodParameterValues(String content, PoshiNode poshiNode) {
        try {
            return PoshiScriptParserUtil.getMethodParameterValues(content, null, poshiNode);
        }
        catch (PoshiScriptParserException poshiScriptParserException) {
            poshiScriptParserException.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public static boolean isBalancedPoshiScript(String poshiScript) {
        try {
            return PoshiScriptParserUtil.isBalancedPoshiScript(poshiScript, null, false);
        }
        catch (UnbalancedCodeException unbalancedCodeException) {
            return false;
        }
    }

    public static boolean isBalancedPoshiScript(String poshiScript, URL filePathURL, boolean throwException) throws UnbalancedCodeException {
        poshiScript = PoshiScriptParserUtil._fixPoshiScript(poshiScript);
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < poshiScript.length(); ++i) {
            char c = poshiScript.charAt(i);
            if (c == '`') continue;
            if (!stack.isEmpty()) {
                int topIndex = (Integer)stack.peek();
                Character topCodeBoundary = Character.valueOf(poshiScript.charAt(topIndex));
                if (c == _codeBoundariesMap.get(topCodeBoundary).charValue() && i > 0 && poshiScript.charAt(i - 1) != '\\') {
                    stack.pop();
                    continue;
                }
                if (topCodeBoundary.charValue() == '\"' || topCodeBoundary.charValue() == '\'') continue;
            }
            if (_codeBoundariesMap.containsKey(Character.valueOf(c))) {
                stack.push(i);
                continue;
            }
            if (!_codeBoundariesMap.containsValue(Character.valueOf(c))) continue;
            if (throwException) {
                throw new UnbalancedCodeException("Unexpected closing boundary", i, poshiScript, filePathURL);
            }
            return false;
        }
        boolean balanced = stack.isEmpty();
        if (!balanced && throwException) {
            throw new UnbalancedCodeException("Unmatched opening boundary", (int)((Integer)stack.peek()), poshiScript, filePathURL);
        }
        return balanced;
    }

    private static String _fixPoshiScript(String poshiScript) {
        if (poshiScript.contains("/*") && poshiScript.contains("*/")) {
            poshiScript = poshiScript.replaceAll("(?s)/\\*.*?\\*/", "/\\*\\*/");
        }
        if (poshiScript.contains("'''")) {
            poshiScript = poshiScript.replaceAll("(?s)'''.*?'''", "''''''");
        }
        if (poshiScript.contains("//")) {
            poshiScript = poshiScript.replaceAll("(?m)\n[\\s]*//.*?$", "//\n");
        }
        return poshiScript.trim();
    }

    private static boolean _isMultilineVariableBoundary(Character c1, Character c2, Character c3) {
        return c1 != null && c2 != null && c3 != null && c1.charValue() == '\'' && c2.charValue() == '\'' && c3.charValue() == '\'';
    }

    private static boolean _patternIsNullOrMatches(Pattern pattern, String input) {
        if (pattern == null || input == null) {
            return true;
        }
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }
}

