/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJSPTermsCheck;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPTaglibVariableCheck
extends BaseJSPTermsCheck {
    private static final Pattern _taglibVariablePattern = Pattern.compile("\n(((\t*)([\\w<>\\[\\],\\? ]+) (\\w+) = (((?!;\n).)*);\n)+)\\s*%>\n", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        return this._formatTaglibVariable(fileName, content);
    }

    private String _formatTaglibVariable(String fileName, String content) throws IOException {
        Matcher matcher = _taglibVariablePattern.matcher(content);
        while (matcher.find()) {
            String[] variableDefinitions;
            String line;
            int x = matcher.start(1);
            StringBundler sb = new StringBundler();
            int lineNumber = this.getLineNumber(content, matcher.end());
            String indent = matcher.group(3);
            while ((line = this.getLine(content, lineNumber)) != null && (!Validator.isNotNull(line) || line.startsWith(indent))) {
                sb.append(line);
                sb.append("\n");
                ++lineNumber;
            }
            String nextTags = sb.toString();
            String s = matcher.group(1);
            for (String variableDefinition : variableDefinitions = s.split(";\n")) {
                String taglibValue;
                x = x + variableDefinition.length() + 2;
                String[] array = variableDefinition.split(" = ", 2);
                String variableTypeAndName = array[0];
                int y = variableTypeAndName.lastIndexOf(32);
                String variableName = variableTypeAndName.substring(y + 1);
                if (!nextTags.contains("<%= " + variableName + " %>") || this.hasVariableReference(s = content.substring(x), taglibValue = array[1], s.lastIndexOf("<%= " + variableName + " %>"))) continue;
                if (!taglibValue.contains("\n") && (taglibValue.contains("\\\"") || taglibValue.contains("'") && taglibValue.contains("\""))) {
                    if (variableName.startsWith("taglib") || this._getVariableCount(content, variableName) != 2 || !nextTags.contains("<%= " + variableName + " %>")) continue;
                    this.addMessage(fileName, "Variable '" + variableName + "' should start with 'taglib'", this.getLineNumber(content, matcher.start(1)));
                    continue;
                }
                this.populateContentsMap(fileName, content);
                String newContent = null;
                if (taglibValue.startsWith("{")) {
                    String typeName = StringUtil.trimLeading(variableTypeAndName.substring(0, y));
                    if (typeName.endsWith("[][]") || !typeName.endsWith("[]")) continue;
                    newContent = StringUtil.replaceFirst(content, "<%= " + variableName + " %>", StringBundler.concat("<%= new ", typeName, " ", taglibValue, " %>"), matcher.end());
                } else {
                    newContent = StringUtil.replaceFirst(content, "<%= " + variableName + " %>", "<%= " + taglibValue + " %>", matcher.end());
                }
                y = newContent.indexOf(variableDefinition, matcher.start());
                HashSet<String> checkedFileNames = new HashSet<String>();
                HashSet<String> includeFileNames = new HashSet<String>();
                if (!this.hasUnusedJSPTerm(fileName, newContent, "\\W" + variableName + "\\W", this.getLineNumber(newContent, y), "variable", checkedFileNames, includeFileNames, this.getContentsMap())) continue;
                if (!taglibValue.contains("\n")) {
                    return StringUtil.replaceFirst(newContent, variableDefinition + ";\n", "", matcher.start());
                }
                this.addMessage(fileName, StringBundler.concat("No need to declare variable '", variableName, "', inline inside the tag."), this.getLineNumber(content, matcher.start(4)));
            }
        }
        return content;
    }

    private int _getVariableCount(String content, String variableName) {
        int count = 0;
        Pattern pattern = Pattern.compile("\\W" + variableName + "\\W");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            int x = matcher.start() + 1;
            if (this.isJavaSource(content, x)) {
                if (ToolsUtil.isInsideQuotes(content, x)) continue;
                ++count;
                continue;
            }
            if (!this.isJavaSource(content, x, true)) continue;
            ++count;
        }
        return count;
    }
}

