/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.memory.FinalizeAction;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.internal.util.SystemCheckerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.ServiceTrackerFieldUpdaterCustomizer;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceProxyFactory {
    private static final long _TIMEOUT = GetterUtil.getLong(SystemProperties.get(ServiceProxyFactory.class.getName() + ".timeout"), 60000L);
    private static final Log _log = LogFactoryUtil.getLog(ServiceProxyFactory.class);

    public static <T> T newServiceTrackedInstance(Class<T> serviceClass, Class<?> declaringClass, String fieldName, boolean blocking) {
        return ServiceProxyFactory.newServiceTrackedInstance(serviceClass, declaringClass, fieldName, null, blocking, false);
    }

    public static <T> T newServiceTrackedInstance(Class<T> serviceClass, Class<?> declaringClass, String fieldName, boolean blocking, boolean useNullAsDummyService) {
        return ServiceProxyFactory.newServiceTrackedInstance(serviceClass, declaringClass, fieldName, null, blocking, useNullAsDummyService);
    }

    public static <T> T newServiceTrackedInstance(Class<T> serviceClass, Class<?> declaringClass, String fieldName, String filterString, boolean blocking) {
        return ServiceProxyFactory.newServiceTrackedInstance(serviceClass, declaringClass, fieldName, filterString, blocking, false);
    }

    public static <T> T newServiceTrackedInstance(Class<T> serviceClass, Class<?> declaringClass, String fieldName, String filterString, boolean blocking, boolean useNullAsDummyService) {
        try {
            Field field = declaringClass.getDeclaredField(fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException(field + " is not static");
            }
            field.setAccessible(true);
            return ServiceProxyFactory._newServiceTrackedInstance(serviceClass, null, field, filterString, blocking, useNullAsDummyService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return ReflectionUtil.throwException(reflectiveOperationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, V> T newServiceTrackedInstance(Class<T> serviceClass, Class<V> declaringClass, V declaringInstance, String fieldName, String filterString, boolean blocking) {
        if (declaringInstance == null) {
            return ServiceProxyFactory.newServiceTrackedInstance(serviceClass, declaringClass, fieldName, filterString, blocking, false);
        }
        try {
            Field field = declaringClass.getDeclaredField(fieldName);
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException(field + " is static");
            }
            field.setAccessible(true);
            Object serviceInstance = null;
            V v = declaringInstance;
            synchronized (v) {
                serviceInstance = field.get(declaringInstance);
                if (serviceInstance == null) {
                    return ServiceProxyFactory._newServiceTrackedInstance(serviceClass, declaringInstance, field, filterString, blocking, false);
                }
            }
            return (T)serviceInstance;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return ReflectionUtil.throwException(reflectiveOperationException);
        }
    }

    private static <T, V> T _newServiceTrackedInstance(Class<T> serviceClass, V declaringInstance, Field field, String filterString, boolean blocking, boolean useNullAsDummyService) throws ReflectiveOperationException {
        AwaitServiceTrackerFieldUpdaterCustomizer serviceTrackerCustomizer = null;
        if (blocking) {
            ReentrantLock lock = new ReentrantLock();
            Condition realServiceSet = lock.newCondition();
            Object awaitService = ProxyUtil.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, new AwaitServiceInvocationHandler(serviceClass, filterString, field, realServiceSet, lock));
            field.set(declaringInstance, awaitService);
            serviceTrackerCustomizer = new AwaitServiceTrackerFieldUpdaterCustomizer(field, declaringInstance, awaitService, realServiceSet, lock);
        } else {
            Object dummyService = null;
            if (!useNullAsDummyService) {
                dummyService = ProxyFactory.newDummyInstance(serviceClass);
                field.set(declaringInstance, dummyService);
            }
            serviceTrackerCustomizer = new AwaitServiceTrackerFieldUpdaterCustomizer(field, declaringInstance, dummyService);
        }
        ServiceTracker<T, T> serviceTracker = ServiceProxyFactory._openServiceTracker(serviceClass, filterString, serviceTrackerCustomizer);
        if (declaringInstance != null) {
            FinalizeManager.register(declaringInstance, new CloseServiceTrackerFinalizeAction(serviceTracker), FinalizeManager.PHANTOM_REFERENCE_FACTORY);
        }
        return (T)field.get(declaringInstance);
    }

    private static <T> ServiceTracker<T, T> _openServiceTracker(Class<T> serviceClass, String filterString, ServiceTrackerCustomizer<T, T> serviceTrackerCustomizer) {
        ServiceTracker serviceTracker = null;
        String serviceName = serviceClass.getName();
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        serviceTracker = Validator.isNull(filterString) ? new ServiceTracker(bundleContext, serviceClass, serviceTrackerCustomizer) : new ServiceTracker(bundleContext, SystemBundleUtil.createFilter((String)StringBundler.concat("(&(objectClass=", serviceName, ")", filterString, ")")), serviceTrackerCustomizer);
        serviceTracker.open();
        return serviceTracker;
    }

    private static class CloseServiceTrackerFinalizeAction
    implements FinalizeAction {
        private final ServiceTracker<?, ?> _serviceTracker;

        @Override
        public void doFinalize(Reference<?> reference) {
            this._serviceTracker.close();
        }

        private CloseServiceTrackerFinalizeAction(ServiceTracker<?, ?> serviceTracker) {
            this._serviceTracker = serviceTracker;
        }
    }

    private static class AwaitServiceTrackerFieldUpdaterCustomizer<S, T>
    extends ServiceTrackerFieldUpdaterCustomizer<S, T> {
        private final T _awaitService;
        private final Lock _lock;
        private final Condition _realServiceSet;

        protected void doServiceUpdate(T newService) {
            this._lock.lock();
            try {
                super.doServiceUpdate(newService);
                if (newService != this._awaitService) {
                    this._realServiceSet.signalAll();
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        private AwaitServiceTrackerFieldUpdaterCustomizer(Field serviceField, Object serviceHolder, T awaitService, Condition realServiceSet, Lock lock) {
            super(serviceField, serviceHolder, awaitService);
            this._awaitService = awaitService;
            this._realServiceSet = realServiceSet;
            this._lock = lock;
        }
    }

    private static class AwaitServiceInvocationHandler
    implements InvocationHandler {
        private final Field _field;
        private final String _filterString;
        private final Lock _lock;
        private final Condition _realServiceSet;
        private final Class<?> _serviceClass;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            boolean calledSystemCheckers = false;
            while (true) {
                this._lock.lock();
                Object service = this._field.get(null);
                if (!ProxyUtil.isProxyClass(service.getClass()) || ProxyUtil.getInvocationHandler(service) != this) {
                    try {
                        Object object = method.invoke(service, arguments);
                        return object;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getCause();
                    }
                }
                if (this._realServiceSet.await(_TIMEOUT, TimeUnit.MILLISECONDS)) continue;
                StringBundler sb = new StringBundler(12);
                sb.append("Service \"");
                sb.append(this._serviceClass.getName());
                if (Validator.isNotNull(this._filterString)) {
                    sb.append("{");
                    sb.append(this._filterString);
                    sb.append("}");
                }
                sb.append("\" is unavailable in ");
                sb.append(_TIMEOUT);
                sb.append(" milliseconds while setting field \"");
                sb.append(this._field.getName());
                sb.append("\" for class \"");
                Class<?> declaringClass = this._field.getDeclaringClass();
                sb.append(declaringClass.getName());
                sb.append("\", will retry...");
                _log.error(sb.toString());
                if (calledSystemCheckers) continue;
                SystemCheckerUtil.runSystemCheckers((Log)_log);
                calledSystemCheckers = true;
                continue;
                finally {
                    this._lock.unlock();
                    continue;
                }
                break;
            }
        }

        private AwaitServiceInvocationHandler(Class<?> serviceClass, String filterString, Field field, Condition realServiceSet, Lock lock) {
            this._serviceClass = serviceClass;
            this._filterString = filterString;
            this._field = field;
            this._realServiceSet = realServiceSet;
            this._lock = lock;
        }
    }
}

