/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NestedFieldAnnotationCheck
extends BaseCheck {
    private static final String _MSG_NEEDED_SERVICE = "service.needed";
    private static final String _MSG_UNNEEDED_SERVICE = "service.unneeded";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getParent() != null || !AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Component")) {
            return;
        }
        String className = this.getName(detailAST);
        if (!className.endsWith("ResourceImpl")) {
            return;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        List<String> serviceNamesList = this._getServiceNamesList(annotationDetailAST);
        boolean hasNestedFieldAnnotation = this._hasNestedFieldAnnotation(this.getAllChildTokens(detailAST, true, 9));
        if (hasNestedFieldAnnotation && !serviceNamesList.contains("NestedFieldSupport")) {
            this.log(annotationDetailAST, _MSG_NEEDED_SERVICE, new Object[0]);
        } else if (!hasNestedFieldAnnotation && serviceNamesList.contains("NestedFieldSupport")) {
            this.log(annotationDetailAST, _MSG_UNNEEDED_SERVICE, new Object[0]);
        }
    }

    private List<String> _getServiceNamesList(DetailAST annotationDetailAST) {
        if (annotationDetailAST == null) {
            return Collections.emptyList();
        }
        DetailAST annotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "service");
        if (annotationMemberValuePairDetailAST == null) {
            return Collections.emptyList();
        }
        DetailAST annotationArrayInitDetailAST = annotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST == null) {
            return Collections.emptyList();
        }
        ArrayList<String> serviceNamesList = new ArrayList<String>();
        List<DetailAST> expressionDetailASTList = this.getAllChildTokens(annotationArrayInitDetailAST, false, 28);
        for (DetailAST expressionDetailAST : expressionDetailASTList) {
            DetailAST siblingDetailAST;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 59 || (firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 58 || (siblingDetailAST = firstChildDetailAST.getNextSibling()).getType() != 69) continue;
            serviceNamesList.add(firstChildDetailAST.getText());
        }
        return serviceNamesList;
    }

    private boolean _hasNestedFieldAnnotation(List<DetailAST> detailASTList) {
        for (DetailAST detailAST : detailASTList) {
            DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"NestedField");
            if (annotationDetailAST == null) continue;
            return true;
        }
        return false;
    }
}

