/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodNamingCheck
extends BaseCheck {
    private static final String _CHECK_SEARCH_METHOD_NAMES = "checkSearchMethodNames";
    private static final String _ENFORCE_TYPE_NAMES_KEY = "enforceTypeNames";
    private static final String[][] _METHOD_NAME_PREFIXS = new String[][]{{"do", ""}, {"get", "is"}};
    private static final String _MSG_INCORRECT_ENDING_METHOD = "method.incorrect.ending";
    private static final String _MSG_INCORRECT_SEARCH_METHOD = "search.method.incorrect";
    private static final String _MSG_RENAME_METHOD = "method.rename";

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String methodName = this.getName(detailAST);
        if (this.isAttributeValue(_CHECK_SEARCH_METHOD_NAMES) && methodName.startsWith("search")) {
            this._checkSearchMethodName(detailAST, methodName);
        }
        if (AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
            return;
        }
        this._checkMethodNamePrefix(detailAST, methodName);
        this._checkTypeName(detailAST, methodName);
    }

    private void _checkMethodNamePrefix(DetailAST detailAST, String methodName) {
        String typeName = this.getTypeName(detailAST.findFirstToken(13), false);
        Matcher matcher = null;
        for (String[] array : _METHOD_NAME_PREFIXS) {
            Pattern pattern;
            if (array[0].equals("get") && !typeName.equals("boolean") || !(matcher = (pattern = Pattern.compile("^_" + array[0] + "([A-Z])(.*)$")).matcher(methodName)).find()) continue;
            String newMethodName = "_" + array[1];
            newMethodName = array[0].equals("get") ? newMethodName + matcher.group(1) : newMethodName + StringUtil.toLowerCase(matcher.group(1));
            newMethodName = newMethodName + matcher.group(2);
            String noUnderscoreMethodName = "";
            noUnderscoreMethodName = array[1].equals("") ? methodName.substring(1) : newMethodName.substring(1);
            DetailAST parentDetailAST = detailAST.getParent();
            List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(parentDetailAST, false, 9);
            for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
                String curMethodName = this.getName(methodDefinitionDetailAST);
                if (!curMethodName.equals(noUnderscoreMethodName) && (!curMethodName.equals(newMethodName) || !Objects.equals(this.getSignature(detailAST), this.getSignature(methodDefinitionDetailAST)))) continue;
                return;
            }
            this.log(detailAST, _MSG_RENAME_METHOD, new Object[]{methodName, newMethodName});
        }
    }

    private void _checkSearchMethodName(DetailAST detailAST, String methodName) {
        DetailAST parentDetailAST = this.getParentWithTokenType(detailAST, 14);
        if (parentDetailAST == null) {
            return;
        }
        DetailAST identDetailAST = parentDetailAST.findFirstToken(58);
        if (identDetailAST == null) {
            return;
        }
        DetailAST typeDetailAST = detailAST.findFirstToken(13);
        if (typeDetailAST == null) {
            return;
        }
        String className = identDetailAST.getText();
        String objectName = null;
        if (className.endsWith("LocalServiceImpl")) {
            objectName = className.substring(0, className.length() - 16);
        } else if (className.endsWith("ServiceImpl")) {
            objectName = className.substring(0, className.length() - 11);
        } else {
            return;
        }
        String returnTypeName = this.getTypeName(typeDetailAST, true);
        String pluralObjectName = TextFormatter.formatPlural(objectName);
        if (returnTypeName.equals("List<" + objectName + ">")) {
            if (methodName.equals("search" + pluralObjectName) || methodName.startsWith("search" + pluralObjectName + "By")) {
                String expectedMethodName = StringUtil.replaceFirst(methodName, "search" + pluralObjectName, "search");
                this.log(detailAST, _MSG_RENAME_METHOD, new Object[]{methodName, expectedMethodName});
                return;
            }
            if (!methodName.matches("search(By.*)?")) {
                this.log(detailAST, _MSG_INCORRECT_SEARCH_METHOD, new Object[]{methodName});
            }
        } else if (returnTypeName.equals("BaseModelSearchResult<" + objectName + ">") && methodName.matches("search(By.*)?")) {
            String expectedMethodName = StringUtil.replaceFirst(methodName, "search", "search" + pluralObjectName);
            this.log(detailAST, _MSG_RENAME_METHOD, new Object[]{methodName, expectedMethodName});
        }
    }

    private void _checkTypeName(DetailAST detailAST, String methodName) {
        String absolutePath = this.getAbsolutePath();
        if (!(methodName.matches("get[A-Z].*") && absolutePath.contains("/internal/") || methodName.matches("_get[A-Z].*"))) {
            return;
        }
        String returnTypeName = this.getTypeName(detailAST, true);
        if (returnTypeName.contains("[]") || methodName.matches(".*" + returnTypeName + "[0-9]*") || methodName.matches("_?get" + returnTypeName + ".*")) {
            return;
        }
        List<String> enforceTypeNames = this.getAttributeValues(_ENFORCE_TYPE_NAMES_KEY);
        for (String enforceTypeName : enforceTypeNames) {
            if (!returnTypeName.matches(enforceTypeName)) continue;
            this.log(detailAST, _MSG_INCORRECT_ENDING_METHOD, new Object[]{returnTypeName});
            return;
        }
    }
}

