/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class BNDBundleCheck
extends BaseFileCheck {
    private static final String _ALLOWED_FILE_NAMES_KEY = "allowedFileNames";
    private static final String[] _REQUIRED_INSTRUCTIONS = new String[]{"Liferay-Releng-App-Description", "Liferay-Releng-App-Title", "Liferay-Releng-Bundle", "Liferay-Releng-Category", "Liferay-Releng-Demo-Url", "Liferay-Releng-Deprecated", "Liferay-Releng-Fix-Delivery-Method", "Liferay-Releng-Labs", "Liferay-Releng-Marketplace", "Liferay-Releng-Portal-Required", "Liferay-Releng-Public", "Liferay-Releng-Restart-Required", "Liferay-Releng-Support-Url", "Liferay-Releng-Supported"};

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        String liferayRelengRestartRequired;
        if (!absolutePath.endsWith("/app.bnd")) {
            return content;
        }
        List<String> allowedFileNames = this.getAttributeValues(_ALLOWED_FILE_NAMES_KEY, absolutePath);
        for (String allowedFileName : allowedFileNames) {
            if (!absolutePath.endsWith(allowedFileName)) continue;
            return content;
        }
        if (!content.matches("(?s).*Liferay-Releng-App-Title: " + Pattern.quote("${liferay.releng.app.title.prefix}") + " \\S+.*")) {
            String appTitle = this._getAppTitle(absolutePath);
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-App-Title", "${liferay.releng.app.title.prefix} " + appTitle);
        }
        if (content.matches("(?s).*Liferay-Releng-Deprecated:\\s*true.*")) {
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Bundle", "false");
        }
        if (StringUtil.equals(liferayRelengRestartRequired = BNDSourceUtil.getDefinitionValue(content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Public", "${liferay.releng.public}"), "Liferay-Releng-Restart-Required"), "false")) {
            if (!this._isHotDeployOSGiAppIncludes(BNDSourceUtil.getModuleName(absolutePath))) {
                this.addMessage(fileName, "The 'Liferay-Releng-Restart-Required' can only be set to false if a POSHI tests exists");
                return content;
            }
        } else {
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Restart-Required", "true");
        }
        content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Support-Url", "http://www.liferay.com");
        content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Supported", "${liferay.releng.supported}");
        for (String instruction : _REQUIRED_INSTRUCTIONS) {
            if (content.contains(instruction + ":")) continue;
            content = StringBundler.concat(content, "\n", instruction, ":");
        }
        return content;
    }

    private String _getAppTitle(String absolutePath) {
        int pos = absolutePath.lastIndexOf("/");
        if (pos == -1) {
            return "";
        }
        String dirName = absolutePath.substring(0, pos);
        if ((pos = dirName.lastIndexOf("/")) == -1) {
            return "";
        }
        String shortDirName = dirName.substring(pos + 1);
        if (shortDirName.startsWith("com-liferay-")) {
            shortDirName = StringUtil.replaceFirst(shortDirName, "com-liferay-", "");
        }
        return TextFormatter.format(shortDirName, 9);
    }

    private boolean _isHotDeployOSGiAppIncludes(String moduleName) throws IOException {
        String testcaseDirLocation = "/portal-web/test/functional/com/liferay/portalweb/tests";
        File file = new File(this.getPortalDir() + testcaseDirLocation);
        if (!file.exists()) {
            return false;
        }
        List<String> testcaseFileNames = SourceFormatterUtil.scanForFiles(this.getPortalDir() + testcaseDirLocation, new String[0], new String[]{"**/*.testcase"}, new SourceFormatterExcludes(), true);
        for (String testcaseFileName : testcaseFileNames) {
            testcaseFileName = StringUtil.replace(testcaseFileName, '\\', '/');
            String content = FileUtil.read(new File(testcaseFileName));
            if (!content.contains(StringBundler.concat("property hot.deploy.osgi.app.includes = \"", moduleName, "\""))) continue;
            return true;
        }
        return false;
    }
}

