/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.ExecutePoshiElement;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.RegexUtil;
import com.liferay.poshi.core.util.StringUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class ReturnPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "return";
    private static final Pattern _returnPattern = Pattern.compile("^return[\\s]*\"[\\s\\S]*\"[\\s]*;$");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new ReturnPoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new ReturnPoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        if (this.getParent() instanceof ExecutePoshiElement) {
            String returnName = RegexUtil.getGroup(poshiScript, "var\\s*(.+?)\\s*=", 1);
            this.addAttribute("name", returnName);
            return;
        }
        this.addAttribute("value", this.getDoubleQuotedContent(poshiScript));
    }

    @Override
    public String toPoshiScript() {
        if (this.getParent() instanceof ExecutePoshiElement) {
            return "";
        }
        return StringUtil.combine("\n\n", this.getPad(), "return \"", this.attributeValue("value"), "\";");
    }

    @Override
    public void validatePoshiScript() throws PoshiScriptParserException {
    }

    protected ReturnPoshiElement() {
        super(_ELEMENT_NAME);
    }

    protected ReturnPoshiElement(Element element) {
        super(_ELEMENT_NAME, element);
    }

    protected ReturnPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        super(_ELEMENT_NAME, attributes, nodes);
    }

    protected ReturnPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    @Override
    protected String createPoshiScriptSnippet(String content) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        sb.append(this.getPad());
        sb.append(this.getBlockName());
        sb.append(content.trim());
        return sb.toString();
    }

    @Override
    protected String getBlockName() {
        StringBuilder sb = new StringBuilder();
        sb.append("var ");
        sb.append(this.attributeValue("name"));
        sb.append(" = ");
        return sb.toString();
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        poshiScript = poshiScript.trim();
        if (parentPoshiElement instanceof ExecutePoshiElement) {
            if (!poshiScript.startsWith("var")) {
                return false;
            }
            return this.isVarAssignedToMacroInvocation(poshiScript);
        }
        return this.isValidPoshiScriptStatement(_returnPattern, poshiScript);
    }
}

