/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiElementException;
import com.liferay.poshi.core.script.PoshiScriptParserUtil;
import com.liferay.poshi.core.selenium.LiferaySeleniumMethod;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.core.util.PropsUtil;
import com.liferay.poshi.core.util.PropsValues;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;

public class PoshiValidation {
    protected static final String[] UTIL_PACKAGE_NAMES = new String[]{"com.liferay.poshi.core.util", "com.liferay.poshi.runner.util"};
    private static final Logger _logger = Logger.getLogger(PoshiValidation.class.getName());
    private static final List<String> _deprecatedFunctionNames = new ArrayList<String>();
    private static final Map<String, String> _deprecatedMethodNames = new Hashtable<String, String>(){
        {
            this.put("assertAlert", "\"selenium.assertAlertText\"");
            this.put("copyText", "\"selenium.getText\" (stored as a variable)");
            this.put("copyValue", "\"selenium.getElementValue\" (stored as a variable)");
            this.put("getAttribute", "\"selenium.getWebElementAttribute\"");
            this.put("getEval", "\"selenium.getJavaScriptResult\"");
            this.put("paste", "a variable storing the desired value");
            this.put("robotType", "\"selenium.type\"");
            this.put("robotTypeShortcut", "\"selenium.typeKeys/selenium.sendKeys\"");
            this.put("runScript", "\"selenium.executeJavaScript\"");
            this.put("typeAlloyEditor", "\"selenium.typeEditor\"");
            this.put("typeCKEditor", "\"selenium.typeEditor\"");
        }
    };
    private static final Set<Exception> _exceptions = new HashSet<Exception>();
    private static final Pattern _invalidMethodParameterPattern = Pattern.compile("(?<invalidSyntax>(?:locator|value)[1-3]?[\\s]*=)");
    private static final Pattern _pattern = Pattern.compile("\\$\\{([^}]*)\\}");
    private static final Pattern _seleniumGetterMethodPattern = Pattern.compile("^selenium#(?<methodName>[A-z]+)(?:\\((?<methodParameters>.*|)\\))?$");

    public static void clearExceptions() {
        _exceptions.clear();
    }

    public static Set<Exception> getExceptions() {
        return _exceptions;
    }

    public static void main(String[] args) throws Exception {
        PoshiContext.readFiles();
        PoshiValidation.validate();
    }

    public static void validate() throws Exception {
        System.out.println("Start poshi validation.");
        long start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(PropsValues.POSHI_FILE_READ_THREAD_POOL);
        ArrayList<1> callables = new ArrayList<1>();
        for (final String finalFilePath : PoshiContext.getFilePaths()) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() {
                    String filePath = finalFilePath;
                    if (OSDetector.isWindows()) {
                        filePath = StringUtil.replace(filePath, "/", "\\");
                    }
                    String className = PoshiGetterUtil.getClassNameFromFilePath(filePath);
                    String classType = PoshiGetterUtil.getClassTypeFromFilePath(filePath);
                    String namespace = PoshiContext.getNamespaceFromFilePath(filePath);
                    if (classType.equals("function")) {
                        Element element = PoshiContext.getFunctionRootElement(className, namespace);
                        PoshiValidation.validateFunctionFile((PoshiElement)element);
                    } else if (classType.equals("macro")) {
                        Element element = PoshiContext.getMacroRootElement(className, namespace);
                        PoshiValidation.validateMacroFile((PoshiElement)element);
                    } else if (classType.equals("path")) {
                        Element element = PoshiContext.getPathRootElement(className, namespace);
                        PoshiValidation.validatePathFile(element, filePath);
                    } else if (classType.equals("test-case")) {
                        Element element = PoshiContext.getTestCaseRootElement(className, namespace);
                        PoshiValidation.validateTestCaseFile((PoshiElement)element);
                    }
                    return null;
                }
            };
            callables.add(callable);
        }
        executorService.invokeAll(callables);
        executorService.shutdown();
        if (!_exceptions.isEmpty()) {
            PoshiValidation._throwExceptions();
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Completed poshi validation in " + duration + "ms.");
    }

    public static void validate(String testName) throws Exception {
        PoshiValidation.validateTestName(testName);
    }

    protected static String getPrimaryAttributeName(PoshiElement poshiElement, List<String> primaryAttributeNames) {
        return PoshiValidation.getPrimaryAttributeName(poshiElement, null, primaryAttributeNames);
    }

    protected static String getPrimaryAttributeName(PoshiElement poshiElement, List<String> multiplePrimaryAttributeNames, List<String> primaryAttributeNames) {
        PoshiValidation.validateHasPrimaryAttributeName(poshiElement, multiplePrimaryAttributeNames, primaryAttributeNames);
        for (String primaryAttributeName : primaryAttributeNames) {
            if (!Validator.isNotNull(poshiElement.attributeValue(primaryAttributeName))) continue;
            return primaryAttributeName;
        }
        return null;
    }

    protected static void parseElements(PoshiElement poshiElement) {
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        List<String> possiblePoshiElementNames = Arrays.asList("description", "echo", "execute", "fail", "for", "if", "property", "return", "take-screenshot", "task", "var", "while");
        String filePath = PoshiValidation._getFilePath(poshiElement);
        if (Validator.isNotNull(filePath) && filePath.endsWith(".function")) {
            possiblePoshiElementNames = Arrays.asList("execute", "if", "var");
        }
        for (PoshiElement childPoshiElement : childPoshiElements) {
            String poshiElementName = childPoshiElement.getName();
            if (!possiblePoshiElementNames.contains(poshiElementName)) {
                _exceptions.add(new PoshiElementException(childPoshiElement, "Invalid ", poshiElementName, " element"));
            }
            if (poshiElementName.equals("description") || poshiElementName.equals("echo") || poshiElementName.equals("fail")) {
                PoshiValidation.validateMessageElement(childPoshiElement);
                continue;
            }
            if (poshiElementName.equals("execute")) {
                PoshiValidation.validateExecuteElement(childPoshiElement);
                continue;
            }
            if (poshiElementName.equals("for")) {
                PoshiValidation.validateForElement(childPoshiElement);
                continue;
            }
            if (poshiElementName.equals("if")) {
                PoshiValidation.validateIfElement(childPoshiElement);
                continue;
            }
            if (poshiElementName.equals("property")) {
                PoshiValidation.validatePropertyElement(childPoshiElement);
                continue;
            }
            if (poshiElementName.equals("return")) {
                PoshiValidation.validateCommandReturnElement(childPoshiElement);
                continue;
            }
            if (poshiElementName.equals("take-screenshot")) {
                PoshiValidation.validateTakeScreenshotElement(childPoshiElement);
                continue;
            }
            if (poshiElementName.equals("task")) {
                PoshiValidation.validateTaskElement(childPoshiElement);
                continue;
            }
            if (poshiElementName.equals("var")) {
                PoshiValidation.validateVarElement(childPoshiElement);
                continue;
            }
            if (!poshiElementName.equals("while")) continue;
            PoshiValidation.validateWhileElement(childPoshiElement);
        }
    }

    protected static void validateArgElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        List<String> attributes = Arrays.asList("line-number", "value");
        PoshiValidation.validatePossibleAttributeNames(poshiElement, attributes);
        PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, attributes, filePath);
    }

    protected static void validateAttributeValue(PoshiElement poshiElement, String attributeValue) {
        int quoteCount;
        int escapedQuoteCount;
        if (attributeValue.contains("\"") && ((escapedQuoteCount = StringUtils.countMatches((String)attributeValue, (String)"\\\"")) != (quoteCount = StringUtils.countMatches((String)attributeValue, (String)"\"")) || escapedQuoteCount % 2 != 0)) {
            _exceptions.add(new PoshiElementException(poshiElement, "Unescaped quotes in parameter value: " + attributeValue));
        }
    }

    protected static void validateCommandElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        List<String> possibleAttributeNames = Arrays.asList("line-number", "name", "prose", "return", "summary", "summary-ignore");
        PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
        PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, Arrays.asList("name"), filePath);
        List<PoshiElement> returnPoshiElements = poshiElement.toPoshiElements(PoshiGetterUtil.getAllChildElements((Element)poshiElement, "return"));
        ArrayList<PoshiElement> commandReturnPoshiElements = new ArrayList<PoshiElement>();
        for (PoshiElement returnPoshiElement : returnPoshiElements) {
            Element parentElement = returnPoshiElement.getParent();
            if (Objects.equals(parentElement.getName(), "execute")) continue;
            commandReturnPoshiElements.add(returnPoshiElement);
        }
        String returnName = poshiElement.attributeValue("return");
        if (Validator.isNull(returnName)) {
            for (PoshiElement commandReturnPoshiElement : commandReturnPoshiElements) {
                String returnVariableName = commandReturnPoshiElement.attributeValue("name");
                String returnVariableValue = commandReturnPoshiElement.attributeValue("value");
                if (!Validator.isNotNull(returnVariableName) || !Validator.isNotNull(returnVariableValue)) continue;
                _exceptions.add(new PoshiElementException(commandReturnPoshiElement, "No return variables were stated in command ", "declaration, but found return name-value ", "mapping"));
            }
        } else if (commandReturnPoshiElements.isEmpty()) {
            _exceptions.add(new PoshiElementException(poshiElement, "Return variable was stated, but no returns were ", "found"));
        } else {
            for (PoshiElement commandReturnPoshiElement : commandReturnPoshiElements) {
                String returnVariableName = commandReturnPoshiElement.attributeValue("name");
                if (Validator.isNull(returnVariableName)) {
                    _exceptions.add(new PoshiElementException(commandReturnPoshiElement, "Return variable was stated as '", returnName, "', but no 'name' attribute was found"));
                    continue;
                }
                if (returnName.equals(returnVariableName)) continue;
                _exceptions.add(new PoshiElementException(commandReturnPoshiElement, "'", returnVariableName, "' not listed as a return variable"));
            }
        }
    }

    protected static void validateCommandReturnElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        PoshiValidation.validateHasNoChildElements(poshiElement);
        PoshiValidation.validatePossibleAttributeNames(poshiElement, Arrays.asList("line-number", "name", "value"));
        PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, Arrays.asList("line-number", "value"), filePath);
    }

    protected static void validateConditionElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        String elementName = poshiElement.getName();
        if (elementName.equals("contains")) {
            PoshiValidation.validateAttributeValue(poshiElement, poshiElement.attributeValue("string"));
            PoshiValidation.validateAttributeValue(poshiElement, poshiElement.attributeValue("substring"));
        }
        if (elementName.equals("and") || elementName.equals("or")) {
            PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
            PoshiValidation.validateHasNoAttributes(poshiElement);
            List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
            Element parentElement = poshiElement.getParent();
            String parentElementName = parentElement.getName();
            int childElementCount = 2;
            if (parentElementName.equals("while")) {
                childElementCount = 1;
            }
            if (childPoshiElements.size() < childElementCount) {
                _exceptions.add(new PoshiElementException(poshiElement, "Too few child elements"));
            }
            for (PoshiElement childPoshiElement : childPoshiElements) {
                PoshiValidation.validateConditionElement(childPoshiElement);
            }
        } else if (elementName.equals("condition")) {
            List<String> possibleAttributeNames;
            List<String> primaryAttributeNames = Arrays.asList("function", "selenium");
            String primaryAttributeName = PoshiValidation.getPrimaryAttributeName(poshiElement, primaryAttributeNames);
            if (Validator.isNull(primaryAttributeName)) {
                return;
            }
            if (primaryAttributeName.equals("function")) {
                possibleAttributeNames = Arrays.asList("function", "line-number", "locator1", "value1");
                PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
            } else if (primaryAttributeName.equals("selenium")) {
                possibleAttributeNames = Arrays.asList("argument1", "argument2", "line-number", "selenium");
                PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
            }
            List<PoshiElement> varPoshiElements = poshiElement.toPoshiElements(poshiElement.elements("var"));
            for (PoshiElement varPoshiElement : varPoshiElements) {
                PoshiValidation.validateVarElement(varPoshiElement);
            }
        } else if (elementName.equals("contains")) {
            List<String> attributeNames = Arrays.asList("line-number", "string", "substring");
            PoshiValidation.validateHasNoChildElements(poshiElement);
            PoshiValidation.validatePossibleAttributeNames(poshiElement, attributeNames);
            PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, attributeNames, filePath);
        } else if (elementName.equals("equals")) {
            List<String> attributeNames = Arrays.asList("arg1", "arg2", "line-number");
            PoshiValidation.validateHasNoChildElements(poshiElement);
            PoshiValidation.validatePossibleAttributeNames(poshiElement, attributeNames);
            PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, attributeNames, filePath);
        } else if (elementName.equals("isset")) {
            List<String> attributeNames = Arrays.asList("line-number", "var");
            PoshiValidation.validateHasNoChildElements(poshiElement);
            PoshiValidation.validatePossibleAttributeNames(poshiElement, attributeNames);
            PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, attributeNames, filePath);
        } else if (elementName.equals("not")) {
            PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
            PoshiValidation.validateHasNoAttributes(poshiElement);
            PoshiValidation.validateNumberOfChildElements((Element)poshiElement, 1, filePath);
            List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
            PoshiValidation.validateConditionElement(childPoshiElements.get(0));
        }
    }

    protected static void validateDefinitionElement(PoshiElement poshiElement) {
        String classType;
        String filePath = PoshiValidation._getFilePath(poshiElement);
        String elementName = poshiElement.getName();
        if (!Objects.equals(elementName, "definition")) {
            _exceptions.add(new PoshiElementException(poshiElement, "Root element name must be definition"));
        }
        if ((classType = PoshiGetterUtil.getClassTypeFromFilePath(filePath)).equals("function")) {
            List<String> possibleAttributeNames = Arrays.asList("default", "line-number", "override", "summary", "summary-ignore");
            PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
            PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, Arrays.asList("default"), filePath);
        } else if (classType.equals("macro")) {
            PoshiValidation.validateHasNoAttributes(poshiElement);
        } else if (classType.equals("testcase")) {
            List<String> possibleAttributeNames = Arrays.asList("extends", "ignore", "ignore-command-names", "line-number");
            PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
        }
    }

    protected static void validateDeprecatedFunction(PoshiElement poshiElement, String functionName) {
        URL filePathURL = poshiElement.getFilePathURL();
        String filePath = filePathURL.getFile();
        if (_deprecatedMethodNames.containsKey(functionName)) {
            String className = PoshiGetterUtil.getClassNameFromFilePath(filePath);
            _deprecatedFunctionNames.add(className + "#" + functionName);
            _logger.warning("Deprecated method \"selenium." + functionName + "\" should be replaced with " + _deprecatedMethodNames.get(functionName) + " at:\n" + filePath + ":" + poshiElement.getPoshiScriptLineNumber());
        }
        if (_deprecatedFunctionNames.contains(functionName)) {
            _logger.warning("Use of function \"" + functionName + "\" contains deprecated selenium method at:\n" + filePath + ":" + poshiElement.getPoshiScriptLineNumber());
        }
    }

    protected static void validateElementName(PoshiElement poshiElement, List<String> possibleElementNames) {
        if (!possibleElementNames.contains(poshiElement.getName())) {
            _exceptions.add(new PoshiElementException(poshiElement, "Missing ", possibleElementNames, " element"));
        }
    }

    protected static void validateElseElement(PoshiElement poshiElement) {
        List<PoshiElement> elsePoshiElements = poshiElement.toPoshiElements(poshiElement.elements("else"));
        if (elsePoshiElements.size() > 1) {
            _exceptions.add(new PoshiElementException(poshiElement, "Too many else elements"));
        }
        if (!elsePoshiElements.isEmpty()) {
            PoshiElement elseElement = elsePoshiElements.get(0);
            PoshiValidation.parseElements(elseElement);
        }
    }

    protected static void validateElseIfElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
        PoshiValidation.validateHasNoAttributes(poshiElement);
        PoshiValidation.validateNumberOfChildElements((Element)poshiElement, 2, filePath);
        PoshiValidation.validateThenElement(poshiElement);
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        List<String> conditionTags = Arrays.asList("and", "condition", "contains", "equals", "isset", "not", "or");
        PoshiElement conditionElement = childPoshiElements.get(0);
        String conditionElementName = conditionElement.getName();
        if (conditionTags.contains(conditionElementName)) {
            PoshiValidation.validateConditionElement(conditionElement);
        } else {
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid ", conditionElementName, " element"));
        }
        PoshiElement thenElement = (PoshiElement)poshiElement.element("then");
        PoshiValidation.validateHasChildElements((Element)thenElement, filePath);
        PoshiValidation.validateHasNoAttributes(thenElement);
        PoshiValidation.parseElements(thenElement);
    }

    protected static void validateExecuteElement(PoshiElement poshiElement) {
        List<String> possibleAttributeNames;
        List<String> primaryAttributeNames = Arrays.asList("function", "macro", "method", "selenium", "test-case");
        String filePath = PoshiValidation._getFilePath(poshiElement);
        if (filePath.endsWith(".function")) {
            primaryAttributeNames = Arrays.asList("function", "selenium");
        } else if (filePath.endsWith(".macro")) {
            primaryAttributeNames = Arrays.asList("function", "macro", "method");
        } else if (filePath.endsWith(".testcase")) {
            primaryAttributeNames = Arrays.asList("function", "macro", "method", "test-case");
        }
        String primaryAttributeName = PoshiValidation.getPrimaryAttributeName(poshiElement, primaryAttributeNames);
        if (primaryAttributeName == null) {
            return;
        }
        if (primaryAttributeName.equals("function")) {
            possibleAttributeNames = Arrays.asList("function", "line-number", "locator1", "locator2", "value1", "value2", "value3");
            String function = poshiElement.attributeValue("function");
            if (Validator.isNotNull(function) && !filePath.endsWith(".function")) {
                PoshiValidation.validateDeprecatedFunction(poshiElement, function);
            }
            PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
            PoshiValidation.validateFunctionContext(poshiElement);
        } else if (primaryAttributeName.equals("macro")) {
            possibleAttributeNames = Arrays.asList("line-number", "macro");
            PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
            PoshiValidation.validateMacroContext(poshiElement, "macro");
        } else if (primaryAttributeName.equals("method")) {
            PoshiValidation.validateMethodExecuteElement(poshiElement);
        } else if (primaryAttributeName.equals("selenium")) {
            possibleAttributeNames = Arrays.asList("argument1", "argument2", "argument3", "line-number", "selenium");
            PoshiValidation.validateDeprecatedFunction(poshiElement, poshiElement.attributeValue("selenium"));
            PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
        } else if (primaryAttributeName.equals("test-case")) {
            possibleAttributeNames = Arrays.asList("line-number", "test-case");
            PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
            PoshiValidation.validateTestCaseContext(poshiElement);
        }
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        if (!childPoshiElements.isEmpty()) {
            PoshiElement returnPoshiElement;
            primaryAttributeNames = Arrays.asList("function", "macro", "method", "selenium", "test-case");
            PoshiValidation.validateHasPrimaryAttributeName(poshiElement, primaryAttributeNames);
            List<String> possibleChildElementNames = Arrays.asList("arg", "prose", "return", "var");
            for (PoshiElement poshiElement2 : childPoshiElements) {
                String childPoshiElementName = poshiElement2.getName();
                if (possibleChildElementNames.contains(childPoshiElementName)) continue;
                _exceptions.add(new PoshiElementException(poshiElement2, "Invalid child element"));
            }
            List<PoshiElement> argPoshiElements = poshiElement.toPoshiElements(poshiElement.elements("arg"));
            for (PoshiElement argPoshiElement : argPoshiElements) {
                PoshiValidation.validateArgElement(argPoshiElement);
            }
            List<PoshiElement> list = poshiElement.toPoshiElements(poshiElement.elements("return"));
            if (list.size() > 1 && primaryAttributeName.equals("macro")) {
                _exceptions.add(new PoshiElementException(poshiElement, "Only 1 child element 'return' is allowed"));
            }
            if ((returnPoshiElement = (PoshiElement)poshiElement.element("return")) != null) {
                if (primaryAttributeName.equals("macro")) {
                    PoshiValidation.validateExecuteReturnMacroElement(returnPoshiElement);
                } else if (primaryAttributeName.equals("method")) {
                    PoshiValidation.validateExecuteReturnMethodElement(returnPoshiElement);
                }
            }
            List<PoshiElement> varPoshiElements = poshiElement.toPoshiElements(poshiElement.elements("var"));
            ArrayList<String> varNames = new ArrayList<String>();
            for (PoshiElement varPoshiElement : varPoshiElements) {
                PoshiValidation.validateVarElement(varPoshiElement);
                String varName = varPoshiElement.attributeValue("name");
                if (varNames.contains(varName)) {
                    _exceptions.add(new PoshiElementException(poshiElement, "Duplicate variable name: " + varName));
                }
                varNames.add(varName);
            }
        }
    }

    protected static void validateExecuteReturnMacroElement(PoshiElement poshiElement) {
        List<String> attributeNames = Arrays.asList("line-number", "name");
        PoshiValidation.validateHasNoChildElements(poshiElement);
        PoshiValidation.validatePossibleAttributeNames(poshiElement, attributeNames);
        PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, attributeNames, PoshiValidation._getFilePath(poshiElement));
    }

    protected static void validateExecuteReturnMethodElement(PoshiElement poshiElement) {
        List<String> attributeNames = Arrays.asList("line-number", "name");
        PoshiValidation.validateHasNoChildElements(poshiElement);
        PoshiValidation.validatePossibleAttributeNames(poshiElement, attributeNames);
        PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, attributeNames, PoshiValidation._getFilePath(poshiElement));
    }

    protected static void validateForElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
        List<String> possibleAttributeNames = Arrays.asList("line-number", "list", "param", "table");
        PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
        List<String> requiredAttributeNames = Arrays.asList("line-number", "param");
        PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, requiredAttributeNames, filePath);
        PoshiValidation.parseElements(poshiElement);
    }

    protected static void validateFunctionContext(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        String function = poshiElement.attributeValue("function");
        PoshiValidation.validateNamespacedClassCommandName(poshiElement, function, "function");
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(function);
        String namespace = PoshiContext.getNamespaceFromFilePath(filePath);
        int locatorCount = PoshiContext.getFunctionLocatorCount(className, namespace);
        for (int i = 0; i < locatorCount; ++i) {
            String locator = poshiElement.attributeValue("locator" + (i + 1));
            if (locator == null) continue;
            Matcher matcher = _pattern.matcher(locator);
            if (locator.startsWith("css=") || !locator.contains("#") || matcher.find()) continue;
            String pathName = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(locator);
            String defaultNamespace = PoshiContext.getDefaultNamespace();
            if (!PoshiContext.isRootElement("path", pathName, namespace) && !PoshiContext.isRootElement("path", pathName, defaultNamespace)) {
                _exceptions.add(new PoshiElementException(poshiElement, "Invalid path name ", pathName));
                continue;
            }
            if (PoshiContext.isPathLocator(locator, namespace) || PoshiContext.isPathLocator(locator, defaultNamespace)) continue;
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid path locator ", locator));
        }
    }

    protected static void validateFunctionFile(PoshiElement poshiElement) {
        PoshiValidation.validateDefinitionElement(poshiElement);
        String filePath = PoshiValidation._getFilePath(poshiElement);
        PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
        PoshiValidation.validateRequiredChildElementNames((Element)poshiElement, Arrays.asList("command"), filePath);
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        for (PoshiElement childPoshiElement : childPoshiElements) {
            PoshiValidation.validateCommandElement(childPoshiElement);
            PoshiValidation.validateHasChildElements((Element)childPoshiElement, filePath);
            PoshiValidation.parseElements(childPoshiElement);
        }
    }

    protected static void validateHasChildElements(Element element, String filePath) {
        List childElements = element.elements();
        if (childElements.isEmpty()) {
            PoshiValidation._addException(element, "Missing child elements", filePath);
        }
    }

    protected static void validateHasMultiplePrimaryAttributeNames(PoshiElement poshiElement, List<String> attributeNames, List<String> multiplePrimaryAttributeNames) {
        if (!multiplePrimaryAttributeNames.equals(attributeNames)) {
            _exceptions.add(new PoshiElementException(poshiElement, "Too many attributes"));
        }
    }

    protected static void validateHasNoAttributes(PoshiElement poshiElement) {
        List attributes = poshiElement.attributes();
        if (!attributes.isEmpty()) {
            for (Attribute attribute : attributes) {
                String attributeName = attribute.getName();
                if (attributeName.equals("line-number")) continue;
                _exceptions.add(new PoshiElementException(poshiElement, "Invalid ", attributeName, " attribute"));
            }
        }
    }

    protected static void validateHasNoChildElements(PoshiElement poshiElement) {
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        if (!childPoshiElements.isEmpty()) {
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid child elements"));
        }
    }

    protected static void validateHasPrimaryAttributeName(PoshiElement poshiElement, List<String> primaryAttributeNames) {
        PoshiValidation.validateHasPrimaryAttributeName(poshiElement, null, primaryAttributeNames);
    }

    protected static void validateHasPrimaryAttributeName(PoshiElement poshiElement, List<String> multiplePrimaryAttributeNames, List<String> primaryAttributeNames) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (String primaryAttributeName : primaryAttributeNames) {
            if (!Validator.isNotNull(poshiElement.attributeValue(primaryAttributeName))) continue;
            attributeNames.add(primaryAttributeName);
        }
        if (attributeNames.isEmpty()) {
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid or missing attribute"));
        } else if (attributeNames.size() > 1) {
            if (multiplePrimaryAttributeNames == null) {
                _exceptions.add(new PoshiElementException(poshiElement, "Too many attributes"));
            } else {
                PoshiValidation.validateHasMultiplePrimaryAttributeNames(poshiElement, attributeNames, multiplePrimaryAttributeNames);
            }
        }
    }

    protected static void validateHasRequiredPropertyElements(PoshiElement poshiElement) {
        ArrayList<String> requiredPropertyNames = new ArrayList<String>(PoshiContext.getRequiredPoshiPropertyNames());
        List<PoshiElement> propertyPoshiElements = poshiElement.toPoshiElements(poshiElement.elements("property"));
        for (PoshiElement propertyPoshiElement : propertyPoshiElements) {
            PoshiValidation.validatePropertyElement(propertyPoshiElement);
            String propertyName = propertyPoshiElement.attributeValue("name");
            if (!requiredPropertyNames.contains(propertyName)) continue;
            requiredPropertyNames.remove(propertyName);
        }
        if (requiredPropertyNames.isEmpty()) {
            return;
        }
        String filePath = PoshiValidation._getFilePath(poshiElement);
        String namespace = PoshiContext.getNamespaceFromFilePath(filePath);
        String className = PoshiGetterUtil.getClassNameFromFilePath(filePath);
        String commandName = poshiElement.attributeValue("name");
        String namespacedClassCommandName = namespace + "." + className + "#" + commandName;
        Properties properties = PoshiContext.getNamespacedClassCommandNameProperties(namespacedClassCommandName);
        for (String requiredPropertyName : requiredPropertyNames) {
            if (properties.containsKey(requiredPropertyName)) continue;
            _exceptions.add(new PoshiElementException(poshiElement, className + "#" + commandName + " is missing required properties ", ((Object)requiredPropertyNames).toString()));
        }
    }

    protected static void validateIfElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
        PoshiValidation.validateHasNoAttributes(poshiElement);
        String fileName = filePath.substring(filePath.lastIndexOf(".") + 1);
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        List<String> conditionTags = Arrays.asList("and", "condition", "contains", "equals", "isset", "not", "or");
        if (fileName.equals("function")) {
            conditionTags = Arrays.asList("and", "condition", "contains", "not", "or");
        }
        PoshiValidation.validateElseElement(poshiElement);
        PoshiValidation.validateThenElement(poshiElement);
        for (int i = 0; i < childPoshiElements.size(); ++i) {
            PoshiElement childPoshiElement = childPoshiElements.get(i);
            String childPoshiElementName = childPoshiElement.getName();
            if (i == 0) {
                if (conditionTags.contains(childPoshiElementName)) {
                    PoshiValidation.validateConditionElement(childPoshiElement);
                    continue;
                }
                _exceptions.add(new PoshiElementException(poshiElement, "Missing or invalid if condition element"));
                continue;
            }
            if (childPoshiElementName.equals("else")) {
                PoshiValidation.validateHasChildElements((Element)childPoshiElement, filePath);
                PoshiValidation.validateHasNoAttributes(childPoshiElement);
                PoshiValidation.parseElements(childPoshiElement);
                continue;
            }
            if (childPoshiElementName.equals("elseif")) {
                PoshiValidation.validateHasChildElements((Element)childPoshiElement, filePath);
                PoshiValidation.validateHasNoAttributes(childPoshiElement);
                PoshiValidation.validateElseIfElement(childPoshiElement);
                continue;
            }
            if (childPoshiElementName.equals("then")) {
                PoshiValidation.validateHasChildElements((Element)childPoshiElement, filePath);
                PoshiValidation.validateHasNoAttributes(childPoshiElement);
                PoshiValidation.parseElements(childPoshiElement);
                continue;
            }
            _exceptions.add(new PoshiElementException(childPoshiElement, "Invalid ", childPoshiElementName, " element"));
        }
    }

    protected static void validateMacroCommandName(PoshiElement poshiElement) {
        String attributeName = poshiElement.attributeValue("name");
        if (attributeName.contains("Url")) {
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid macro command name: ", attributeName, ". Use 'URL' instead of 'Url'"));
        }
    }

    protected static void validateMacroContext(PoshiElement poshiElement, String macroType) {
        PoshiValidation.validateNamespacedClassCommandName(poshiElement, poshiElement.attributeValue(macroType), "macro");
    }

    protected static void validateMacroFile(PoshiElement poshiElement) {
        PoshiValidation.validateDefinitionElement(poshiElement);
        String filePath = PoshiValidation._getFilePath(poshiElement);
        PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
        PoshiValidation.validateRequiredChildElementName((Element)poshiElement, "command", filePath);
        List<PoshiElement> childElements = poshiElement.toPoshiElements(poshiElement.elements());
        List<String> possibleTagElementNames = Arrays.asList("command", "var");
        for (PoshiElement childPoshiElement : childElements) {
            String childPoshiElementName = childPoshiElement.getName();
            if (!possibleTagElementNames.contains(childPoshiElementName)) {
                _exceptions.add(new PoshiElementException(childPoshiElement, "Invalid ", childPoshiElementName, " element"));
            }
            if (childPoshiElementName.equals("command")) {
                PoshiValidation.validateCommandElement(childPoshiElement);
                PoshiValidation.validateHasChildElements((Element)childPoshiElement, filePath);
                PoshiValidation.validateMacroCommandName(childPoshiElement);
                PoshiValidation.parseElements(childPoshiElement);
                continue;
            }
            if (!childPoshiElementName.equals("var")) continue;
            PoshiValidation.validateVarElement(childPoshiElement);
        }
    }

    protected static void validateMessageElement(PoshiElement poshiElement) {
        List<String> possibleAttributeNames = Arrays.asList("line-number", "message");
        PoshiValidation.validateHasNoChildElements(poshiElement);
        PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
        if (poshiElement.attributeValue("message") == null && Validator.isNull(poshiElement.getText())) {
            _exceptions.add(new PoshiElementException(poshiElement, "Missing message attribute"));
        }
    }

    protected static void validateMethodExecuteElement(PoshiElement poshiElement) {
        String className = poshiElement.attributeValue("class");
        Class<?> clazz = null;
        String fullClassName = null;
        if (className.matches("[\\w]*")) {
            for (String packageName : UTIL_PACKAGE_NAMES) {
                try {
                    clazz = Class.forName(packageName + "." + className);
                    fullClassName = packageName + "." + className;
                    break;
                }
                catch (Exception exception) {
                }
            }
        } else {
            try {
                clazz = Class.forName(className);
                fullClassName = className;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fullClassName == null) {
            _exceptions.add(new PoshiElementException(poshiElement, "Unable to find class ", className));
            return;
        }
        try {
            PoshiValidation.validateUtilityClassName(poshiElement, fullClassName);
        }
        catch (PoshiElementException poshiElementException) {
            _exceptions.add(poshiElementException);
            return;
        }
        String methodName = poshiElement.attributeValue("method");
        ArrayList<Method> possibleMethods = new ArrayList<Method>();
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        List<Method> completeMethods = Arrays.asList(clazz.getMethods());
        for (Method possibleMethod : completeMethods) {
            String possibleMethodName = possibleMethod.getName();
            Class<?>[] methodParameterTypes = possibleMethod.getParameterTypes();
            if (!methodName.equals(possibleMethodName) || methodParameterTypes.length != childPoshiElements.size()) continue;
            possibleMethods.add(possibleMethod);
        }
        if (possibleMethods.isEmpty()) {
            _exceptions.add(new PoshiElementException(poshiElement, "Unable to find method ", fullClassName, "#", methodName));
        }
    }

    protected static void validateNamespacedClassCommandName(PoshiElement poshiElement, String namespacedClassCommandName, String classType) {
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName(namespacedClassCommandName);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(namespacedClassCommandName);
        String defaultNamespace = PoshiContext.getDefaultNamespace();
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName(namespacedClassCommandName);
        if (namespace.equals(defaultNamespace)) {
            namespace = PoshiContext.getNamespaceFromFilePath(PoshiValidation._getFilePath(poshiElement));
        }
        if (!PoshiContext.isRootElement(classType, className, namespace) && !PoshiContext.isRootElement(classType, className, defaultNamespace)) {
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid ", classType, " class ", className));
        }
        if (!PoshiContext.isCommandElement(classType, classCommandName, namespace) && !PoshiContext.isCommandElement(classType, classCommandName, defaultNamespace)) {
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid ", classType, " command ", namespacedClassCommandName));
        }
    }

    protected static void validateNumberOfChildElements(Element element, int number, String filePath) {
        List childElements = element.elements();
        if (childElements.isEmpty()) {
            PoshiValidation._addException(element, "Missing child elements", filePath);
        } else if (childElements.size() > number) {
            PoshiValidation._addException(element, "Too many child elements", filePath);
        } else if (childElements.size() < number) {
            PoshiValidation._addException(element, "Too few child elements", filePath);
        }
    }

    protected static void validateOffElement(PoshiElement poshiElement) {
        List<PoshiElement> offPoshiElements = poshiElement.toPoshiElements(poshiElement.elements("off"));
        if (offPoshiElements.size() > 1) {
            _exceptions.add(new ValidationException((Element)poshiElement, "Too many off elements"));
        }
        if (!offPoshiElements.isEmpty()) {
            PoshiElement offElement = offPoshiElements.get(0);
            PoshiValidation.validateHasChildElements((Element)offElement, PoshiValidation._getFilePath(poshiElement));
            PoshiValidation.validateHasNoAttributes(offElement);
            PoshiValidation.parseElements(offElement);
        }
    }

    protected static void validateOnElement(PoshiElement poshiElement) {
        List<PoshiElement> onPoshiElements = poshiElement.toPoshiElements(poshiElement.elements("off"));
        if (onPoshiElements.size() > 1) {
            _exceptions.add(new PoshiElementException(poshiElement, "Too many off elements"));
        }
        if (!onPoshiElements.isEmpty()) {
            PoshiElement onElement = onPoshiElements.get(0);
            PoshiValidation.validateHasChildElements((Element)onElement, PoshiValidation._getFilePath(poshiElement));
            PoshiValidation.validateHasNoAttributes(onElement);
            PoshiValidation.parseElements(onElement);
        }
    }

    protected static void validatePathFile(Element element, String filePath) {
        Element trElement2;
        String className = PoshiGetterUtil.getClassNameFromFilePath(filePath);
        String rootElementName = element.getName();
        if (!Objects.equals(rootElementName, "html")) {
            _exceptions.add(new ValidationException(element, "Invalid ", rootElementName, " element\n", filePath));
        }
        PoshiValidation.validateHasChildElements(element, filePath);
        PoshiValidation.validateNumberOfChildElements(element, 2, filePath);
        PoshiValidation.validateRequiredChildElementNames(element, Arrays.asList("body", "head"), filePath);
        Element bodyElement = element.element("body");
        PoshiValidation.validateHasChildElements(bodyElement, filePath);
        PoshiValidation.validateNumberOfChildElements(bodyElement, 1, filePath);
        PoshiValidation.validateRequiredChildElementName(bodyElement, "table", filePath);
        Element tableElement = bodyElement.element("table");
        List<String> requiredTableAttributeNames = Arrays.asList("border", "cellpadding", "cellspacing", "line-number");
        PoshiValidation.validateHasChildElements(tableElement, filePath);
        PoshiValidation.validateNumberOfChildElements(tableElement, 2, filePath);
        PoshiValidation.validateRequiredAttributeNames(tableElement, requiredTableAttributeNames, filePath);
        PoshiValidation.validateRequiredChildElementNames(tableElement, Arrays.asList("tbody", "thead"), filePath);
        Element tBodyElement = tableElement.element("tbody");
        List trElements = tBodyElement.elements();
        if (trElements != null) {
            for (Element trElement2 : trElements) {
                String namespace;
                Element pathRootElement;
                PoshiValidation.validateHasChildElements(trElement2, filePath);
                PoshiValidation.validateNumberOfChildElements(trElement2, 3, filePath);
                PoshiValidation.validateRequiredChildElementName(trElement2, "td", filePath);
                List tdElements = trElement2.elements();
                Element locatorElement = (Element)tdElements.get(1);
                String locator = locatorElement.getText();
                Element locatorKeyElement = (Element)tdElements.get(0);
                String locatorKey = locatorKeyElement.getText();
                if (Validator.isNull(locator) != Validator.isNull(locatorKey)) {
                    _exceptions.add(new ValidationException(trElement2, "Missing locator\n", filePath));
                }
                if (!locatorKey.equals("EXTEND_ACTION_PATH") || (pathRootElement = PoshiContext.getPathRootElement(locator, namespace = PoshiContext.getNamespaceFromFilePath(filePath))) != null) continue;
                _exceptions.add(new ValidationException(trElement2, "Nonexistent parent path file\n", filePath));
            }
        }
        Element theadElement = tableElement.element("thead");
        PoshiValidation.validateHasChildElements(theadElement, filePath);
        PoshiValidation.validateNumberOfChildElements(theadElement, 1, filePath);
        PoshiValidation.validateRequiredChildElementName(theadElement, "tr", filePath);
        trElement2 = theadElement.element("tr");
        PoshiValidation.validateHasChildElements(trElement2, filePath);
        PoshiValidation.validateNumberOfChildElements(trElement2, 1, filePath);
        PoshiValidation.validateRequiredChildElementName(trElement2, "td", filePath);
        Element tdElement = trElement2.element("td");
        PoshiValidation.validateRequiredAttributeNames(tdElement, Arrays.asList("colspan", "rowspan"), filePath);
        String theadClassName = tdElement.getText();
        if (Validator.isNull(theadClassName)) {
            _exceptions.add(new ValidationException(trElement2, "Missing thead class name\n", filePath));
        } else if (!Objects.equals(theadClassName, className)) {
            _exceptions.add(new ValidationException(trElement2, "Thead class name does not match file name\n", filePath));
        }
        Element headElement = element.element("head");
        PoshiValidation.validateHasChildElements(headElement, filePath);
        PoshiValidation.validateNumberOfChildElements(headElement, 1, filePath);
        PoshiValidation.validateRequiredChildElementName(headElement, "title", filePath);
        Element titleElement = headElement.element("title");
        if (!Objects.equals(titleElement.getText(), className)) {
            _exceptions.add(new ValidationException(titleElement, "File name and title are different\n", filePath));
        }
    }

    protected static void validatePossibleAttributeNames(PoshiElement poshiElement, List<String> possibleAttributeNames) {
        List attributes = poshiElement.attributes();
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (possibleAttributeNames.contains(attributeName)) continue;
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid ", attributeName, " attribute"));
        }
    }

    protected static void validatePossiblePropertyValues(PoshiElement propertyPoshiElement) {
        String propertyName = propertyPoshiElement.attributeValue("name");
        String testCaseAvailablePropertyValues = PropsUtil.get("test.case.available.property.values[" + propertyName + "]");
        if (Validator.isNotNull(testCaseAvailablePropertyValues)) {
            List<String> possiblePropertyValues = Arrays.asList(StringUtil.split(testCaseAvailablePropertyValues));
            List<String> propertyValues = Arrays.asList(StringUtil.split(propertyPoshiElement.attributeValue("value")));
            for (String propertyValue : propertyValues) {
                if (possiblePropertyValues.contains(propertyValue.trim())) continue;
                _exceptions.add(new PoshiElementException(propertyPoshiElement, "Invalid property value '", propertyValue.trim(), "' for property name '", propertyName.trim()));
            }
        }
    }

    protected static void validatePropertyElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        List<String> attributeNames = Arrays.asList("line-number", "name");
        if (Validator.isNotNull(poshiElement.attributeValue("value"))) {
            attributeNames.add("value");
        } else {
            boolean hasValue = false;
            for (Node node : Dom4JUtil.toNodeList(poshiElement.content())) {
                if (!(node instanceof CDATA) && !(node instanceof Text)) continue;
                hasValue = true;
            }
            if (!hasValue) {
                PoshiValidation._addException((Element)poshiElement, poshiElement.attributeValue("name") + " has no value", filePath);
            }
        }
        PoshiValidation.validateHasNoChildElements(poshiElement);
        PoshiValidation.validatePossibleAttributeNames(poshiElement, attributeNames);
        PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, attributeNames, filePath);
        PoshiValidation.validatePossiblePropertyValues(poshiElement);
    }

    protected static void validateRequiredAttributeNames(Element element, List<String> requiredAttributeNames, String filePath) {
        for (String requiredAttributeName : requiredAttributeNames) {
            if (requiredAttributeName.equals("line-number") && element instanceof PoshiElement || element.attributeValue(requiredAttributeName) != null) continue;
            PoshiValidation._addException(element, "Missing " + requiredAttributeName + " attribute", filePath);
        }
    }

    protected static void validateRequiredChildElementName(Element element, String requiredElementName, String filePath) {
        boolean found = false;
        List childElements = element.elements();
        for (Element childElement : childElements) {
            if (!Objects.equals(childElement.getName(), requiredElementName)) continue;
            found = true;
            break;
        }
        if (!found) {
            PoshiValidation._addException(element, "Missing required " + requiredElementName + " child element", filePath);
        }
    }

    protected static void validateRequiredChildElementNames(Element element, List<String> requiredElementNames, String filePath) {
        for (String requiredElementName : requiredElementNames) {
            PoshiValidation.validateRequiredChildElementName(element, requiredElementName, filePath);
        }
    }

    protected static void validateSeleniumMethodAttributeValue(PoshiElement poshiElement, String methodAttributeValue) {
        Matcher seleniumGetterMethodMatcher = _seleniumGetterMethodPattern.matcher(methodAttributeValue);
        seleniumGetterMethodMatcher.find();
        String seleniumMethodName = seleniumGetterMethodMatcher.group("methodName");
        if (seleniumMethodName.equals("getCurrentUrl")) {
            return;
        }
        LiferaySeleniumMethod liferaySeleniumMethod = PoshiContext.getLiferaySeleniumMethod(seleniumMethodName);
        if (liferaySeleniumMethod == null) {
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid Selenium method name: \"", seleniumMethodName, "\"\n"));
            return;
        }
        int seleniumParameterCount = liferaySeleniumMethod.getParameterCount();
        List<String> methodParameterValues = PoshiScriptParserUtil.getMethodParameterValues(seleniumGetterMethodMatcher.group("methodParameters"), poshiElement);
        if (methodParameterValues.size() != seleniumParameterCount) {
            _exceptions.add(new PoshiElementException(poshiElement, "Expected ", seleniumParameterCount, " parameter(s) for method \"", seleniumMethodName, "\" but found ", methodParameterValues.size()));
        }
        for (String methodParameterValue : methodParameterValues) {
            Matcher invalidMethodParameterMatcher = _invalidMethodParameterPattern.matcher(methodParameterValue);
            if (!invalidMethodParameterMatcher.find()) continue;
            String invalidSyntax = invalidMethodParameterMatcher.group("invalidSyntax");
            _exceptions.add(new PoshiElementException(poshiElement, "Invalid parameter syntax \"", invalidSyntax, "\"\n"));
        }
    }

    protected static void validateTakeScreenshotElement(PoshiElement poshiElement) {
        PoshiValidation.validateHasNoAttributes(poshiElement);
        PoshiValidation.validateHasNoChildElements(poshiElement);
    }

    protected static void validateTaskElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        List<String> possibleAttributeNames = Arrays.asList("line-number", "macro-summary", "summary");
        PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
        PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
        List<String> primaryAttributeNames = Arrays.asList("macro-summary", "summary");
        PoshiValidation.validateHasPrimaryAttributeName(poshiElement, primaryAttributeNames);
        PoshiValidation.parseElements(poshiElement);
    }

    protected static void validateTestCaseContext(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        String namespace = PoshiContext.getNamespaceFromFilePath(filePath);
        String testName = poshiElement.attributeValue("test-case");
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(testName);
        if (className.equals("super")) {
            className = PoshiGetterUtil.getExtendedTestCaseName(filePath);
        }
        String commandName = PoshiGetterUtil.getCommandNameFromNamespacedClassCommandName(testName);
        PoshiValidation.validateTestName(namespace + "." + className + "#" + commandName);
    }

    protected static void validateTestCaseFile(PoshiElement poshiElement) {
        PoshiValidation.validateDefinitionElement(poshiElement);
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        String filePath = PoshiValidation._getFilePath(poshiElement);
        if (Validator.isNull(poshiElement.attributeValue("extends"))) {
            PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
            PoshiValidation.validateRequiredChildElementName((Element)poshiElement, "command", filePath);
        }
        List<String> possibleTagElementNames = Arrays.asList("command", "property", "set-up", "tear-down", "var");
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (PoshiElement childPoshiElement : childPoshiElements) {
            String childPoshiElementName = childPoshiElement.getName();
            if (!possibleTagElementNames.contains(childPoshiElementName)) {
                _exceptions.add(new PoshiElementException(childPoshiElement, "Invalid ", childPoshiElementName, " element"));
            }
            if (childPoshiElementName.equals("command")) {
                List<String> possibleAttributeNames = Arrays.asList("annotations", "description", "disable-webdriver", "ignore", "known-issues", "line-number", "name", "priority");
                PoshiValidation.validateHasChildElements((Element)childPoshiElement, filePath);
                PoshiValidation.validateHasRequiredPropertyElements(childPoshiElement);
                PoshiValidation.validatePossibleAttributeNames(childPoshiElement, possibleAttributeNames);
                PoshiValidation.validateRequiredAttributeNames((Element)childPoshiElement, Arrays.asList("name"), filePath);
                PoshiValidation.parseElements(childPoshiElement);
                continue;
            }
            if (childPoshiElementName.equals("property")) {
                PoshiValidation.validatePropertyElement(childPoshiElement);
                String propertyName = childPoshiElement.attributeValue("name");
                if (!propertyNames.contains(propertyName)) {
                    propertyNames.add(propertyName);
                    continue;
                }
                _exceptions.add(new PoshiElementException(childPoshiElement, "Duplicate property name ", propertyName));
                continue;
            }
            if (childPoshiElementName.equals("set-up") || childPoshiElementName.equals("tear-down")) {
                PoshiValidation.validateHasChildElements((Element)childPoshiElement, filePath);
                PoshiValidation.validateHasNoAttributes(childPoshiElement);
                PoshiValidation.parseElements(childPoshiElement);
                continue;
            }
            if (!childPoshiElementName.equals("var")) continue;
            PoshiValidation.validateVarElement(childPoshiElement);
        }
    }

    protected static void validateTestName(String testName) {
        String classCommandName;
        String namespace;
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(testName);
        if (!PoshiContext.isRootElement("test-case", className, namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName(testName))) {
            _exceptions.add(new ValidationException(new String[]{"Invalid test case class " + namespace + "." + className}));
        } else if (testName.contains("#") && !PoshiContext.isCommandElement("test-case", classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName(testName), namespace)) {
            String commandName = PoshiGetterUtil.getCommandNameFromNamespacedClassCommandName(testName);
            _exceptions.add(new ValidationException(new String[]{"Invalid test case command " + commandName}));
        }
    }

    protected static void validateThenElement(PoshiElement poshiElement) {
        List<PoshiElement> thenPoshiElements = poshiElement.toPoshiElements(poshiElement.elements("then"));
        if (thenPoshiElements.isEmpty()) {
            _exceptions.add(new PoshiElementException(poshiElement, "Missing then element"));
        } else if (thenPoshiElements.size() > 1) {
            _exceptions.add(new PoshiElementException(poshiElement, "Too many then elements"));
        }
    }

    protected static void validateUtilityClassName(PoshiElement poshiElement, String className) throws PoshiElementException {
        if (!className.startsWith("selenium")) {
            if (!className.contains(".")) {
                try {
                    className = PoshiGetterUtil.getUtilityClassName(className);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new PoshiElementException(poshiElement, illegalArgumentException.getMessage());
                }
            }
            if (!PoshiGetterUtil.isValidUtilityClass(className)) {
                throw new PoshiElementException(poshiElement, className, " is an invalid utility class");
            }
        }
    }

    protected static void validateVarElement(PoshiElement poshiElement) {
        Element parentElement;
        String filePath = PoshiValidation._getFilePath(poshiElement);
        PoshiValidation.validateHasNoChildElements(poshiElement);
        PoshiValidation.validateRequiredAttributeNames((Element)poshiElement, Arrays.asList("name"), filePath);
        List attributes = poshiElement.attributes();
        int minimumAttributeSize = 1;
        if (attributes.size() <= minimumAttributeSize && Validator.isNull(poshiElement.getText())) {
            _exceptions.add(new PoshiElementException(poshiElement, "Missing value attribute"));
        }
        ArrayList<String> possibleAttributeNames = new ArrayList<String>();
        Collections.addAll(possibleAttributeNames, "from", "hash", "index", "line-number", "method", "name", "type", "value");
        if (filePath.contains(".macro")) {
            possibleAttributeNames.add("static");
        }
        if ((parentElement = poshiElement.getParent()) != null) {
            String parentElementName = parentElement.getName();
            if (filePath.contains(".testcase") && parentElementName.equals("definition")) {
                possibleAttributeNames.add("static");
            }
        }
        PoshiValidation.validatePossibleAttributeNames(poshiElement, possibleAttributeNames);
        if (Validator.isNotNull(poshiElement.attributeValue("method"))) {
            int x;
            String methodAttributeValue = poshiElement.attributeValue("method");
            String className = methodAttributeValue.substring(0, x = methodAttributeValue.indexOf("#"));
            if (className.equals("selenium")) {
                PoshiValidation.validateSeleniumMethodAttributeValue(poshiElement, methodAttributeValue);
            }
            try {
                PoshiValidation.validateUtilityClassName(poshiElement, className);
            }
            catch (PoshiElementException poshiElementException) {
                _exceptions.add(poshiElementException);
            }
            int expectedAttributeCount = 0;
            if (Validator.isNotNull(poshiElement.attributeValue("name"))) {
                ++expectedAttributeCount;
            }
            if (PoshiGetterUtil.getLineNumber((Element)poshiElement) != -1) {
                ++expectedAttributeCount;
            }
            if (Validator.isNotNull(poshiElement.attributeValue("static"))) {
                ++expectedAttributeCount;
            }
            if (attributes.size() < expectedAttributeCount) {
                _exceptions.add(new PoshiElementException(poshiElement, "Too few attributes"));
            }
            if (attributes.size() > expectedAttributeCount) {
                _exceptions.add(new PoshiElementException(poshiElement, "Too many attributes"));
            }
        }
    }

    protected static void validateWhileElement(PoshiElement poshiElement) {
        String filePath = PoshiValidation._getFilePath(poshiElement);
        PoshiValidation.validateHasChildElements((Element)poshiElement, filePath);
        PoshiValidation.validatePossibleAttributeNames(poshiElement, Arrays.asList("line-number", "max-iterations"));
        PoshiValidation.validateThenElement(poshiElement);
        List<String> conditionTags = Arrays.asList("and", "condition", "contains", "equals", "isset", "not", "or");
        List<PoshiElement> childPoshiElements = poshiElement.toPoshiElements(poshiElement.elements());
        for (int i = 0; i < childPoshiElements.size(); ++i) {
            PoshiElement childPoshiElement = childPoshiElements.get(i);
            String childPoshiElementName = childPoshiElement.getName();
            if (i == 0) {
                if (conditionTags.contains(childPoshiElementName)) {
                    PoshiValidation.validateConditionElement(childPoshiElement);
                    continue;
                }
                _exceptions.add(new PoshiElementException(poshiElement, "Missing while condition element"));
                continue;
            }
            if (childPoshiElementName.equals("then")) {
                PoshiValidation.validateHasChildElements((Element)childPoshiElement, filePath);
                PoshiValidation.validateHasNoAttributes(childPoshiElement);
                PoshiValidation.parseElements(childPoshiElement);
                continue;
            }
            _exceptions.add(new PoshiElementException(childPoshiElement, "Invalid ", childPoshiElementName, " element"));
        }
    }

    private static void _addException(Element element, String message, String filePath) {
        if (element instanceof PoshiElement) {
            _exceptions.add(new PoshiElementException((PoshiElement)element, message));
            return;
        }
        _exceptions.add(new ValidationException(element, message, filePath));
    }

    private static String _getFilePath(PoshiElement poshiElement) {
        URL filePathURL = poshiElement.getFilePathURL();
        String filePath = filePathURL.getPath();
        if (OSDetector.isWindows()) {
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            }
            filePath = StringUtil.replace(filePath, "/", "\\");
        }
        return filePath;
    }

    private static void _throwExceptions() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        sb.append(_exceptions.size());
        sb.append(" errors in POSHI\n\n");
        for (Exception exception : _exceptions) {
            sb.append(exception.getMessage());
            sb.append("\n\n");
        }
        System.out.println(sb.toString());
        throw new Exception();
    }

    private static class ValidationException
    extends Exception {
        public ValidationException(Element element, Object ... messageParts) {
            super(PoshiElementException.join(PoshiElementException.join(messageParts), ":", PoshiGetterUtil.getLineNumber(element)));
        }

        public ValidationException(String ... messageParts) {
            super(PoshiElementException.join(messageParts));
        }
    }
}

