/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import java.util.Locale;
import java.util.TimeZone;

public class CompanyThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static final CentralizedThreadLocal<Long> _companyId = new CentralizedThreadLocal<Long>(CompanyThreadLocal.class + "._companyId", () -> 0L);
    private static final ThreadLocal<Boolean> _deleteInProcess = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._deleteInProcess", () -> Boolean.FALSE);
    private static final CentralizedThreadLocal<Boolean> _initializingPortalInstance = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._initializingPortalInstance", () -> Boolean.FALSE);
    private static final ThreadLocal<Boolean> _locked = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._locked", () -> Boolean.FALSE);

    public static Long getCompanyId() {
        Long companyId = _companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("getCompanyId " + companyId);
        }
        return companyId;
    }

    public static boolean isDeleteInProcess() {
        return _deleteInProcess.get();
    }

    public static boolean isInitializingPortalInstance() {
        return _initializingPortalInstance.get();
    }

    public static boolean isLocked() {
        return _locked.get();
    }

    public static SafeCloseable lock(long companyId) {
        SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable(companyId);
        _locked.set(true);
        return () -> {
            _locked.set(false);
            safeCloseable.close();
        };
    }

    public static void setCompanyId(Long companyId) {
        if (CompanyThreadLocal._setCompanyId(companyId)) {
            CTCollectionThreadLocal.removeCTCollectionId();
        }
    }

    public static void setDeleteInProcess(boolean deleteInProcess) {
        _deleteInProcess.set(deleteInProcess);
    }

    public static SafeCloseable setInitializingCompanyIdWithSafeCloseable(long companyId) {
        if (companyId > 0L) {
            return _companyId.setWithSafeCloseable(companyId);
        }
        return _companyId.setWithSafeCloseable(0L);
    }

    public static SafeCloseable setInitializingPortalInstance(boolean initializingPortalInstance) {
        return _initializingPortalInstance.setWithSafeCloseable(initializingPortalInstance);
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId) {
        return CompanyThreadLocal.setWithSafeCloseable(companyId, 0L);
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId, Long ctCollectionId) {
        long currentCompanyId = _companyId.get();
        Locale defaultLocale = LocaleThreadLocal.getDefaultLocale();
        TimeZone defaultTimeZone = TimeZoneThreadLocal.getDefaultTimeZone();
        CompanyThreadLocal._setCompanyId(companyId);
        SafeCloseable ctCollectionSafeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);
        return () -> {
            _companyId.set(currentCompanyId);
            LocaleThreadLocal.setDefaultLocale(defaultLocale);
            TimeZoneThreadLocal.setDefaultTimeZone(defaultTimeZone);
            ctCollectionSafeCloseable.close();
        };
    }

    private static boolean _setCompanyId(Long companyId) {
        if (companyId.equals(_companyId.get())) {
            return false;
        }
        if (CompanyThreadLocal.isLocked()) {
            throw new UnsupportedOperationException("CompanyThreadLocal modification is not allowed");
        }
        if (_log.isDebugEnabled()) {
            _log.debug("setCompanyId " + companyId);
        }
        if (companyId > 0L) {
            _companyId.set(companyId);
        } else {
            _companyId.set(0L);
        }
        LocaleThreadLocal.setDefaultLocale(null);
        TimeZoneThreadLocal.setDefaultTimeZone(null);
        return true;
    }
}

