/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesCommentsCheck
extends BaseFileCheck {
    private static final String[] _BRAND_NAMES = new String[]{"jQuery", "reCAPTCHA", "svg4everybody", "tc"};
    private static final Pattern _commentPattern = Pattern.compile("([^#]\\s*)?\\n\\s*#+\\s+(\\w[\\s\\w]+)(\\n\\s*#+.*[\\w]+.*)?$", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatComments(content);
    }

    private String _formatComments(String content) {
        Matcher matcher = _commentPattern.matcher(content);
        while (matcher.find()) {
            if (matcher.group(1) != null || matcher.group(3) != null) continue;
            String comment = matcher.group(2);
            String titleCaseComment = StringUtil.getTitleCase(comment, true, _BRAND_NAMES);
            if ((titleCaseComment = titleCaseComment.replaceAll("(?i)(\\A|\\s)sf(\\Z|\\s)", "$1Source Formatter$2")).equals(comment)) continue;
            return StringUtil.replaceFirst(content, comment, titleCaseComment, matcher.start(2));
        }
        return content;
    }
}

