/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.XMLSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLIndentationCheck
extends BaseFileCheck {
    private static final String _CDATA_CLOSE = "]]>";
    private static final String _CDATA_OPEN = "<![CDATA[";
    private static final String _CLOSING_TAG_OPEN = "</";
    private static final String _COMMENT_TAG_CLOSE = "-->";
    private static final String _COMMENT_TAG_OPEN = "<!--";
    private static final String _DOCTYPE_TAG_OPEN = "<!";
    private static final String _HEADER_TAG_OPEN = "<?";
    private static final String _MULTI_LINE_TAG_CLOSE = "/>";
    private static final String _TAG_CLOSE = ">";
    private static final String _TAG_OPEN = "<";
    private static final Pattern _incorrectLineBreakPattern1 = Pattern.compile("(</[-\\w:]+>)( *)(</[-\\w:]+>)");
    private static final Pattern _incorrectLineBreakPattern2 = Pattern.compile("(?!\")(/>)( *)(</[-\\w:]+>)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._fixLineBreak(content);
        String newContent;
        while (!(newContent = this._fixTagsIndentation(content)).equals(content)) {
            content = newContent;
        }
        return newContent;
    }

    private String _fixIndentation(String content, String line, int expectedTabCount, int lineNumber) {
        StringBundler sb = new StringBundler(expectedTabCount + 1);
        for (int i = 0; i < expectedTabCount; ++i) {
            sb.append('\t');
        }
        sb.append(StringUtil.trim(line));
        String newLine = sb.toString();
        if (line.equals(newLine)) {
            return content;
        }
        return StringUtil.replaceFirst(content, line, newLine, this.getLineStartPos(content, lineNumber));
    }

    private String _fixLineBreak(String content) {
        int x = -1;
        while ((x = content.indexOf(_TAG_CLOSE, x + 2)) != -1) {
            String s = content.substring(x + 1);
            if (Validator.isNull(s) || StringUtil.startsWith(s, "\n") || !(s = StringUtil.trimLeading(s)).startsWith(_TAG_OPEN) || s.startsWith(_CLOSING_TAG_OPEN) || s.startsWith(_CDATA_OPEN) || XMLSourceUtil.isInsideCDATAMarkup(content, x)) continue;
            content = StringUtil.insert(content, "\n", x + 1);
        }
        Matcher matcher = _incorrectLineBreakPattern1.matcher(content);
        while (matcher.find()) {
            String s = matcher.group(1);
            if (s.equals("</code>") || XMLSourceUtil.isInsideCDATAMarkup(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, matcher.group(2), "\n", matcher.start(2));
        }
        matcher = _incorrectLineBreakPattern2.matcher(content);
        while (matcher.find()) {
            if (XMLSourceUtil.isInsideCDATAMarkup(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, matcher.group(2), "\n", matcher.start(2));
        }
        return content;
    }

    private String _fixMultiLineTagAttributesIndentation(String content, String[] lines, TokenOccurrence previousTokenOccurrence, TokenOccurrence tokenOccurrence, int expectedTabCount) {
        if (previousTokenOccurrence == null || tokenOccurrence.getLineNumber() == previousTokenOccurrence.getLineNumber()) {
            return content;
        }
        String previousToken = previousTokenOccurrence.getToken();
        if (!previousToken.equals(_TAG_OPEN)) {
            return content;
        }
        String token = tokenOccurrence.getToken();
        if (!token.equals(_MULTI_LINE_TAG_CLOSE) && !token.equals(_TAG_CLOSE)) {
            return content;
        }
        String startLine = lines[previousTokenOccurrence.getLineNumber() - 1];
        if (!startLine.matches("\\s*<[-\\w:]+")) {
            return content;
        }
        for (int i = previousTokenOccurrence.getLineNumber() + 1; i < tokenOccurrence.getLineNumber(); ++i) {
            String line = lines[i - 1];
            if (!line.matches("\\s*[\\w-]+=.*")) continue;
            content = this._fixIndentation(content, line, expectedTabCount, i);
        }
        return content;
    }

    private String _fixTagIndentation(String content, String line, TokenOccurrence tokenOccurrence, int expectedTabCount) {
        if (tokenOccurrence.getLinePos() != 0) {
            return content;
        }
        String token = tokenOccurrence.getToken();
        if (token.equals(_CDATA_CLOSE) || token.equals(_CDATA_OPEN) || token.equals(_COMMENT_TAG_CLOSE)) {
            return content;
        }
        if (token.equals(_CLOSING_TAG_OPEN) || token.equals(_TAG_CLOSE) || token.equals(_MULTI_LINE_TAG_CLOSE)) {
            --expectedTabCount;
        }
        return this._fixIndentation(content, line, expectedTabCount, tokenOccurrence.getLineNumber());
    }

    private String _fixTagsIndentation(String content) {
        String[] lines = StringUtil.splitLines(content);
        int level = 0;
        String[] tokens = new String[]{_COMMENT_TAG_OPEN, _DOCTYPE_TAG_OPEN, _HEADER_TAG_OPEN, _TAG_OPEN};
        TokenOccurrence previousTokenOccurrence = null;
        TokenOccurrence tokenOccurrence;
        while ((tokenOccurrence = this._getNextTokenOccurrence(lines, previousTokenOccurrence, tokens)) != null) {
            String newContent = this._fixTagIndentation(content, lines[tokenOccurrence.getLineNumber() - 1], tokenOccurrence, level);
            if (!(newContent = this._fixMultiLineTagAttributesIndentation(newContent, lines, previousTokenOccurrence, tokenOccurrence, level)).equals(content)) {
                return newContent;
            }
            String token = tokenOccurrence.getToken();
            if (token.equals(_CDATA_OPEN)) {
                tokens = new String[]{_CDATA_CLOSE};
            } else if (token.equals(_CLOSING_TAG_OPEN)) {
                --level;
                tokens = new String[]{_TAG_CLOSE};
            } else if (token.equals(_COMMENT_TAG_OPEN)) {
                tokens = new String[]{_COMMENT_TAG_CLOSE};
            } else if (token.equals(_DOCTYPE_TAG_OPEN) || token.equals(_HEADER_TAG_OPEN)) {
                tokens = new String[]{_TAG_CLOSE};
            } else if (token.equals(_TAG_OPEN)) {
                ++level;
                tokens = new String[]{_MULTI_LINE_TAG_CLOSE, _TAG_CLOSE};
            } else {
                if (token.equals(_MULTI_LINE_TAG_CLOSE)) {
                    --level;
                }
                tokens = new String[]{_CDATA_OPEN, _CLOSING_TAG_OPEN, _COMMENT_TAG_OPEN, _DOCTYPE_TAG_OPEN, _HEADER_TAG_OPEN, _TAG_OPEN};
            }
            previousTokenOccurrence = tokenOccurrence;
        }
        return content;
    }

    private int _getFirstMatchPos(String line, int startPos, String token) {
        int i;
        int pos = startPos;
        do {
            if ((pos = line.indexOf(token, pos + 1)) != -1 && (token.equals(_MULTI_LINE_TAG_CLOSE) || token.equals(_TAG_CLOSE))) continue;
            return pos;
        } while (ToolsUtil.isInsideQuotes(line.substring(i = Math.max(0, startPos)), pos - i, false));
        return pos;
    }

    private TokenOccurrence _getNextTokenOccurrence(String[] lines, TokenOccurrence previousTokenOccurrence, String ... tokens) {
        int startLine = 1;
        int startPos = -1;
        if (previousTokenOccurrence != null) {
            startLine = previousTokenOccurrence.getLineNumber();
            startPos = previousTokenOccurrence.getLinePos();
        }
        String match = null;
        int min = -1;
        for (int i = startLine; i < lines.length; ++i) {
            String line = StringUtil.trim(lines[i - 1]);
            if (Validator.isNull(line)) continue;
            for (String token : tokens) {
                int matchPos = this._getFirstMatchPos(line, startPos, token);
                if (matchPos == -1 || min != -1 && min <= matchPos) continue;
                match = token;
                min = matchPos;
            }
            if (min != -1) {
                return new TokenOccurrence(i, min, match);
            }
            startPos = -1;
        }
        return null;
    }

    private class TokenOccurrence {
        private final int _lineNumber;
        private final int _linePos;
        private final String _token;

        public TokenOccurrence(int lineNumber, int linePos, String token) {
            this._lineNumber = lineNumber;
            this._linePos = linePos;
            this._token = token;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public int getLinePos() {
            return this._linePos;
        }

        public String getToken() {
            return this._token;
        }
    }
}

