/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLSolrSchemaFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (fileName.endsWith("/schema.xml") && absolutePath.contains("solr")) {
            this._checkSolrSchemaXML(fileName, content);
        }
        return content;
    }

    private void _checkSolrSchemaXML(String fileName, String content) throws DocumentException {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        this.checkElementOrder(fileName, rootElement.element("fields"), "field", null, new ElementComparator());
        this.checkElementOrder(fileName, rootElement.element("types"), "fieldType", null, new ElementComparator());
    }
}

