/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JSStylingCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (content.contains("debugger.")) {
			addMessage(fileName, "Do not use debugger");
		}

		return _formatMultipleVarsOnSingleLine(content);
	}

	private String _formatMultipleVarsOnSingleLine(String content) {
		while (true) {
			Matcher matcher = _multipleVarsOnSingleLinePattern.matcher(content);

			if (!matcher.find()) {
				break;
			}

			String match = matcher.group();

			int pos = match.indexOf("var ");

			content = StringUtil.replace(
				content, match,
				StringBundler.concat(
					match.substring(0, match.length() - 2), ";\n",
					match.substring(0, pos + 4)));
		}

		return content;
	}

	private static final Pattern _multipleVarsOnSingleLinePattern =
		Pattern.compile("\t+var \\w+\\, ");

}