/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiPauseUsageCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith(".path")) {
            return content;
        }
        List<String> jiraProjectKeys = this._getJIRAProjectKeys();
        if (jiraProjectKeys.isEmpty()) {
            return content;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = "";
            String previousLine = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                if (Validator.isNull(line)) continue;
                String trimmedLine = StringUtil.trimLeading(line);
                if (!trimmedLine.startsWith("Pause(")) {
                    previousLine = trimmedLine;
                    continue;
                }
                if (previousLine.startsWith("//")) {
                    String jiraTicketId = this._getJIRATicketId(previousLine, jiraProjectKeys);
                    if (Validator.isNull(jiraTicketId)) {
                        this.addMessage(fileName, "Missing a required JIRA project in comment before using 'Pause'", lineNumber);
                    }
                } else {
                    this.addMessage(fileName, "Missing a comment before using 'Pause'", lineNumber);
                }
                previousLine = trimmedLine;
            }
        }
        return content;
    }

    private List<String> _getJIRAProjectKeys() throws Exception {
        File propertiesFile = this.getFile("ci.properties", this.getMaxDirLevel());
        if (propertiesFile != null) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(propertiesFile));
            if (properties.containsKey("jira.project.keys")) {
                return ListUtil.fromString(properties.getProperty("jira.project.keys"), ",");
            }
        }
        return Collections.emptyList();
    }

    private String _getJIRATicketId(String comment, List<String> jiraProjectKeys) {
        for (String jiraProjectKey : jiraProjectKeys) {
            Pattern pattern = Pattern.compile(".*?(\\b" + jiraProjectKey + "-\\d+)");
            Matcher matcher = pattern.matcher(comment);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

