/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStaticVariableDependencyCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String classContent = javaTerm.getContent();
        JavaClass javaClass = (JavaClass)javaTerm;
        List<JavaTerm> childJavaTerms = javaClass.getChildJavaTerms();
        for (int i = 0; i < childJavaTerms.size(); ++i) {
            JavaTerm childJavaTerm = childJavaTerms.get(i);
            if (!childJavaTerm.isJavaVariable() || !childJavaTerm.isStatic()) continue;
            classContent = this._formatStaticVariableDependencies(classContent, javaClass.getName(), childJavaTerm, childJavaTerms, i);
        }
        return classContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _formatStaticVariableDependencies(String classContent, String className, JavaTerm javaTerm, List<JavaTerm> childJavaTerms, int index) {
        Matcher matcher;
        String siblingVariableContent;
        JavaTerm siblingJavaTerm;
        int i;
        String variableName = javaTerm.getName();
        Pattern pattern = Pattern.compile(StringBundler.concat("[^\\w.\\s]\\s*(", variableName, ")\\W"));
        for (i = 0; i < index; ++i) {
            siblingJavaTerm = childJavaTerms.get(i);
            if (!siblingJavaTerm.isJavaVariable() || !siblingJavaTerm.isStatic()) continue;
            siblingVariableContent = siblingJavaTerm.getContent();
            matcher = pattern.matcher(siblingVariableContent);
            while (matcher.find()) {
                String line;
                String s;
                int pos = matcher.start(1);
                if (ToolsUtil.isInsideQuotes(siblingVariableContent, pos) || this.getLevel(s = siblingVariableContent.substring(0, pos), "{", "}") != 0 || (line = StringUtil.trim(this.getLine(siblingVariableContent, this.getLineNumber(siblingVariableContent, pos)))).startsWith("*")) continue;
                String newVariableContent = StringUtil.replaceFirst(siblingVariableContent, variableName, StringBundler.concat(className, ".", variableName), pos);
                return StringUtil.replaceFirst(classContent, siblingVariableContent, newVariableContent);
            }
        }
        pattern = Pattern.compile(StringBundler.concat("(\\W)(", className, "\\.\\s*)(", variableName, "\\W)"));
        for (i = index + 1; i < childJavaTerms.size(); ++i) {
            siblingJavaTerm = childJavaTerms.get(i);
            if (!siblingJavaTerm.isJavaVariable() || !siblingJavaTerm.isStatic() || !(matcher = pattern.matcher(siblingVariableContent = siblingJavaTerm.getContent())).find()) continue;
            return StringUtil.replaceFirst(classContent, siblingVariableContent, matcher.replaceAll("$1$3"));
        }
        return classContent;
    }
}

