/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class JSONPackageJSONRedundantDependenciesCheck
extends BaseFileCheck {
    private static final String _EXCLUDED_DIR_NAMES_KEY = "excludedDirNames";
    private List<String> _excludedDirNames;
    private List<String> _internalDependenciesNames;

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/package.json")) {
            return content;
        }
        this._getInternalDependenciesNames(absolutePath);
        if (this._internalDependenciesNames.isEmpty()) {
            return content;
        }
        for (String excludedDirName : this._excludedDirNames) {
            if (!absolutePath.contains(excludedDirName)) continue;
            return content;
        }
        JSONObject jsonObject = new JSONObject(content);
        if (jsonObject.isNull("dependencies")) {
            return content;
        }
        JSONObject dependenciesJSONObject = jsonObject.getJSONObject("dependencies");
        Iterator iterator = dependenciesJSONObject.keys();
        while (iterator.hasNext()) {
            String dependencyName = (String)iterator.next();
            if (!this._internalDependenciesNames.contains(dependencyName)) continue;
            content = content.replaceFirst("\"" + dependencyName + "\": \".*\",?", "");
        }
        return content;
    }

    private synchronized List<String> _getInternalDependenciesNames(String absolutePath) throws IOException {
        int level;
        if (this._internalDependenciesNames != null) {
            return this._internalDependenciesNames;
        }
        this._internalDependenciesNames = new ArrayList<String>();
        String content = this.getPortalContent("modules/npmscripts.config.js", absolutePath);
        if (Validator.isNull(content)) {
            return this._internalDependenciesNames;
        }
        int x = content.indexOf("imports: {");
        if (x == -1) {
            return this._internalDependenciesNames;
        }
        int y = x += 9;
        String imports = null;
        do {
            if ((y = content.indexOf("}", y + 1)) != -1) continue;
            return this._internalDependenciesNames;
        } while ((level = this.getLevel(imports = content.substring(x, y), "{", "}")) != 0);
        this._excludedDirNames = this.getAttributeValues(_EXCLUDED_DIR_NAMES_KEY, absolutePath);
        JSONObject jsonObject = new JSONObject(imports);
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String dependencyName = (String)iterator.next();
            this._excludedDirNames.add(StringUtil.replaceFirst(dependencyName, "@liferay/", ""));
            this._internalDependenciesNames.add(dependencyName);
            JSONObject nestedJSONObject = jsonObject.getJSONObject(dependencyName);
            for (String key : nestedJSONObject.keySet()) {
                this._internalDependenciesNames.add(key);
            }
        }
        return this._internalDependenciesNames;
    }
}

