/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeEmptyLinesCheck
extends BaseFileCheck {
    private static final String[] _DB_PROCESS_METHODS = new String[]{"addColumn", "addIndexes", "alterColumnName", "alterColumnType", "alterTableAddColumn", "alterTableDropColumn", "dropColumn", "dropIndexes", "renameColumn"};

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("UpgradeProcess.java")) {
            return content;
        }
        for (String methodName : _DB_PROCESS_METHODS) {
            Pattern pattern1 = Pattern.compile("(?<=\n)(\t+\\b" + methodName + "\\(.+?\\);\n+)+", 32);
            Matcher matcher1 = pattern1.matcher(content);
            while (matcher1.find()) {
                String methodCalls = matcher1.group();
                Pattern pattern2 = Pattern.compile("\\b" + methodName + "\\(");
                Matcher matcher2 = pattern2.matcher(methodCalls);
                int methodCallEndPosition = -1;
                int previousMethodCallEndLineNumber = -1;
                String previousMethodCallFirstParameter = "";
                int startPos = matcher1.start();
                while (matcher2.find()) {
                    String methodCall = JavaSourceUtil.getMethodCall(methodCalls, matcher2.start());
                    List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
                    String firstParameter = ListUtil.isEmpty(parameterList) ? "" : parameterList.get(0);
                    if (previousMethodCallEndLineNumber == -1) {
                        methodCallEndPosition = matcher2.start() + methodCall.length() + 1;
                        previousMethodCallEndLineNumber = this.getLineNumber(methodCalls, methodCallEndPosition);
                        previousMethodCallFirstParameter = firstParameter;
                        continue;
                    }
                    int lineNumber = this.getLineNumber(methodCalls, matcher2.start());
                    if (StringUtil.equals(previousMethodCallFirstParameter, firstParameter) && previousMethodCallEndLineNumber + 1 != lineNumber) {
                        return StringUtil.replaceFirst(content, "\n", "", startPos + methodCallEndPosition);
                    }
                    if (!StringUtil.equals(previousMethodCallFirstParameter, firstParameter) && previousMethodCallEndLineNumber + 2 != lineNumber) {
                        return StringUtil.insert(content, "\n", startPos + methodCallEndPosition);
                    }
                    methodCallEndPosition = matcher2.start() + methodCall.length() + 1;
                    previousMethodCallEndLineNumber = this.getLineNumber(methodCalls, methodCallEndPosition);
                    previousMethodCallFirstParameter = firstParameter;
                }
            }
        }
        return content;
    }
}

