/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.source.formatter.check.BaseTagAttributesCheck;
import com.liferay.source.formatter.util.PortalJSONObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPUpgradeRemovedTagsCheck
extends BaseTagAttributesCheck {
    private static final Pattern _multilineTagPattern = Pattern.compile("(([ \t]*)<[-\\w:]+\n.*?([^%])(/?>))(\n|$)", 32);
    private final Map<String, JSONObject> _taglibsJSONObjectMap = new HashMap<String, JSONObject>();

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        String upgradeFromVersion = this.getAttributeValue("upgrade.from.version", absolutePath);
        String upgradeToVersion = this.getAttributeValue("upgrade.to.version", absolutePath);
        if (upgradeFromVersion == null || upgradeToVersion == null) {
            return content;
        }
        JSONObject upgradeFromTaglibsJSONObject = this._getTaglibsJSONObject(upgradeFromVersion);
        JSONObject upgradeToTaglibsJSONObject = this._getTaglibsJSONObject(upgradeToVersion);
        this._checkMultiLineTagAttributes(fileName, content, upgradeFromTaglibsJSONObject, upgradeToTaglibsJSONObject, upgradeToVersion);
        this._checkSingleLineTagAttributes(fileName, content, upgradeFromTaglibsJSONObject, upgradeToTaglibsJSONObject, upgradeToVersion);
        return content;
    }

    private void _checkMultiLineTagAttributes(String fileName, String content, JSONObject upgradeFromTaglibsJSONObject, JSONObject upgradeToTaglibsJSONObject, String upgradeToVersion) throws Exception {
        Matcher matcher = _multilineTagPattern.matcher(content);
        while (matcher.find()) {
            char c;
            if (matcher.start() != 0 && (c = content.charAt(matcher.start() - 1)) != '\n') continue;
            this._checkTag(fileName, this.parseTag(matcher.group(1), false), upgradeFromTaglibsJSONObject, upgradeToTaglibsJSONObject, upgradeToVersion, this.getLineNumber(content, matcher.start()));
        }
    }

    private void _checkSingleLineTagAttributes(String fileName, String content, JSONObject upgradeFromTaglibsJSONObject, JSONObject upgradeToTaglibsJSONObject, String upgradeToVersion) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                for (String jspTag : this.getJSPTags(line)) {
                    this._checkTag(fileName, this.parseTag(jspTag, false), upgradeFromTaglibsJSONObject, upgradeToTaglibsJSONObject, upgradeToVersion, lineNumber);
                }
            }
        }
    }

    private void _checkTag(String fileName, BaseTagAttributesCheck.Tag tag, JSONObject upgradeFromTaglibsJSONObject, JSONObject upgradeToTaglibsJSONObject, String upgradeToVersion, int lineNumber) {
        if (tag == null) {
            return;
        }
        String taglibName = tag.getTaglibName();
        if (taglibName == null) {
            return;
        }
        Tuple upgradeFromTagStatusTuple = this._getTagStatusTuple(upgradeFromTaglibsJSONObject, tag);
        TagStatus upgradeFromTagStatus = (TagStatus)((Object)upgradeFromTagStatusTuple.getObject(0));
        Tuple upgradeToTagStatusTuple = this._getTagStatusTuple(upgradeToTaglibsJSONObject, tag);
        TagStatus upgradeToTagStatus = (TagStatus)((Object)upgradeToTagStatusTuple.getObject(0));
        if (!upgradeFromTagStatus.equals((Object)TagStatus.NO_TAGLIB_FOUND) && upgradeToTagStatus.equals((Object)TagStatus.NO_TAGLIB_FOUND)) {
            this.addMessage(fileName, StringBundler.concat("Taglib '", taglibName, "' no longer exists in version '", upgradeToVersion, "'"), lineNumber);
        }
        if (upgradeFromTagStatus.equals((Object)TagStatus.ATTRIBUTES_FOUND) && upgradeToTagStatus.equals((Object)TagStatus.NO_TAG_FOUND)) {
            this.addMessage(fileName, StringBundler.concat("Tag '", tag.getFullName(), "' no longer exists in version '", upgradeToVersion, "'"), lineNumber);
        }
        if (upgradeFromTagStatus.equals((Object)TagStatus.ATTRIBUTES_FOUND) && upgradeToTagStatus.equals((Object)TagStatus.ATTRIBUTES_FOUND)) {
            List upgradeFromTagAttributes = (List)upgradeFromTagStatusTuple.getObject(1);
            List upgradeToTagAttributes = (List)upgradeToTagStatusTuple.getObject(1);
            for (String upgradeFromTagAttribute : upgradeFromTagAttributes) {
                if (upgradeToTagAttributes.contains(upgradeFromTagAttribute)) continue;
                this.addMessage(fileName, StringBundler.concat("Attribute '", upgradeFromTagAttribute, "' no longer exists for tag '", tag.getFullName(), "' in version '", upgradeToVersion, "'"), lineNumber);
            }
        }
    }

    private List<String> _getAttributeNames(JSONObject tagJSONObject) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        JSONArray tagAttributeNamesJSONArray = tagJSONObject.getJSONArray("attributes");
        if (tagAttributeNamesJSONArray == null) {
            return attributeNames;
        }
        for (JSONObject attributeJSONObject : tagAttributeNamesJSONArray) {
            attributeNames.add(attributeJSONObject.getString("name"));
        }
        return attributeNames;
    }

    private synchronized JSONObject _getTaglibsJSONObject(String version) throws Exception {
        JSONObject taglibsJSONObject = this._taglibsJSONObjectMap.get(version);
        if (taglibsJSONObject != null) {
            return taglibsJSONObject;
        }
        JSONObject portalJSONObject = PortalJSONObjectUtil.getPortalJSONObjectByVersion(version);
        taglibsJSONObject = portalJSONObject.has("taglibs") ? portalJSONObject.getJSONObject("taglibs") : new JSONObjectImpl();
        this._taglibsJSONObjectMap.put(version, taglibsJSONObject);
        return taglibsJSONObject;
    }

    private Tuple _getTagStatusTuple(JSONObject taglibsJSONObject, BaseTagAttributesCheck.Tag tag) {
        JSONObject taglibJSONObject = taglibsJSONObject.getJSONObject(tag.getTaglibName());
        if (taglibJSONObject == null) {
            return new Tuple(new Object[]{TagStatus.NO_TAGLIB_FOUND});
        }
        String tagName = tag.getName();
        JSONObject tagJSONObject = taglibJSONObject.getJSONObject(tagName);
        if (tagJSONObject == null) {
            return new Tuple(new Object[]{TagStatus.NO_TAG_FOUND});
        }
        ArrayList<String> matchingAttributeNames = new ArrayList<String>();
        Map<String, String> attributesMap = tag.getAttributesMap();
        List<String> attributeNames = this._getAttributeNames(tagJSONObject);
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String attributeName = entry.getKey();
            if (!attributeNames.contains(attributeName)) continue;
            matchingAttributeNames.add(attributeName);
        }
        return new Tuple(new Object[]{TagStatus.ATTRIBUTES_FOUND, matchingAttributeNames});
    }

    private static enum TagStatus {
        ATTRIBUTES_FOUND,
        NO_TAG_FOUND,
        NO_TAGLIB_FOUND;

    }
}

