/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesSQLStylingCheck
extends BaseFileCheck {
    private static final Pattern _sqlPattern1 = Pattern.compile("(?<=\\A|\n) +test\\.batch\\.run\\.property(\\.global)?\\.query.+]=([\\s\\S]*?[^\\\\])(?=(\\Z|\n))");
    private static final Pattern _sqlPattern2 = Pattern.compile("\\s(\\(.* ([!=]=|~) .+\\))( (AND|OR) )?(\\\\)?");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        Matcher matcher = _sqlPattern1.matcher(content);
        block0: while (matcher.find()) {
            String originalSqlClauses = matcher.group(2);
            String sqlClauses = originalSqlClauses.replaceAll("\\\\\n *", "");
            int x = (sqlClauses = this._removeRedundantParenthesis(sqlClauses)).indexOf("(");
            if (x == -1) continue;
            int y = x;
            String s = "";
            while ((y = sqlClauses.indexOf(")", y + 1)) != -1) {
                s = sqlClauses.substring(x, y + 1);
                int level = this.getLevel(s, "(", ")");
                if (level != 0) continue;
                if (s.indexOf(" AND ") != -1 || s.indexOf(" OR ") != -1) {
                    sqlClauses = StringUtil.insert(sqlClauses, "\\\n", y);
                    sqlClauses = StringUtil.insert(sqlClauses, "\\\n", x + 1);
                }
                ++x;
                if ((x = sqlClauses.indexOf("(", x)) != -1) {
                    y = x;
                    continue;
                }
                sqlClauses = StringUtil.replace(sqlClauses, " AND ", " AND \\\n");
                sqlClauses = StringUtil.replace(sqlClauses, " OR ", " OR \\\n");
                sqlClauses = this._addParenthesis(sqlClauses);
                sqlClauses = this._checkIndentation(sqlClauses);
                sqlClauses = this._sort(sqlClauses);
                sqlClauses = "\\\n" + sqlClauses;
                if (originalSqlClauses.endsWith("\\\n")) {
                    sqlClauses = sqlClauses + "\n";
                }
                if (sqlClauses.equals(originalSqlClauses)) continue block0;
                return StringUtil.replaceFirst(content, originalSqlClauses, sqlClauses, matcher.start(2));
            }
        }
        return content;
    }

    private String _addParenthesis(String sqlClauses) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(sqlClauses));){
            String line = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if ((line = StringUtil.trimLeading(line)).startsWith("(") || line.startsWith(")")) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                int x = line.indexOf(" AND \\");
                if (x == -1) {
                    x = line.indexOf(" OR \\");
                }
                if (x == -1) {
                    x = line.lastIndexOf("\\");
                }
                if (x == -1) {
                    sb.append("(");
                    sb.append(line);
                    sb.append(")");
                    sb.append("\n");
                    continue;
                }
                sb.append("(");
                sb.append(line.substring(0, x));
                sb.append(")");
                sb.append(line.substring(x));
                sb.append("\n");
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private String _checkIndentation(String sqlClauses) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(sqlClauses));){
            int level = 2;
            String line = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("((") && line.endsWith("))")) {
                    line = line.substring(1, line.length() - 1);
                }
                sb.append(this._fixIndentation(line, level));
                sb.append("\n");
                level += this.getLevel(line, "(", ")");
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private int _compareTo(String sqlClause, String nextSQLClause) {
        if (sqlClause.endsWith("\")") && nextSQLClause.endsWith("\")")) {
            sqlClause = sqlClause.substring(0, sqlClause.length() - 2);
            nextSQLClause = nextSQLClause.substring(0, nextSQLClause.length() - 2);
        }
        return sqlClause.compareTo(nextSQLClause);
    }

    private String _fixIndentation(String line, int level) {
        String trimmedLine = StringUtil.trim(line);
        if (Validator.isNull(trimmedLine)) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (int i = 0; !(i >= level || i == level - 1 && trimmedLine.startsWith(")")); ++i) {
            sb.append("    ");
        }
        sb.append(trimmedLine);
        return sb.toString();
    }

    private String _getSQLClause(String line) {
        Matcher matcher = _sqlPattern2.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String _removeRedundantParenthesis(String sqlClause) {
        int x = sqlClause.indexOf("(((");
        if (x == -1) {
            return sqlClause;
        }
        int y = x;
        String s = "";
        while (true) {
            if ((y = sqlClause.indexOf(")))", y + 1)) == -1) {
                return sqlClause;
            }
            s = sqlClause.substring(x, y + 3);
            int level = this.getLevel(s, "(((", ")))");
            if (level != 0) continue;
            s = s.substring(1, s.length() - 1);
            sqlClause = sqlClause.substring(0, x) + s + sqlClause.substring(y + 3);
            ++x;
            if ((x = sqlClause.indexOf("(((", x)) == -1) break;
            y = x;
        }
        return sqlClause;
    }

    private String _sort(String sqlClauses) {
        Matcher matcher = _sqlPattern2.matcher(sqlClauses);
        while (matcher.find()) {
            String sqlClause;
            String nextSQLClause;
            int lineNumber = this.getLineNumber(sqlClauses, matcher.start());
            if (Validator.isNull(matcher.group(4)) || (nextSQLClause = this._getSQLClause(SourceUtil.getLine(sqlClauses, lineNumber + 1))) == null || this._compareTo(sqlClause = matcher.group(1), nextSQLClause) <= 0) continue;
            sqlClauses = StringUtil.replaceFirst(sqlClauses, nextSQLClause, sqlClause, this.getLineStartPos(sqlClauses, lineNumber + 1));
            return StringUtil.replaceFirst(sqlClauses, sqlClause, nextSQLClause, this.getLineStartPos(sqlClauses, lineNumber));
        }
        return sqlClauses;
    }
}

