/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeDropTableCheck
extends BaseJavaTermCheck {
    private static final Pattern _runSqlPattern = Pattern.compile("\\brunSQL\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaClass javaClass = (JavaClass)javaTerm;
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        if (!extendedClassNames.contains("UpgradeProcess")) {
            return javaTerm.getContent();
        }
        String content = javaTerm.getContent();
        Matcher matcher = _runSqlPattern.matcher(content);
        while (matcher.find()) {
            String runSqlMethodCall = this._getMethodCall(content, matcher.start());
            if (!runSqlMethodCall.contains("drop table if exists")) continue;
            return StringUtil.replaceFirst(content, "drop table if exists", "DROP_TABLE_IF_EXISTS", matcher.start());
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _getMethodCall(String s, int start) {
        String methodCall;
        int x = start;
        while (ToolsUtil.isInsideQuotes(s, (x = s.indexOf(")", x + 1)) + 1) || this.getLevel(methodCall = s.substring(start, x + 1)) != 0) {
        }
        return methodCall;
    }
}

