/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;

public class IncorrectFilePahCheck
extends BaseFileCheck {
    private static final String[] _ILLEGAL_CHARACTERS = new String[]{"\\", ":", "/", ">", "<", "|", "?", "\"", "*"};

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String rootDirName = SourceUtil.getRootDirName(absolutePath);
        if (Validator.isNull(rootDirName)) {
            return content;
        }
        String relativePath = absolutePath.substring(rootDirName.length());
        for (String path : relativePath.split("/")) {
            if (Validator.isNull(path)) continue;
            if (path.endsWith(" ") || path.startsWith(" ")) {
                this.addMessage(fileName, StringBundler.concat("Do not add leading/trailing spaces in file or folder ", "names '", path, "'"));
            }
            for (String illegalCharacter : _ILLEGAL_CHARACTERS) {
                if (!path.contains(illegalCharacter)) continue;
                this.addMessage(fileName, StringBundler.concat("Do not use '", illegalCharacter, "' in file or ", "folder names '", path, "'"));
            }
        }
        return content;
    }
}

