/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMLEchoMessageCheck
extends BaseFileCheck {
    private static final Pattern _echoMessagePattern = Pattern.compile("<echo (.(?!(/>|</)))*?message=.*?/>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".xml")) {
            return content;
        }
        Matcher matcher = _echoMessagePattern.matcher(content);
        ArrayList<String> matchedTags = new ArrayList<String>();
        while (matcher.find()) {
            matchedTags.add(matcher.group());
        }
        if (ListUtil.isEmpty(matchedTags)) {
            return content;
        }
        Document document = SourceUtil.readXML(content);
        List echoNodes = document.selectNodes("//*[name() = 'echo']");
        block1: for (Node echoNode : echoNodes) {
            Element echoElement = (Element)echoNode;
            Attribute messageAttribute = echoElement.attribute("message");
            if (messageAttribute == null) continue;
            for (String matchedTag : matchedTags) {
                Document documentElement = DocumentHelper.parseText((String)matchedTag);
                Element rootElement = documentElement.getRootElement();
                if (!Objects.equals(echoElement.asXML(), rootElement.asXML())) continue;
                echoElement.remove(messageAttribute);
                echoElement.setText(messageAttribute.getText());
                content = StringUtil.replace(content, matchedTag, echoElement.asXML());
                continue block1;
            }
        }
        return content;
    }
}

