/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;

public class ListUtil {
    private static final long[] _EMPTY_LONG_ARRAY = new long[0];
    private static final Class<? extends List<?>> _UNMODIFIABLE_LIST_CLASS;

    public static <E> List<E> concat(List<? extends E> ... lists) {
        ArrayList<? extends E> newList = new ArrayList<E>();
        for (List<? extends E> list : lists) {
            newList.addAll(list);
        }
        return newList;
    }

    public static <E> List<E> copy(List<? extends E> master) {
        if (master == null) {
            return null;
        }
        return new ArrayList<E>(master);
    }

    public static <E> void copy(List<? extends E> master, List<? super E> copy) {
        if (master == null || copy == null) {
            return;
        }
        copy.clear();
        copy.addAll(master);
    }

    public static <E> int count(List<? extends E> list, Predicate<E> predicate) {
        if (ListUtil.isEmpty(list)) {
            return 0;
        }
        int count = 0;
        for (E element : list) {
            if (!predicate.test(element)) continue;
            ++count;
        }
        return count;
    }

    public static <E> void distinct(List<? extends E> list, Comparator<E> comparator) {
        if (ListUtil.isEmpty(list)) {
            return;
        }
        HashSet<E> set = new HashSet<E>();
        Iterator<E> iterator = list.iterator();
        while (iterator.hasNext()) {
            E object = iterator.next();
            if (set.add(object)) continue;
            iterator.remove();
        }
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    public static void distinct(List<?> list) {
        ListUtil.distinct(list, null);
    }

    public static <E> boolean exists(List<? extends E> list, Predicate<E> predicate) {
        if (ListUtil.isEmpty(list)) {
            return false;
        }
        for (E element : list) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> filter(List<? extends T> inputList, List<T> outputList, Predicate<T> predicate) {
        for (T item : inputList) {
            if (!predicate.test(item)) continue;
            outputList.add(item);
        }
        return outputList;
    }

    public static <T> List<T> filter(List<? extends T> inputList, Predicate<T> predicate) {
        return ListUtil.filter(inputList, new ArrayList(inputList.size()), predicate);
    }

    public static List<Boolean> fromArray(boolean[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>(array.length);
        for (boolean value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Character> fromArray(char[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Character>();
        }
        ArrayList<Character> list = new ArrayList<Character>(array.length);
        for (char value : array) {
            list.add(Character.valueOf(value));
        }
        return list;
    }

    public static List<Double> fromArray(double[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> list = new ArrayList<Double>(array.length);
        for (double value : array) {
            list.add(value);
        }
        return list;
    }

    public static <E> List<E> fromArray(E ... array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    public static List<Float> fromArray(float[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> list = new ArrayList<Float>(array.length);
        for (float value : array) {
            list.add(Float.valueOf(value));
        }
        return list;
    }

    public static List<Integer> fromArray(int[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Long> fromArray(long[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        for (long value : array) {
            list.add(value);
        }
        return list;
    }

    public static List<Short> fromArray(short[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Short>();
        }
        ArrayList<Short> list = new ArrayList<Short>(array.length);
        for (short value : array) {
            list.add(value);
        }
        return list;
    }

    public static <E> List<E> fromCollection(Collection<? extends E> c) {
        if (c != null && c instanceof List) {
            return (List)c;
        }
        if (c == null || c.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<E> list = new ArrayList<E>(c.size());
        list.addAll(c);
        return list;
    }

    public static <E> List<E> fromEnumeration(Enumeration<? extends E> enumeration) {
        ArrayList<E> list = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            E object = enumeration.nextElement();
            list.add(object);
        }
        return list;
    }

    public static List<String> fromFile(File file) throws IOException {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new FileReader(file));){
            String s = "";
            while ((s = unsyncBufferedReader.readLine()) != null) {
                list.add(s);
            }
        }
        return list;
    }

    public static List<String> fromFile(String fileName) throws IOException {
        return ListUtil.fromFile(new File(fileName));
    }

    public static <E> List<E> fromMapKeys(Map<? extends E, ?> map) {
        if (MapUtil.isEmpty(map)) {
            return new ArrayList();
        }
        return new ArrayList<E>(map.keySet());
    }

    public static <E> List<E> fromMapValues(Map<?, ? extends E> map) {
        if (MapUtil.isEmpty(map)) {
            return new ArrayList();
        }
        return new ArrayList<E>(map.values());
    }

    public static List<String> fromString(String s) {
        return ListUtil.fromArray(StringUtil.splitLines(s));
    }

    public static List<String> fromString(String s, String delimiter) {
        return ListUtil.fromArray(StringUtil.split(s, delimiter));
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotEmpty(List<?> list) {
        return !ListUtil.isEmpty(list);
    }

    public static <E> void isNotEmptyForEach(List<? extends E> list, Consumer<? super E> consumer) {
        if (!ListUtil.isEmpty(list)) {
            list.forEach(consumer);
        }
    }

    public static boolean isNotNull(List<?> list) {
        return !ListUtil.isNull(list);
    }

    public static boolean isNull(List<?> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (Object bean : list) {
            if (!Validator.isNotNull(bean)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnmodifiableList(List<?> list) {
        return _UNMODIFIABLE_LIST_CLASS.isInstance(list);
    }

    public static <E> List<E> remove(List<E> list, List<? extends E> remove) {
        if (ListUtil.isEmpty(list) || ListUtil.isEmpty(remove)) {
            return list;
        }
        list = ListUtil.copy(list);
        for (E element : remove) {
            list.remove(element);
        }
        return list;
    }

    public static <E> Iterator<E> reverseIterator(List<E> list) {
        final ListIterator<E> listIterator = list.listIterator(list.size());
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return listIterator.hasPrevious();
            }

            @Override
            public E next() {
                return listIterator.previous();
            }

            @Override
            public void remove() {
                listIterator.remove();
            }
        };
    }

    public static <E> List<E> sort(List<E> list) {
        return ListUtil.sort(list, null);
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        if (ListUtil.isUnmodifiableList(list)) {
            list = ListUtil.copy(list);
        }
        Collections.sort(list, comparator);
        return list;
    }

    public static <E> List<E> subList(List<E> list, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end < 0 || end > list.size()) {
            end = list.size();
        }
        if (start < end) {
            return list.subList(start, end);
        }
        return Collections.emptyList();
    }

    public static <T, A> A[] toArray(List<? extends T> list, Accessor<T, A> accessor) {
        if (ListUtil.isEmpty(list)) {
            return (Object[])Array.newInstance(accessor.getAttributeClass(), 0);
        }
        Object[] array = (Object[])Array.newInstance(accessor.getAttributeClass(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            T bean = list.get(i);
            A attribute = accessor.get(bean);
            array[i] = attribute;
        }
        return array;
    }

    @Deprecated
    public static List<Boolean> toList(boolean[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>(array.length);
        for (boolean value : array) {
            list.add(value);
        }
        return list;
    }

    @Deprecated
    public static List<Character> toList(char[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Character>();
        }
        ArrayList<Character> list = new ArrayList<Character>(array.length);
        for (char value : array) {
            list.add(Character.valueOf(value));
        }
        return list;
    }

    @Deprecated
    public static List<Double> toList(double[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> list = new ArrayList<Double>(array.length);
        for (double value : array) {
            list.add(value);
        }
        return list;
    }

    public static <E> List<E> toList(E value) {
        return new ArrayList<Object>(Arrays.asList(value));
    }

    @Deprecated
    public static <E> List<E> toList(E[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    @Deprecated
    public static List<Float> toList(float[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> list = new ArrayList<Float>(array.length);
        for (float value : array) {
            list.add(Float.valueOf(value));
        }
        return list;
    }

    @Deprecated
    public static List<Integer> toList(int[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int value : array) {
            list.add(value);
        }
        return list;
    }

    public static <T, A> List<A> toList(List<T> list, Accessor<T, A> accessor) {
        ArrayList<A> aList = new ArrayList<A>(list.size());
        for (T t : list) {
            aList.add(accessor.get(t));
        }
        return aList;
    }

    public static <T, R> List<R> toList(List<T> list, Function<T, R> function) {
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T t : list) {
            result.add(function.apply(t));
        }
        return result;
    }

    public static <T, V extends T> List<T> toList(List<V> vlist) {
        return new ArrayList<V>(vlist);
    }

    @Deprecated
    public static List<Long> toList(long[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        for (long value : array) {
            list.add(value);
        }
        return list;
    }

    @Deprecated
    public static List<Short> toList(short[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return new ArrayList<Short>();
        }
        ArrayList<Short> list = new ArrayList<Short>(array.length);
        for (short value : array) {
            list.add(value);
        }
        return list;
    }

    public static <T> long[] toLongArray(List<? extends T> list, Accessor<T, Long> accessor) {
        if (ListUtil.isEmpty(list)) {
            return _EMPTY_LONG_ARRAY;
        }
        long[] array = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            T bean = list.get(i);
            Long attribute = accessor.get(bean);
            array[i] = attribute;
        }
        return array;
    }

    public static <T> long[] toLongArray(List<? extends T> list, ToLongFunction<T> toLongFunction) {
        if (ListUtil.isEmpty(list)) {
            return _EMPTY_LONG_ARRAY;
        }
        long[] array = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = toLongFunction.applyAsLong(list.get(i));
        }
        return array;
    }

    public static <T, A> String toString(List<? extends T> list, Accessor<T, A> accessor) {
        return ListUtil.toString(list, accessor, ",");
    }

    public static <T, A> String toString(List<? extends T> list, Accessor<T, A> accessor, String delimiter) {
        if (ListUtil.isEmpty(list)) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * list.size() - 1);
        for (int i = 0; i < list.size(); ++i) {
            T bean = list.get(i);
            A attribute = accessor.get(bean);
            if (attribute != null) {
                sb.append(attribute);
            }
            if (i + 1 == list.size()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String toString(List<?> list, String param) {
        return ListUtil.toString(list, param, ",");
    }

    public static String toString(List<?> list, String param, String delimiter) {
        if (ListUtil.isEmpty(list)) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * list.size() - 1);
        for (int i = 0; i < list.size(); ++i) {
            Object bean = list.get(i);
            Object value = null;
            value = Validator.isNull(param) ? String.valueOf(bean) : BeanPropertiesUtil.getObject(bean, param);
            if (value != null) {
                sb.append(value);
            }
            if (i + 1 == list.size()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static <T> List<T> unique(List<T> list) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(list);
        if (list.size() == set.size()) {
            return list;
        }
        return new ArrayList(set);
    }

    static {
        List unmodifiableList = Collections.unmodifiableList(new LinkedList());
        _UNMODIFIABLE_LIST_CLASS = unmodifiableList.getClass();
    }
}

