/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.source.formatter.checkstyle.check.BaseAPICheck;
import com.liferay.source.formatter.checkstyle.check.DeprecatedAPICheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpgradeDeprecatedAPICheck
extends DeprecatedAPICheck {
    private static final String _MSG_DEPRECATED_CONSTRUCTOR_CALL = "constructor.call.deprecated";
    private static final String _MSG_DEPRECATED_FIELD_CALL = "field.call.deprecated";
    private static final String _MSG_DEPRECATED_METHOD_CALL = "method.call.deprecated";
    private static final String _MSG_DEPRECATED_TYPE_CALL = "type.call.deprecated";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String upgradeFromVersion = this.getAttributeValue("upgrade.from.version");
        String upgradeToVersion = this.getAttributeValue("upgrade.to.version");
        try {
            JSONObject upgradeFromJavaClassesJSONObject = this.getJavaClassesJSONObject(upgradeFromVersion);
            JSONObject upgradeToJavaClassesJSONObject = this.getJavaClassesJSONObject(upgradeToVersion);
            List<String> upgradeFromDeprecatedImportNames = this.getDeprecatedImportNames(detailAST, upgradeFromJavaClassesJSONObject);
            List<String> upgradeToDeprecatedImportNames = this.getDeprecatedImportNames(detailAST, upgradeToJavaClassesJSONObject);
            for (String upgradeToDeprecatedImportName : upgradeToDeprecatedImportNames) {
                if (upgradeFromDeprecatedImportNames.contains(upgradeToDeprecatedImportName) || !this.hasUndeprecatedReference(detailAST, upgradeToDeprecatedImportName)) continue;
                this.log(this.getImportLineNumber(detailAST, upgradeToDeprecatedImportName), _MSG_DEPRECATED_TYPE_CALL, new Object[]{upgradeToDeprecatedImportName, upgradeToVersion});
            }
            this._checkDeprecatedConstructors(detailAST, upgradeFromDeprecatedImportNames, upgradeFromJavaClassesJSONObject, upgradeToDeprecatedImportNames, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkDeprecatedMethods(detailAST, upgradeFromDeprecatedImportNames, upgradeFromJavaClassesJSONObject, upgradeToDeprecatedImportNames, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkDeprecatedTypes(detailAST, upgradeFromDeprecatedImportNames, upgradeFromJavaClassesJSONObject, upgradeToDeprecatedImportNames, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkDeprecatedVariables(detailAST, upgradeFromDeprecatedImportNames, upgradeFromJavaClassesJSONObject, upgradeToDeprecatedImportNames, upgradeToJavaClassesJSONObject, upgradeToVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _checkDeprecatedConstructors(DetailAST detailAST, List<String> upgradeFromDeprecatedImportNames, JSONObject upgradeFromJavaClassesJSONObject, List<String> upgradeToDeprecatedImportNames, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<BaseAPICheck.ConstructorCall> upgradeFromDeprecatedConstructorCalls = this.getDeprecatedConstructorCalls(detailAST, upgradeFromDeprecatedImportNames, upgradeFromJavaClassesJSONObject);
        List<BaseAPICheck.ConstructorCall> upgradeToDeprecatedConstructorCalls = this.getDeprecatedConstructorCalls(detailAST, upgradeToDeprecatedImportNames, upgradeToJavaClassesJSONObject);
        for (BaseAPICheck.ConstructorCall upgradeToDeprecatedConstructorCall : upgradeToDeprecatedConstructorCalls) {
            if (upgradeFromDeprecatedConstructorCalls.contains(upgradeToDeprecatedConstructorCall)) continue;
            this.log(upgradeToDeprecatedConstructorCall.getLineNumber(), _MSG_DEPRECATED_CONSTRUCTOR_CALL, new Object[]{upgradeToDeprecatedConstructorCall.getTypeName(), upgradeToVersion});
        }
    }

    private void _checkDeprecatedMethods(DetailAST detailAST, List<String> upgradeFromDeprecatedImportNames, JSONObject upgradeFromJavaClassesJSONObject, List<String> upgradeToDeprecatedImportNames, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<BaseAPICheck.MethodCall> upgradeFromDeprecatedMethodCalls = this.getDeprecatedMethodCalls(detailAST, upgradeFromDeprecatedImportNames, upgradeFromJavaClassesJSONObject);
        List<BaseAPICheck.MethodCall> upgradeToDeprecatedMethodCalls = this.getDeprecatedMethodCalls(detailAST, upgradeToDeprecatedImportNames, upgradeToJavaClassesJSONObject);
        for (BaseAPICheck.MethodCall upgradeToDeprecatedMethodCall : upgradeToDeprecatedMethodCalls) {
            if (upgradeFromDeprecatedMethodCalls.contains(upgradeToDeprecatedMethodCall)) continue;
            this.log(upgradeToDeprecatedMethodCall.getLineNumber(), _MSG_DEPRECATED_METHOD_CALL, new Object[]{upgradeToDeprecatedMethodCall.getName(), upgradeToVersion});
        }
    }

    private void _checkDeprecatedTypes(DetailAST detailAST, List<String> upgradeFromDeprecatedImportNames, JSONObject upgradeFromJavaClassesJSONObject, List<String> upgradeToDeprecatedImportNames, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        Map<String, Set<Integer>> upgradeFromDeprecatedTypeNamesMap = this.getDeprecatedTypeNamesMap(detailAST, upgradeFromDeprecatedImportNames, upgradeFromJavaClassesJSONObject);
        Map<String, Set<Integer>> upgradeToDeprecatedTypeNamesMap = this.getDeprecatedTypeNamesMap(detailAST, upgradeToDeprecatedImportNames, upgradeToJavaClassesJSONObject);
        for (Map.Entry<String, Set<Integer>> entry : upgradeToDeprecatedTypeNamesMap.entrySet()) {
            String upgradeToTypeName = entry.getKey();
            if (!upgradeFromDeprecatedTypeNamesMap.containsKey(upgradeToTypeName)) continue;
            Set<Integer> upgradeToLineNumbers = entry.getValue();
            for (int upgradeToLineNumber : upgradeToLineNumbers) {
                this.log(upgradeToLineNumber, _MSG_DEPRECATED_TYPE_CALL, new Object[]{upgradeToTypeName, upgradeToVersion});
            }
        }
    }

    private void _checkDeprecatedVariables(DetailAST detailAST, List<String> upgradeFromDeprecatedImportNames, JSONObject upgradeFromJavaClassesJSONObject, List<String> upgradeToDeprecatedImportNames, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<BaseAPICheck.VariableCall> upgradeFromDeprecatedVariableCalls = this.getDeprecatedVariableCalls(detailAST, upgradeFromDeprecatedImportNames, upgradeFromJavaClassesJSONObject);
        List<BaseAPICheck.VariableCall> upgradeToDeprecatedVariableCalls = this.getDeprecatedVariableCalls(detailAST, upgradeToDeprecatedImportNames, upgradeToJavaClassesJSONObject);
        for (BaseAPICheck.VariableCall upgradeToDeprecatedVariableCall : upgradeToDeprecatedVariableCalls) {
            if (upgradeFromDeprecatedVariableCalls.contains(upgradeToDeprecatedVariableCall)) continue;
            this.log(upgradeToDeprecatedVariableCall.getLineNumber(), _MSG_DEPRECATED_FIELD_CALL, new Object[]{upgradeToDeprecatedVariableCall.getName(), upgradeToVersion});
        }
    }
}

