/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MVCCommandNameCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_VALUE = "value.incorrect";
    private static final Pattern _classNamePattern = Pattern.compile("[A-Z]([A-Z]+)s([A-Z]|\\Z)");
    private static final Pattern _componentNamePattern = Pattern.compile("^\"\\(component\\.name=com\\.liferay\\.(.*)\\.web\\.internal\\..*\\.(\\w+MVC\\w+Command)\\)\"$");

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getParent() != null || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String className = this.getName(detailAST);
        if (!(className.endsWith("MVCActionCommand") || className.endsWith("MVCRenderCommand") || className.endsWith("MVCResourceCommand"))) {
            return;
        }
        String absolutePath = this.getAbsolutePath();
        int pos = absolutePath.lastIndexOf("-web/");
        if (pos == -1) {
            return;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null) {
            return;
        }
        DetailAST propertyAnnotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "property");
        if (propertyAnnotationMemberValuePairDetailAST == null) {
            return;
        }
        DetailAST annotationArrayInitDetailAST = propertyAnnotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST == null) {
            return;
        }
        Map<String, Integer> mvcCommandNamesMap = this._getMVCCommandNamesMap(annotationArrayInitDetailAST);
        if (mvcCommandNamesMap.isEmpty()) {
            return;
        }
        String modulePath = absolutePath.substring(0, pos);
        boolean validateActionName = false;
        if (mvcCommandNamesMap.size() == 1) {
            validateActionName = true;
        }
        for (Map.Entry<String, Integer> entry : mvcCommandNamesMap.entrySet()) {
            String mvcCommandName = entry.getKey();
            if (this._hasValidMVCCommandName(mvcCommandName, detailAST, annotationArrayInitDetailAST, className, modulePath, validateActionName)) continue;
            this.log(entry.getValue(), _MSG_INCORRECT_VALUE, new Object[]{mvcCommandName});
        }
    }

    private String _getExpectedActionName(String className) {
        String name = StringUtil.removeSubstrings(className, "MVCActionCommand", "MVCRenderCommand", "MVCResourceCommand");
        name = StringUtil.replace(name, new String[]{"OAuth2", "WeDeploy"}, new String[]{"Oauth2", "Wedeploy"});
        Matcher matcher = _classNamePattern.matcher(className);
        while (matcher.find()) {
            String match = matcher.group(1);
            name = StringUtil.replaceFirst(name, match, StringUtil.lowerCase(match), matcher.start(1));
        }
        name = StringUtil.replace(TextFormatter.format(name, 10), '-', '_');
        return StringUtil.replace(name, "mfafido2", "mfa_fido2");
    }

    private Map<String, Integer> _getMVCCommandNamesMap(DetailAST annotationArrayInitDetailAST) {
        HashMap<String, Integer> mvcCommandNamesMap = new HashMap<String, Integer>();
        List<DetailAST> expressionDetailASTList = this.getAllChildTokens(annotationArrayInitDetailAST, false, 28);
        for (DetailAST expressionDetailAST : expressionDetailASTList) {
            String value;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139 || !(value = firstChildDetailAST.getText()).startsWith("\"mvc.command.name=") || value.equals("\"mvc.command.name=/\"")) continue;
            mvcCommandNamesMap.put(value.substring(18, value.length() - 1), expressionDetailAST.getLineNo());
        }
        return mvcCommandNamesMap;
    }

    private String _getTrimmedPath(String[] pathArray, int abbreviatePathCount) {
        StringBundler sb = new StringBundler(pathArray.length);
        for (int i = 0; i < pathArray.length; ++i) {
            String s = pathArray[i];
            if (i < abbreviatePathCount) {
                sb.append(s.charAt(0));
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private boolean _hasValidActionName(String actionName, String path, String className) {
        if (actionName.equals(this._getExpectedActionName(className))) {
            return true;
        }
        String[] pathArray = StringUtil.split(path, '_');
        for (int i = 0; i < pathArray.length; ++i) {
            String expectedActionName;
            String trimmedPath = this._getTrimmedPath(pathArray, i);
            if (!StringUtil.startsWith(className, trimmedPath) || !actionName.equals(expectedActionName = this._getExpectedActionName(className.substring(trimmedPath.length())))) continue;
            return true;
        }
        return false;
    }

    private boolean _hasValidMVCCommandName(String mvcCommandName, DetailAST classDefinitionDetailAST, DetailAST annotationArrayInitDetailAST, String className, String modulePath, boolean validateActionName) {
        if (!mvcCommandName.startsWith("/") && !mvcCommandName.startsWith("~")) {
            return false;
        }
        char delimiter = mvcCommandName.charAt(0);
        String[] parts = StringUtil.split(mvcCommandName.substring(1), delimiter);
        if (parts.length != 2) {
            return false;
        }
        String actionName = parts[1];
        String path = parts[0];
        if ((!validateActionName || this._hasValidActionName(actionName, path, className)) && this._hasValidPath(path, annotationArrayInitDetailAST, delimiter, modulePath)) {
            return true;
        }
        List<DetailAST> annotationDetailASTList = this.getAllChildTokens(classDefinitionDetailAST, true, 159);
        for (DetailAST annotationDetailAST : annotationDetailASTList) {
            FullIdent fullIdent;
            Matcher matcher;
            DetailAST targetAnnotationMemberValuePairDetailAST;
            if (!Objects.equals(this.getName(annotationDetailAST), "Reference") || (targetAnnotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "target")) == null || !(matcher = _componentNamePattern.matcher((fullIdent = FullIdent.createFullIdentBelow((DetailAST)targetAnnotationMemberValuePairDetailAST.getLastChild())).getText())).find()) continue;
            String expectedPath = StringUtil.replace(matcher.group(1), '.', '_');
            String expectedActionName = this._getExpectedActionName(matcher.group(2));
            if (!path.equals(expectedPath) || !actionName.equals(expectedActionName)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasValidPath(String path, DetailAST annotationArrayInitDetailAST, char delimiter, String modulePath) {
        String moduleName = modulePath.substring(modulePath.lastIndexOf(delimiter) + 1);
        if (path.equals(StringUtil.replace(moduleName, '-', '_'))) {
            return true;
        }
        List<DetailAST> stringLiteralDetailASTList = this.getAllChildTokens(annotationArrayInitDetailAST, true, 139);
        for (DetailAST stringLiteralDetailAST : stringLiteralDetailASTList) {
            if (!Objects.equals(stringLiteralDetailAST.getText(), "\"javax.portlet.name=\"")) continue;
            for (String name : this.getNames(stringLiteralDetailAST.getParent(), true)) {
                if (!StringUtil.equalsIgnoreCase(path, name)) continue;
                return true;
            }
        }
        File file = new File(modulePath + "-web/src/main/resources/META-INF/resources/" + path);
        return file.exists();
    }
}

