/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependenciesCheck
extends BaseFileCheck {
    private static final String _ALLOWED_COMMERCE_DEPENDENCIES_MODULE_PATH_NAMES = "allowedCommerceDependenciesModulePathNames";
    private static final String _CHECK_PETRA_DEPENDENCIES_KEY = "checkPetraDependencies";
    private static final String _CHECK_REST_CLIENT_DEPENDENCIES_KEY = "checkRestClientDependencies";
    private static final String _CHECK_TEST_INTEGRATION_COMPILE_DEPENDENCIES_KEY = "checkTestIntegrationCompileDependencies";
    private static final String _RELEASE_PORTAL_API_VERSION_KEY = "releasePortalAPIVersion";
    private static final Pattern _dependencyAttributesPattern = Pattern.compile("(\\w+): \"([\\w.-]+)\"");
    private static final Pattern _dependencyPattern = Pattern.compile("^(\\w+) (\\w+: \"[\\w.-]+\"(, )?)+$");
    private static final Pattern _incorrectGroupNameVersionPattern = Pattern.compile("(^[^\\s]+)\\s+\"([^:]+?):([^:]+?):([^\"]+?)\"(.*?)", 32);
    private static final Pattern _incorrectWhitespacePattern = Pattern.compile("(:|\",)[^ \n]");
    private static final Pattern _petraPattern = Pattern.compile("testIntegrationCompile project\\(\":core:petra:.*");
    private static final Pattern _portalKernelPattern = Pattern.compile("testIntegrationCompile.* name: \"com\\.liferay\\.portal\\.kernel\".*");
    private static final Pattern _restClientPattern = Pattern.compile("(?<!testIntegrationCompile) project\\(\".*-rest-client\"\\)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<String> dependenciesBlocks = GradleSourceUtil.getDependenciesBlocks(content);
        if (dependenciesBlocks.isEmpty()) {
            return content;
        }
        String releasePortalAPIVersion = this.getAttributeValue(_RELEASE_PORTAL_API_VERSION_KEY, absolutePath);
        for (String dependenciesBlock : dependenciesBlocks) {
            int y;
            int x = dependenciesBlock.indexOf("\n");
            if (x == (y = dependenciesBlock.lastIndexOf("\n"))) continue;
            String dependencies = dependenciesBlock.substring(x, y + 1);
            if (this.isAttributeValue(_CHECK_TEST_INTEGRATION_COMPILE_DEPENDENCIES_KEY, absolutePath)) {
                content = this._formatTestIntegrationCompileDependencies(content, dependencies, _petraPattern);
                content = this._formatTestIntegrationCompileDependencies(content, dependencies, _portalKernelPattern);
            }
            content = this._formatDependencies(content, SourceUtil.getIndent(dependenciesBlock), dependencies, releasePortalAPIVersion);
            if (this.isAttributeValue(_CHECK_PETRA_DEPENDENCIES_KEY, absolutePath) && absolutePath.contains("/modules/core/petra/")) {
                this._checkPetraDependencies(fileName, content, dependencies);
            }
            this._checkCommerceDependencies(fileName, absolutePath, content, dependencies, this.getAttributeValues(_ALLOWED_COMMERCE_DEPENDENCIES_MODULE_PATH_NAMES, absolutePath));
            if (!this.isAttributeValue(_CHECK_REST_CLIENT_DEPENDENCIES_KEY, absolutePath)) continue;
            this._checkRestClientDependencies(fileName, content, dependencies);
        }
        return content;
    }

    private void _checkCommerceDependencies(String fileName, String absolutePath, String content, String dependencies, List<String> allowedCommerceDependenciesModulePathNames) {
        if (!this.isModulesFile(absolutePath) || absolutePath.contains("/commerce/")) {
            return;
        }
        for (String line : StringUtil.splitLines(dependencies)) {
            if (Validator.isNull(line) || !line.matches("\\s*compileOnly project\\(\".*?:apps:commerce.+?\"\\)")) continue;
            for (String allowedCommerceDependenciesModulePathName : allowedCommerceDependenciesModulePathNames) {
                if (!absolutePath.contains(allowedCommerceDependenciesModulePathName)) continue;
                return;
            }
            this.addMessage(fileName, "Modules that are outside of Commerce are not allowed to depend on Commerce modules", SourceUtil.getLineNumber(content, content.indexOf(line)));
        }
    }

    private void _checkPetraDependencies(String fileName, String content, String dependencies) {
        for (String line : StringUtil.splitLines(dependencies)) {
            if (!Validator.isNotNull(line) || line.contains("petra")) continue;
            this.addMessage(fileName, "Only modules/core/petra dependencies are allowed", SourceUtil.getLineNumber(content, content.indexOf(line)));
        }
    }

    private void _checkRestClientDependencies(String fileName, String content, String dependencies) {
        Matcher matcher = _restClientPattern.matcher(dependencies);
        while (matcher.find()) {
            this.addMessage(fileName, "Project dependencies '.*-rest-client' can only be used for 'testIntegrationCompile'", SourceUtil.getLineNumber(content, content.indexOf(matcher.group())));
        }
    }

    private String _formatDependencies(String content, String indent, String dependencies, String releasePortalAPIVersion) {
        Matcher matcher = _incorrectWhitespacePattern.matcher(dependencies);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(dependencies, matcher.start())) continue;
            String newDependencies = StringUtil.insert(dependencies, " ", matcher.end() - 1);
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        if (dependencies.contains("'")) {
            String newDependencies = StringUtil.replace(dependencies, '\'', '\"');
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        TreeSet<String> uniqueDependencies = new TreeSet<String>(new GradleDependencyComparator());
        for (String dependency : StringUtil.splitLines(dependencies)) {
            if (Validator.isNull(dependency = dependency.trim())) continue;
            if (dependency.startsWith("compileOnly ") && Validator.isNotNull(releasePortalAPIVersion)) {
                uniqueDependencies.add(StringBundler.concat("compileOnly group: \"com.liferay.portal\", name: ", "\"release.portal.api\", version: \"", releasePortalAPIVersion, "\""));
                continue;
            }
            matcher = _incorrectGroupNameVersionPattern.matcher(dependency);
            if (matcher.find()) {
                StringBundler sb = new StringBundler(9);
                sb.append(matcher.group(1));
                sb.append(" group: \"");
                sb.append(matcher.group(2));
                sb.append("\", name: \"");
                sb.append(matcher.group(3));
                sb.append("\", version: \"");
                sb.append(matcher.group(4));
                sb.append("\"");
                sb.append(matcher.group(5));
                dependency = sb.toString();
            }
            uniqueDependencies.add(this._sortDependencyAttributes(dependency));
        }
        StringBundler sb = new StringBundler();
        String previousConfiguration = null;
        for (String dependency : uniqueDependencies) {
            String configuration = GradleSourceUtil.getConfiguration(dependency);
            if (previousConfiguration == null || !previousConfiguration.equals(configuration)) {
                previousConfiguration = configuration;
                sb.append("\n");
            }
            sb.append(indent);
            sb.append("\t");
            sb.append(dependency);
            sb.append("\n");
        }
        return StringUtil.replace(content, dependencies, sb.toString());
    }

    private String _formatTestIntegrationCompileDependencies(String content, String dependencies, Pattern pattern) {
        Matcher matcher = pattern.matcher(dependencies);
        if (matcher.find()) {
            return StringUtil.replace(content, dependencies, StringUtil.removeSubstring(dependencies, matcher.group()));
        }
        return content;
    }

    private String _sortDependencyAttributes(String dependency) {
        Matcher matcher = _dependencyPattern.matcher(dependency);
        if (!matcher.find()) {
            return dependency;
        }
        StringBundler sb = new StringBundler();
        sb.append(matcher.group(1));
        sb.append(" ");
        TreeMap<String, String> attributesMap = new TreeMap<String, String>();
        matcher = _dependencyAttributesPattern.matcher(dependency);
        while (matcher.find()) {
            attributesMap.put(matcher.group(1), matcher.group(2));
        }
        for (Map.Entry entry : attributesMap.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append(": \"");
            sb.append((String)entry.getValue());
            sb.append("\"");
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private class GradleDependencyComparator
    implements Comparator<String>,
    Serializable {
        private GradleDependencyComparator() {
        }

        @Override
        public int compare(String dependency1, String dependency2) {
            String configuration2;
            String configuration1 = GradleSourceUtil.getConfiguration(dependency1);
            if (!configuration1.equals(configuration2 = GradleSourceUtil.getConfiguration(dependency2))) {
                return dependency1.compareTo(dependency2);
            }
            String group1 = this._getPropertyValue(dependency1, "group");
            String group2 = this._getPropertyValue(dependency2, "group");
            if (group1 != null && group1.equals(group2)) {
                int length2;
                int length1;
                String name1 = this._getPropertyValue(dependency1, "name");
                String name2 = this._getPropertyValue(dependency2, "name");
                if (name1 != null && name1.equals(name2) && (length1 = dependency1.length()) == (length2 = dependency2.length())) {
                    return 0;
                }
            }
            return dependency1.compareTo(dependency2);
        }

        private String _getPropertyValue(String dependency, String propertyName) {
            Pattern pattern = Pattern.compile(".* " + propertyName + ": \"(.+?)\"");
            Matcher matcher = pattern.matcher(dependency);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
    }
}

