/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaticBlockCheck
extends BaseCheck {
    private static final String _IMMUTABLE_FIELD_TYPES_KEY = "immutableFieldTypes";
    private static final String _MSG_UNNEEDED_STATIC_BLOCK = "static.block.unneeded";

    public int[] getDefaultTokens() {
        return new int[]{12};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<String> classObjectNames = this._getClassObjectNames(detailAST);
        if (classObjectNames.isEmpty()) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        if (methodCallDetailASTList.isEmpty()) {
            return;
        }
        Map<String, List<DetailAST>> identDetailASTMap = this._getIdentDetailASTMap(detailAST);
        Map<String, DetailAST[]> variableDefMap = this._getVariableDefMap(detailAST, identDetailASTMap);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            this._checkMethodCall(methodCallDetailAST, classObjectNames, identDetailASTMap, variableDefMap);
        }
    }

    private void _checkMethodCall(DetailAST methodCallDetailAST, List<String> classObjectNames, Map<String, List<DetailAST>> identDetailASTMap, Map<String, DetailAST[]> variableDefMap) {
        String variableName = this.getVariableName(methodCallDetailAST);
        if (!classObjectNames.contains(variableName) || variableName.equals("_log")) {
            return;
        }
        DetailAST topLevelDetailAST = this._getTopLevelDetailAST(methodCallDetailAST);
        int statementEndLineNumber = this.getEndLineNumber(topLevelDetailAST);
        List<DetailAST> variableDetailASTList = identDetailASTMap.get(variableName);
        DetailAST firstUseVariableDetailAST = variableDetailASTList.get(0);
        int statementStartLineNumber = this.getStartLineNumber(this._getTopLevelDetailAST(firstUseVariableDetailAST));
        if (!this._isRequiredMethodCall(variableName, classObjectNames, identDetailASTMap, variableDefMap, statementStartLineNumber, statementEndLineNumber)) {
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotDetailAST);
            this.log(methodCallDetailAST, _MSG_UNNEEDED_STATIC_BLOCK, new Object[]{fullIdent.getText()});
        }
    }

    private List<String> _getClassObjectNames(DetailAST staticInitDetailAST) {
        ArrayList<String> staticObjectNames = new ArrayList<String>();
        List<String> immutableFieldTypes = this.getAttributeValues(_IMMUTABLE_FIELD_TYPES_KEY);
        DetailAST previousSiblingDetailAST = staticInitDetailAST.getPreviousSibling();
        while (previousSiblingDetailAST != null) {
            DetailAST modifiersDetailAST = previousSiblingDetailAST.findFirstToken(5);
            if (modifiersDetailAST == null) {
                previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling();
                continue;
            }
            DetailAST nameDetailAST = previousSiblingDetailAST.findFirstToken(58);
            String name = nameDetailAST.getText();
            if (previousSiblingDetailAST.getType() != 10) {
                staticObjectNames.add(name);
            } else if (!immutableFieldTypes.contains(this.getTypeName(previousSiblingDetailAST, true))) {
                staticObjectNames.add(name);
            }
            previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling();
        }
        return staticObjectNames;
    }

    private Map<String, List<DetailAST>> _getIdentDetailASTMap(DetailAST staticInitDetailAST) {
        HashMap<String, List<DetailAST>> identDetailASTMap = new HashMap<String, List<DetailAST>>();
        List<DetailAST> identDetailASTList = this.getAllChildTokens(staticInitDetailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            ArrayList<DetailAST> list = (ArrayList<DetailAST>)identDetailASTMap.get(identDetailAST.getText());
            if (list == null) {
                list = new ArrayList<DetailAST>();
            }
            list.add(identDetailAST);
            identDetailASTMap.put(identDetailAST.getText(), list);
        }
        return identDetailASTMap;
    }

    private DetailAST _getTopLevelDetailAST(DetailAST detailAST) {
        DetailAST topLevelDetailAST = null;
        DetailAST parentDetailAST = detailAST;
        DetailAST grandParentDetailAST;
        while ((grandParentDetailAST = parentDetailAST.getParent()).getType() != 12) {
            if (grandParentDetailAST.getType() == 7) {
                topLevelDetailAST = parentDetailAST;
            }
            parentDetailAST = grandParentDetailAST;
        }
        return topLevelDetailAST;
    }

    private Map<String, DetailAST[]> _getVariableDefMap(DetailAST staticInitDetailAST, Map<String, List<DetailAST>> identDetailASTMap) {
        HashMap<String, DetailAST[]> variableDefMap = new HashMap<String, DetailAST[]>();
        List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(staticInitDetailAST, true, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            String name = this.getName(variableDefinitionDetailAST);
            List<DetailAST> identDetailASTList = identDetailASTMap.get(name);
            DetailAST firstIdentDetailAST = identDetailASTList.get(0);
            DetailAST lastIdentDetailAST = identDetailASTList.get(identDetailASTList.size() - 1);
            variableDefMap.put(name, new DetailAST[]{firstIdentDetailAST, lastIdentDetailAST});
        }
        return variableDefMap;
    }

    private boolean _isRequiredMethodCall(String variableName, List<String> classObjectNames, Map<String, List<DetailAST>> identDetailASTMap, Map<String, DetailAST[]> variableDefMap, int start, int end) {
        for (Map.Entry<String, List<DetailAST>> entry : identDetailASTMap.entrySet()) {
            String name = entry.getKey();
            if (name.equals(variableName)) {
                for (DetailAST detailAST : entry.getValue()) {
                    DetailAST literalNewDetailAST;
                    if (detailAST.getLineNo() > end) break;
                    DetailAST parentDetailAST = detailAST.getParent();
                    if (parentDetailAST.getType() == 59 || parentDetailAST.getType() == 80 && (literalNewDetailAST = parentDetailAST.findFirstToken(136)) != null) continue;
                    return true;
                }
                continue;
            }
            for (DetailAST detailAST : entry.getValue()) {
                if (detailAST.getLineNo() < start || detailAST.getLineNo() > end) continue;
                if (classObjectNames.contains(name)) {
                    return true;
                }
                DetailAST[] firstAndLastUsedDetailASTArray = variableDefMap.get(name);
                if (firstAndLastUsedDetailASTArray == null) continue;
                DetailAST lastUsedDetailAST = firstAndLastUsedDetailASTArray[1];
                if (lastUsedDetailAST.getLineNo() > end) {
                    return true;
                }
                DetailAST firstUsedDetailAST = firstAndLastUsedDetailASTArray[0];
                if (firstUsedDetailAST.getLineNo() >= start) continue;
                DetailAST topLevelDetailAST = this._getTopLevelDetailAST(firstUsedDetailAST);
                int statementStartLineNumber = this.getStartLineNumber(topLevelDetailAST);
                return this._isRequiredMethodCall(variableName, classObjectNames, identDetailASTMap, variableDefMap, statementStartLineNumber, end);
            }
        }
        return false;
    }
}

