/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;
import java.util.Objects;

public class ExceptionMapperAnnotationCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_OSGI_JAXRS_MAME = "osgi.jaxrs.name.incorrect";
    private static final String _OSGI_SERVICE_NAME = "ExceptionMapper";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<String> importNames = this.getImportNames(detailAST);
        if (!importNames.contains("javax.ws.rs.ext.ExceptionMapper") || !importNames.contains("org.osgi.service.component.annotations.Component")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null || !this._isExceptionMapperService(annotationDetailAST)) {
            return;
        }
        DetailAST propertyAnnotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "property");
        if (propertyAnnotationMemberValuePairDetailAST == null) {
            return;
        }
        DetailAST annotationArrayInitDetailAST = propertyAnnotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST == null) {
            return;
        }
        String osgiJaxrsName = this._getOSGiJaxrsName(annotationArrayInitDetailAST);
        if (Validator.isNull(osgiJaxrsName)) {
            return;
        }
        if (!osgiJaxrsName.endsWith(_OSGI_SERVICE_NAME)) {
            this.log(annotationArrayInitDetailAST, _MSG_INCORRECT_OSGI_JAXRS_MAME, new Object[]{_OSGI_SERVICE_NAME});
        }
    }

    private String _getOSGiJaxrsName(DetailAST annotationArrayInitDetailAST) {
        List<DetailAST> expressionDetailASTList = this.getAllChildTokens(annotationArrayInitDetailAST, false, 28);
        for (DetailAST expressionDetailAST : expressionDetailASTList) {
            String value;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139 || !(value = firstChildDetailAST.getText()).startsWith("\"osgi.jaxrs.name=")) continue;
            return value.substring(17, value.length() - 1);
        }
        return null;
    }

    private boolean _isExceptionMapperService(DetailAST annotationDetailAST) {
        DetailAST serviceAnnotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "service");
        if (serviceAnnotationMemberValuePairDetailAST == null) {
            return false;
        }
        DetailAST exprDetailAST = serviceAnnotationMemberValuePairDetailAST.findFirstToken(28);
        if (exprDetailAST == null) {
            return false;
        }
        DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 59) {
            return false;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        return Objects.equals(fullIdent.getText(), "ExceptionMapper.class");
    }
}

