/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.util.ThreadSafeSortedClassLibraryBuilder;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class UnprocessedExceptionCheck
extends BaseCheck {
    private static final String _MSG_UNPROCESSED_EXCEPTION = "exception.unprocessed";
    private static final Log _log = LogFactoryUtil.getLog(UnprocessedExceptionCheck.class);

    public int[] getDefaultTokens() {
        return new int[]{96, 136};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.contains("/test/") || absolutePath.contains("/testIntegration/")) {
            return;
        }
        if (detailAST.getType() == 96) {
            FileContents fileContents = this.getFileContents();
            FileText fileText = fileContents.getText();
            this._checkUnprocessedException(detailAST, (String)fileText.getFullText());
        } else {
            this._checkUnprocessedThrownException(detailAST);
        }
    }

    private void _checkUnprocessedException(DetailAST detailAST, String content) {
        String packageName;
        JavaClass exceptionClass;
        DetailAST parameterDefinitionDetailAST = detailAST.findFirstToken(21);
        String exceptionVariableName = this._getName(parameterDefinitionDetailAST);
        if (this._containsVariable(detailAST.findFirstToken(7), exceptionVariableName)) {
            return;
        }
        String exceptionClassName = this._getExceptionClassName(parameterDefinitionDetailAST);
        if (exceptionClassName == null || exceptionClassName.equals("JSONException")) {
            return;
        }
        JavaProjectBuilder javaProjectBuilder = this._getJavaProjectBuilder(content);
        if (javaProjectBuilder == null) {
            return;
        }
        String originalExceptionClassName = exceptionClassName;
        if (!exceptionClassName.contains(".")) {
            for (String importedExceptionClassName : this._getImportedExceptionClassNames(javaProjectBuilder)) {
                if (!importedExceptionClassName.endsWith("." + exceptionClassName)) continue;
                exceptionClassName = importedExceptionClassName;
                break;
            }
        }
        if (!exceptionClassName.contains(".")) {
            exceptionClassName = JavaSourceUtil.getPackageName(content) + "." + exceptionClassName;
        }
        if ((exceptionClass = javaProjectBuilder.getClassByName(exceptionClassName)) == null) {
            return;
        }
        while ((packageName = exceptionClass.getPackageName()).contains("com.liferay")) {
            exceptionClassName = exceptionClass.getName();
            if (exceptionClassName.equals("PortalException") || exceptionClassName.equals("SystemException")) {
                this.log(parameterDefinitionDetailAST, _MSG_UNPROCESSED_EXCEPTION, new Object[]{originalExceptionClassName});
                break;
            }
            JavaClass exceptionSuperClass = exceptionClass.getSuperJavaClass();
            if (exceptionSuperClass == null) break;
            exceptionClass = exceptionSuperClass;
        }
    }

    private void _checkUnprocessedThrownException(DetailAST detailAST) {
        String name = this._getName(detailAST);
        if (name == null || !name.endsWith("Exception")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        DetailAST exprDetailAST = parentDetailAST;
        while (true) {
            if (parentDetailAST == null) {
                return;
            }
            if (parentDetailAST.getType() == 96) break;
            parentDetailAST = parentDetailAST.getParent();
        }
        DetailAST parameterDefinitionDetailAST = parentDetailAST.findFirstToken(21);
        String exceptionClassName = this._getExceptionClassName(parameterDefinitionDetailAST);
        if (Objects.equals(exceptionClassName, "JSONException")) {
            return;
        }
        String exceptionVariableName = this._getName(parameterDefinitionDetailAST);
        if (this._containsVariable(parentDetailAST.findFirstToken(7), exceptionVariableName)) {
            return;
        }
        parentDetailAST = exprDetailAST.getParent();
        if (parentDetailAST.getType() == 90 || parentDetailAST.getType() == 7) {
            this.log(detailAST, _MSG_UNPROCESSED_EXCEPTION, new Object[]{exceptionVariableName});
        }
    }

    private boolean _containsVariable(DetailAST detailAST, String variableName) {
        List<String> names = this.getNames(detailAST, true);
        return names.contains(variableName);
    }

    private String _getExceptionClassName(DetailAST parameterDefinitionDetailAST) {
        DetailAST typeDetailAST = parameterDefinitionDetailAST.findFirstToken(13);
        FullIdent typeIdent = FullIdent.createFullIdentBelow((DetailAST)typeDetailAST);
        return typeIdent.getText();
    }

    private Set<String> _getImportedExceptionClassNames(JavaProjectBuilder javaProjectBuilder) {
        HashSet<String> exceptionClassNames = new HashSet<String>();
        Collection sources = javaProjectBuilder.getSources();
        Iterator iterator = sources.iterator();
        JavaSource javaSource = (JavaSource)iterator.next();
        for (String importClassName : javaSource.getImports()) {
            if (!importClassName.endsWith("Exception")) continue;
            exceptionClassNames.add(importClassName);
        }
        return exceptionClassNames;
    }

    private JavaProjectBuilder _getJavaProjectBuilder(String content) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder((ClassLibraryBuilder)new ThreadSafeSortedClassLibraryBuilder());
        try {
            javaProjectBuilder.addSource((Reader)new UnsyncStringReader(content));
        }
        catch (ParseException parseException) {
            if (_log.isDebugEnabled()) {
                _log.debug(parseException);
            }
            return null;
        }
        return javaProjectBuilder;
    }

    private String _getName(DetailAST detailAST) {
        String name = this.getName(detailAST);
        if (name != null) {
            return name;
        }
        DetailAST dotDetailAST = detailAST.findFirstToken(59);
        if (dotDetailAST != null) {
            return this.getName(dotDetailAST);
        }
        return null;
    }
}

