/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.util.Validator;
import java.util.Stack;
import org.dom4j.Element;

public final class PoshiStackTraceUtil {
    private static Element _currentElement;
    private static final Stack<String> _filePaths;
    private static final Stack<String> _stackTrace;

    public static void emptyStackTrace() {
        while (!_stackTrace.isEmpty()) {
            _stackTrace.pop();
        }
    }

    public static String getCurrentFilePath() {
        return _filePaths.peek();
    }

    public static String getCurrentNamespace() {
        if (_filePaths.isEmpty()) {
            return PoshiContext.getDefaultNamespace();
        }
        String filePath = PoshiStackTraceUtil.getCurrentFilePath();
        int x = filePath.indexOf("[");
        return PoshiContext.getNamespaceFromFilePath(filePath.substring(0, x));
    }

    public static String getCurrentNamespace(String namespacedClassCommandName) {
        String defaultNamespace = PoshiContext.getDefaultNamespace();
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName(namespacedClassCommandName);
        if (Validator.isNull(namespace) || namespace.equals(defaultNamespace)) {
            namespace = PoshiStackTraceUtil.getCurrentNamespace();
        }
        return namespace;
    }

    public static String getSimpleStackTrace() {
        StringBuilder sb = new StringBuilder();
        for (String filePath : _stackTrace) {
            if (filePath.contains(".function")) continue;
            sb.append(PoshiGetterUtil.getFileNameFromFilePath(filePath));
        }
        String currentFilePath = _filePaths.peek();
        if (!currentFilePath.contains(".function")) {
            sb.append(PoshiGetterUtil.getFileNameFromFilePath(currentFilePath));
            sb.append(":");
            sb.append(PoshiGetterUtil.getLineNumber(_currentElement));
        }
        return sb.toString();
    }

    public static String getStackTrace(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nBUILD FAILED:");
        if (Validator.isNotNull(msg)) {
            sb.append(" ");
            sb.append(msg);
        }
        Stack stackTrace = (Stack)_stackTrace.clone();
        sb.append("\n");
        sb.append(_filePaths.peek());
        sb.append(":");
        sb.append(PoshiGetterUtil.getLineNumber(_currentElement));
        while (!stackTrace.isEmpty()) {
            sb.append("\n");
            sb.append((String)stackTrace.pop());
        }
        sb.append("\n");
        return sb.toString();
    }

    public static void popStackTrace() {
        _filePaths.pop();
        _stackTrace.pop();
    }

    public static void printStackTrace() {
        PoshiStackTraceUtil.printStackTrace(null);
    }

    public static void printStackTrace(String msg) {
        System.out.println(PoshiStackTraceUtil.getStackTrace(msg));
    }

    public static void pushStackTrace(Element element) throws Exception {
        _stackTrace.push(_filePaths.peek() + ":" + PoshiGetterUtil.getLineNumber(element));
        String namespacedClassCommandName = null;
        String classType = null;
        if (element.attributeValue("function") != null) {
            namespacedClassCommandName = element.attributeValue("function");
            classType = "function";
        } else if (element.attributeValue("macro") != null) {
            namespacedClassCommandName = element.attributeValue("macro");
            classType = "macro";
        } else if (element.attributeValue("test-case") != null) {
            namespacedClassCommandName = element.attributeValue("test-case");
            String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(namespacedClassCommandName);
            if (className.equals("super")) {
                className = PoshiGetterUtil.getExtendedTestCaseName();
                namespacedClassCommandName = namespacedClassCommandName.replaceFirst("super", className);
            }
            classType = "test-case";
        } else {
            PoshiStackTraceUtil.printStackTrace();
            throw new Exception("Missing (function|macro|test-case) attribute");
        }
        PoshiStackTraceUtil._pushFilePath(namespacedClassCommandName, classType);
    }

    public static void setCurrentElement(Element currentElement) {
        _currentElement = currentElement;
    }

    public static void startStackTrace(String classCommandName, String classType) {
        PoshiStackTraceUtil._pushFilePath(classCommandName, classType);
    }

    private static void _pushFilePath(String namespacedClassCommandName, String classType) {
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName(namespacedClassCommandName);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(classCommandName);
        String fileExtension = PoshiGetterUtil.getFileExtensionFromClassType(classType);
        String filePath = PoshiContext.getFilePathFromFileName(className + "." + fileExtension, PoshiStackTraceUtil.getCurrentNamespace(namespacedClassCommandName));
        if (classType.equals("test-case") && filePath == null) {
            filePath = PoshiContext.getFilePathFromFileName(className + ".prose", PoshiStackTraceUtil.getCurrentNamespace(namespacedClassCommandName));
        }
        String commandName = PoshiGetterUtil.getCommandNameFromNamespacedClassCommandName(namespacedClassCommandName);
        _filePaths.push(filePath + "[" + commandName + "]");
    }

    static {
        _filePaths = new Stack();
        _stackTrace = new Stack();
    }
}

