/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.Element;

public class CheckstyleLogger
extends DefaultLogger {
    private static final Log _log = LogFactoryUtil.getLog(CheckstyleLogger.class);
    private static final Set<SourceFormatterMessage> _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
    private final String _baseDirName;

    public CheckstyleLogger(String baseDirName) {
        super((OutputStream)new UnsyncByteArrayOutputStream(), AutomaticBean.OutputStreamOptions.CLOSE);
        this._baseDirName = baseDirName;
    }

    public void addError(AuditEvent auditEvent) {
        this.addError(auditEvent, this.getRelativizedFileName(auditEvent));
    }

    public void clearSourceFormatterMessages() {
        _sourceFormatterMessages.clear();
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return _sourceFormatterMessages;
    }

    protected void addError(AuditEvent auditEvent, String fileName) {
        String checkName = auditEvent.getSourceName();
        String simpleCheckName = SourceFormatterUtil.getSimpleName(checkName);
        _sourceFormatterMessages.add(new SourceFormatterMessage(fileName, auditEvent.getMessage(), CheckType.CHECKSTYLE, simpleCheckName, this._getDocumentationURLString(checkName, simpleCheckName), auditEvent.getLine()));
        super.addError(auditEvent);
    }

    protected String getRelativizedFileName(AuditEvent auditEvent) {
        if (Validator.isNull(this._baseDirName)) {
            return auditEvent.getFileName();
        }
        Path baseDirPath = this._getAbsoluteNormalizedPath(this._baseDirName);
        Path relativizedPath = baseDirPath.relativize(this._getAbsoluteNormalizedPath(auditEvent.getFileName()));
        String relativizedPathString = StringUtil.replace(relativizedPath.toString(), '\\', '/');
        return this._baseDirName + relativizedPathString;
    }

    private Path _getAbsoluteNormalizedPath(String pathName) {
        Path path = Paths.get(pathName, new String[0]);
        path = path.toAbsolutePath();
        return path.normalize();
    }

    private String _getCheckstyleDocumentationURLString(Element element, String checkName) {
        if (checkName.equals(element.attributeValue("name"))) {
            for (Element propertyElement : element.elements("property")) {
                if (!Objects.equals(propertyElement.attributeValue("name"), "documentationLocation")) continue;
                return "https://checkstyle.sourceforge.io/" + propertyElement.attributeValue("value");
            }
        }
        for (Element moduleElement : element.elements("module")) {
            String checkstyleURLFilePath = this._getCheckstyleDocumentationURLString(moduleElement, checkName);
            if (checkstyleURLFilePath == null) continue;
            return checkstyleURLFilePath;
        }
        return null;
    }

    private String _getCheckstyleDocumentationURLString(String checkName) {
        try {
            ClassLoader classLoader = SourceFormatterMessage.class.getClassLoader();
            Document document = SourceUtil.readXML(StringUtil.read(classLoader.getResourceAsStream("checkstyle.xml")));
            return this._getCheckstyleDocumentationURLString(document.getRootElement(), checkName);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return null;
        }
    }

    private String _getDocumentationURLString(String checkName, String simpleCheckName) {
        if (!checkName.startsWith("com.liferay.")) {
            return this._getCheckstyleDocumentationURLString(simpleCheckName);
        }
        ClassLoader classLoader = CheckstyleLogger.class.getClassLoader();
        try {
            return SourceFormatterUtil.getDocumentationURLString(classLoader.loadClass(checkName));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return null;
        }
    }
}

