/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UnusedMethodCheck
extends BaseCheck {
    private static final String _ALLOWED_METHOD_NAMES_KEY = "allowedMethodNames";
    private static final String _MSG_UNUSED_METHOD = "method.unused";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(detailAST, true, 9);
        if (methodDefinitionDetailASTList.isEmpty()) {
            return;
        }
        List<String> allowedMethodNames = this.getAttributeValues(_ALLOWED_METHOD_NAMES_KEY);
        Map<String, Set<Integer>> referencedMethodNamesMap = this._getReferencedMethodNamesMap(detailAST);
        block0: for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            DetailAST lastParameterDefinitionDetailAST;
            DetailAST nameDetailAST;
            String name;
            DetailAST modifiersDetailAST = methodDefinitionDetailAST.findFirstToken(5);
            if (!modifiersDetailAST.branchContains(61) || AnnotationUtil.containsAnnotation((DetailAST)methodDefinitionDetailAST) || this._hasSuppressUnusedWarningsAnnotation(methodDefinitionDetailAST) || allowedMethodNames.contains(name = (nameDetailAST = methodDefinitionDetailAST.findFirstToken(58)).getText())) continue;
            DetailAST parametersDetailAST = methodDefinitionDetailAST.findFirstToken(20);
            Set<Integer> parameterCountSet = referencedMethodNamesMap.get(name);
            if (parameterCountSet == null) {
                this.log(methodDefinitionDetailAST, _MSG_UNUSED_METHOD, new Object[]{name});
                continue;
            }
            if (parameterCountSet.contains(-1)) continue;
            List<DetailAST> parameterDefinitionDetailASTList = this.getAllChildTokens(parametersDetailAST, false, 21);
            int parameterCount = parameterDefinitionDetailASTList.size();
            boolean varArgs = false;
            if (parameterCount > 0 && (lastParameterDefinitionDetailAST = parameterDefinitionDetailASTList.get(parameterDefinitionDetailASTList.size() - 1)).branchContains(171)) {
                varArgs = true;
            }
            if (varArgs) {
                for (int curParameterCount : parameterCountSet) {
                    if (curParameterCount < parameterCount - 1) continue;
                    continue block0;
                }
                this.log(methodDefinitionDetailAST, _MSG_UNUSED_METHOD, new Object[]{name});
                continue;
            }
            if (parameterCountSet.contains(parameterCount)) continue;
            this.log(methodDefinitionDetailAST, _MSG_UNUSED_METHOD, new Object[]{name});
        }
    }

    private Map<String, Set<Integer>> _addMapEntry(Map<String, Set<Integer>> map, String key, int value) {
        Set<Integer> set = map.get(key);
        if (set == null) {
            set = new HashSet<Integer>();
        }
        set.add(value);
        map.put(key, set);
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Set<Integer>> _getReferencedMethodNamesMap(DetailAST classDefinitionDetailAST) {
        Map<String, Set<Integer>> referencedMethodNamesMap = new HashMap<String, Set<Integer>>();
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(classDefinitionDetailAST, true, 27);
        for (DetailAST detailAST : methodCallDetailASTList) {
            void var6_8;
            DetailAST detailAST2 = detailAST.getFirstChild();
            if (detailAST2.getType() == 59) {
                DetailAST detailAST3 = detailAST2.getLastChild();
            }
            DetailAST elistDetailAST = detailAST.findFirstToken(34);
            int parameterCount = 0;
            int childCount = elistDetailAST.getChildCount();
            if (childCount > 0) {
                parameterCount = (childCount + 1) / 2;
            }
            referencedMethodNamesMap = this._addMapEntry(referencedMethodNamesMap, var6_8.getText(), parameterCount);
        }
        List<DetailAST> methodReferenceDetailASTList = this.getAllChildTokens(classDefinitionDetailAST, true, 180);
        for (DetailAST detailAST : methodReferenceDetailASTList) {
            DetailAST lastChildDetailAST = detailAST.getLastChild();
            referencedMethodNamesMap = this._addMapEntry(referencedMethodNamesMap, lastChildDetailAST.getText(), -1);
        }
        List<DetailAST> list = this.getAllChildTokens(classDefinitionDetailAST, true, 136);
        for (DetailAST literalNewDetailAST : list) {
            DetailAST exprDetailAST;
            DetailAST firstChildDetailAST = literalNewDetailAST.getFirstChild();
            if (firstChildDetailAST == null || firstChildDetailAST.getType() != 58 || !Objects.equals(firstChildDetailAST.getText(), "MethodKey")) continue;
            DetailAST elistDetailAST = literalNewDetailAST.findFirstToken(34);
            List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
            if (exprDetailASTList.size() < 2 || (firstChildDetailAST = (exprDetailAST = exprDetailASTList.get(1)).getFirstChild()).getType() != 139) continue;
            String text = firstChildDetailAST.getText();
            referencedMethodNamesMap = this._addMapEntry(referencedMethodNamesMap, text.substring(1, text.length() - 1), exprDetailASTList.size() - 2);
        }
        List<DetailAST> list2 = this.getAllChildTokens(classDefinitionDetailAST, true, 159);
        for (DetailAST annotationDetailAST : list2) {
            DetailAST atDetailAST = annotationDetailAST.findFirstToken(170);
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)atDetailAST.getNextSibling());
            String annotationName = fullIdent.getText();
            if (!annotationName.endsWith("Reference")) continue;
            List<DetailAST> annotationMemberValuePairDetailASTList = this.getAllChildTokens(annotationDetailAST, false, 160);
            for (DetailAST annotationMemberValuePairDetailAST : annotationMemberValuePairDetailASTList) {
                DetailAST nextSiblingDetailAST;
                String propertyValueName;
                DetailAST firstChildDetailAST = annotationMemberValuePairDetailAST.getFirstChild();
                String propertyName = firstChildDetailAST.getText();
                if (!propertyName.equals("unbind") || !(propertyValueName = (fullIdent = FullIdent.createFullIdentBelow((DetailAST)(nextSiblingDetailAST = firstChildDetailAST.getNextSibling()).getNextSibling())).getText()).matches("\".*\"")) continue;
                referencedMethodNamesMap = this._addMapEntry(referencedMethodNamesMap, propertyValueName.substring(1, propertyValueName.length() - 1), 1);
            }
        }
        return referencedMethodNamesMap;
    }

    private boolean _hasSuppressUnusedWarningsAnnotation(DetailAST methodDefinitionDetailAST) {
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)methodDefinitionDetailAST, (String)"SuppressWarnings");
        if (annotationDetailAST == null) {
            return false;
        }
        List<DetailAST> literalStringDetailASTList = this.getAllChildTokens(annotationDetailAST, true, 139);
        for (DetailAST literalStringDetailAST : literalStringDetailASTList) {
            String s = literalStringDetailAST.getText();
            if (!s.equals("\"unused\"")) continue;
            return true;
        }
        return false;
    }
}

