/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceUtil
extends SourceUtil {
    private static final String[] _JAVA_LANG_CLASS_NAMES = new String[]{"AbstractMethodError", "Appendable", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "AssertionError", "AutoCloseable", "Boolean", "BootstrapMethodError", "Byte", "Character", "CharSequence", "Class", "ClassCastException", "ClassCircularityError", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "ClassValue", "Cloneable", "CloneNotSupportedException", "Comparable", "Compiler", "Deprecated", "Double", "Enum", "EnumConstantNotPresentException", "Error", "Exception", "ExceptionInInitializerError", "Float", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IncompatibleClassChangeError", "IndexOutOfBoundsException", "InheritableThreadLocal", "InstantiationError", "InstantiationException", "Integer", "InternalError", "InterruptedException", "Iterable", "LinkageError", "Long", "Math", "NegativeArraySizeException", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchFieldException", "NoSuchMethodError", "NoSuchMethodException", "NullPointerException", "Number", "NumberFormatException", "Object", "OutOfMemoryError", "Override", "Package", "Process", "ProcessBuilder", "Readable", "ReflectiveOperationException", "Runnable", "Runtime", "RuntimeException", "RuntimePermission", "SafeVarargs", "SecurityException", "SecurityManager", "Short", "StackOverflowError", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "StringIndexOutOfBoundsException", "SuppressWarnings", "System", "Thread", "Thread", "ThreadDeath", "ThreadGroup", "ThreadLocal", "Throwable", "TypeNotPresentException", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "UnsupportedOperationException", "VerifyError", "VirtualMachineError", "Void"};
    private static final Log _log = LogFactoryUtil.getLog(JavaSourceUtil.class);
    private static final Pattern _packagePattern = Pattern.compile("(\n|^)\\s*package (.*);\n");

    public static String getClassName(String fileName) {
        int x = fileName.lastIndexOf(47);
        int y = fileName.lastIndexOf(46);
        return fileName.substring(x + 1, y);
    }

    public static File getJavaFile(String fullyQualifiedName, String rootDirName, Map<String, String> bundleSymbolicNamesMap) {
        block6: {
            File file;
            if (fullyQualifiedName.contains(".kernel.") && (file = JavaSourceUtil._getJavaFile(fullyQualifiedName, rootDirName, "portal-kernel/src/", "portal-test/src/", "portal-impl/test/integration/", "portal-impl/test/unit/")) != null) {
                return file;
            }
            if ((fullyQualifiedName.startsWith("com.liferay.portal.") || fullyQualifiedName.startsWith("com.liferay.portlet.")) && (file = JavaSourceUtil._getJavaFile(fullyQualifiedName, rootDirName, "portal-impl/src/", "portal-test/src/", "portal-test-integration/src/", "portal-impl/test/integration/", "portal-impl/test/unit/")) != null) {
                return file;
            }
            if (fullyQualifiedName.contains(".taglib.") && (file = JavaSourceUtil._getJavaFile(fullyQualifiedName, rootDirName, "util-taglib/src/")) != null) {
                return file;
            }
            try {
                file = JavaSourceUtil._getModuleJavaFile(fullyQualifiedName, bundleSymbolicNamesMap);
                if (file != null) {
                    return file;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug(exception, exception);
            }
        }
        return null;
    }

    public static String getPackageName(String content) {
        Matcher matcher = _packagePattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    public static String getPackageName(String className, String classPackageName, List<String> importNames) {
        if (className.matches("[a-z].*") || className.length() == 1) {
            return "";
        }
        for (String importName : importNames) {
            if (importName.endsWith("." + className)) {
                return StringUtil.removeLast(importName, "." + className);
            }
            int x = className.length();
            while ((x = className.lastIndexOf(".", x - 1)) != -1) {
                if (!importName.endsWith("." + className.substring(0, x))) continue;
                return StringUtil.removeLast(importName, "." + className.substring(0, x));
            }
        }
        if (ArrayUtil.contains(_JAVA_LANG_CLASS_NAMES, className)) {
            return "java.lang";
        }
        return classPackageName;
    }

    public static List<String> getParameterList(String methodCall) {
        String parameters = null;
        int x = -1;
        while (ToolsUtil.getLevel(parameters = methodCall.substring(0, (x = methodCall.indexOf(")", x + 1)) + 1), "(", ")") != 0 || ToolsUtil.getLevel(parameters, "{", "}") != 0) {
        }
        x = parameters.indexOf("(");
        parameters = parameters.substring(x + 1, parameters.length() - 1);
        return JavaSourceUtil.splitParameters(parameters);
    }

    public static boolean isValidJavaParameter(String javaParameter) {
        if (javaParameter.contains(" implements ") || javaParameter.contains(" throws ")) {
            return false;
        }
        return ToolsUtil.getLevel(javaParameter, "(", ")") == 0 && ToolsUtil.getLevel(javaParameter, "<", ">") == 0 && ToolsUtil.getLevel(javaParameter, "{", "}") == 0;
    }

    public static List<String> splitParameters(String parameters) {
        ArrayList<String> parametersList = new ArrayList<String>();
        if ((parameters = StringUtil.trim(parameters)).equals("")) {
            return parametersList;
        }
        int x = -1;
        while (true) {
            String linePart;
            if ((x = parameters.indexOf(",", x + 1)) == -1) {
                parametersList.add(StringUtil.trim(parameters));
                return parametersList;
            }
            if (ToolsUtil.isInsideQuotes(parameters, x) || ToolsUtil.getLevel(linePart = parameters.substring(0, x), "(", ")") != 0 || ToolsUtil.getLevel(linePart, "{", "}") != 0) continue;
            parametersList.add(StringUtil.trim(linePart));
            parameters = parameters.substring(x + 1);
            x = -1;
        }
    }

    private static File _getJavaFile(String fullyQualifiedName, String rootDirName, String ... dirNames) {
        if (Validator.isNull(rootDirName)) {
            return null;
        }
        for (String dirName : dirNames) {
            StringBundler sb = new StringBundler(5);
            sb.append(rootDirName);
            sb.append("/");
            sb.append(dirName);
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            File file = new File(sb.toString());
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private static File _getModuleJavaFile(String fullyQualifiedName, Map<String, String> bundleSymbolicNamesMap) {
        for (Map.Entry<String, String> entry : bundleSymbolicNamesMap.entrySet()) {
            String bundleSymbolicName = entry.getKey();
            String modifiedBundleSymbolicName = bundleSymbolicName.replaceAll("\\.(api|impl|service|test)$", "");
            if (!fullyQualifiedName.startsWith(modifiedBundleSymbolicName)) continue;
            StringBundler sb = new StringBundler(4);
            sb.append(entry.getValue());
            sb.append("/src/main/java/");
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            File file = new File(sb.toString());
            if (file.exists()) {
                return file;
            }
            sb = new StringBundler(4);
            sb.append(entry.getValue());
            sb.append("/src/testIntegration/java/");
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            file = new File(sb.toString());
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }
}

