/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import java.io.File;
import java.util.List;

public class GradleDependencyConfigurationCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!this.isModulesApp(absolutePath, false) || !this._hasBNDFile(absolutePath) || GradleSourceUtil.isSpringBootExecutable(content)) {
            return content;
        }
        List<String> blocks = GradleSourceUtil.getDependenciesBlocks(content);
        for (String dependencies : blocks) {
            content = this._formatDependencies(content, dependencies);
        }
        return content;
    }

    private String _formatDependencies(String content, String dependencies) {
        int y;
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        for (String oldDependency : StringUtil.splitLines(dependencies)) {
            String configuration = GradleSourceUtil.getConfiguration(oldDependency);
            String newDependency = oldDependency;
            if (configuration.equals("compile")) {
                newDependency = StringUtil.replaceFirst(oldDependency, "compile", "compileOnly");
                content = StringUtil.replaceFirst(content, oldDependency, newDependency);
                continue;
            }
            if (!configuration.equals("compileOnly")) continue;
            newDependency = StringUtil.removeSubstrings(oldDependency, "transitive: false, ", "transitive: true,");
            content = StringUtil.replaceFirst(content, oldDependency, newDependency);
        }
        return content;
    }

    private boolean _hasBNDFile(String absolutePath) {
        if (!absolutePath.endsWith("/build.gradle")) {
            return false;
        }
        int pos = absolutePath.lastIndexOf("/");
        File file = new File(absolutePath.substring(0, pos + 1) + "bnd.bnd");
        return file.exists();
    }
}

