/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PersistenceCallCheck
extends BaseCheck {
    private static final String _MSG_ILLEGAL_PERSISTENCE_CALL = "persistence.call.illegal";
    private static final Log _log = LogFactoryUtil.getLog(PersistenceCallCheck.class);
    private static final Pattern _extendedClassPattern = Pattern.compile("\\sextends\\s+(\\w+)\\W");

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        String absolutePath = this.getAbsolutePath();
        if (!absolutePath.contains("/modules/")) {
            return;
        }
        FileContents fileContents = this.getFileContents();
        FileText fileText = fileContents.getText();
        String content = (String)fileText.getFullText();
        if (!content.contains(".service.persistence.")) {
            return;
        }
        JavaClass javaClass = null;
        try {
            javaClass = JavaClassParser.parseJavaClass(absolutePath, content);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return;
        }
        Map<String, String> variablesMap = this._getVariablesMap(javaClass);
        variablesMap.putAll(this._getVariablesMap(this._getExtendedJavaClass(absolutePath, content)));
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            this._checkMethodCall(methodCallDetailAST, javaClass.getImportNames(), variablesMap, javaClass.getPackageName());
        }
    }

    private void _checkClass(String className, List<String> importNames, String packageName, int lineNo) {
        for (String importName : importNames) {
            if (!importName.endsWith("." + className)) continue;
            int pos = importName.indexOf(".service.persistence.");
            if (pos == -1) {
                return;
            }
            if (packageName.startsWith(importName.substring(0, pos))) continue;
            this.log(lineNo, _MSG_ILLEGAL_PERSISTENCE_CALL, new Object[]{importName});
        }
    }

    private void _checkMethodCall(DetailAST methodCallDetailAST, List<String> importNames, Map<String, String> variablesMap, String packageName) {
        String methodName;
        DetailAST childDetailAST = methodCallDetailAST.getFirstChild();
        if (childDetailAST.getType() != 59) {
            return;
        }
        if ((childDetailAST = childDetailAST.getFirstChild()).getType() != 58) {
            return;
        }
        DetailAST siblingDetailAST = childDetailAST.getNextSibling();
        if (siblingDetailAST.getType() == 58 && ((methodName = siblingDetailAST.getText()).equals("clearCache") || methodName.startsWith("create"))) {
            return;
        }
        String fieldName = childDetailAST.getText();
        if (fieldName.matches("[A-Z].*")) {
            this._checkClass(fieldName, importNames, packageName, methodCallDetailAST.getLineNo());
        } else {
            this._checkVariable(fieldName, variablesMap, packageName, methodCallDetailAST.getLineNo());
        }
    }

    private void _checkVariable(String variableName, Map<String, String> variablesMap, String packageName, int lineNo) {
        String fullyQualifiedTypeName = variablesMap.get(variableName);
        if (fullyQualifiedTypeName == null) {
            return;
        }
        int pos = fullyQualifiedTypeName.indexOf(".service.persistence.");
        if (pos == -1) {
            return;
        }
        if (!packageName.startsWith(fullyQualifiedTypeName.substring(0, pos))) {
            this.log(lineNo, _MSG_ILLEGAL_PERSISTENCE_CALL, new Object[]{fullyQualifiedTypeName});
        }
    }

    private JavaClass _getExtendedJavaClass(String absolutePath, String content) {
        Matcher matcher = _extendedClassPattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String extendedClassName = matcher.group(1);
        Pattern pattern = Pattern.compile("\nimport (.*\\." + extendedClassName + ");");
        matcher = pattern.matcher(content);
        if (matcher.find() && !(extendedClassName = matcher.group(1)).startsWith("com.liferay.")) {
            return null;
        }
        if (!extendedClassName.contains(".")) {
            extendedClassName = JavaSourceUtil.getPackageName(content) + "." + extendedClassName;
        }
        int pos = absolutePath.lastIndexOf("/com/liferay/");
        String extendedClassFileName = absolutePath.substring(0, pos + 1) + StringUtil.replace(extendedClassName, '.', '/') + ".java";
        try {
            return JavaClassParser.parseJavaClass(extendedClassFileName, FileUtil.read(new File(extendedClassFileName)));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return null;
        }
    }

    private String _getFullyQualifiedName(String className, JavaClass javaClass) {
        for (String importName : javaClass.getImportNames()) {
            if (!importName.endsWith("." + className)) continue;
            return importName;
        }
        return javaClass.getPackageName() + "." + className;
    }

    private Map<String, String> _getVariablesMap(JavaClass javaClass) {
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        if (javaClass == null) {
            return variablesMap;
        }
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            Pattern pattern;
            Matcher matcher;
            if (!javaTerm.isJavaVariable() || !(matcher = (pattern = Pattern.compile("\\s(\\S+)\\s+(\\S+\\.)?" + javaTerm.getName())).matcher(javaTerm.getContent())).find()) continue;
            String fieldTypeClassName = matcher.group(1);
            if (!fieldTypeClassName.contains(".")) {
                fieldTypeClassName = this._getFullyQualifiedName(fieldTypeClassName, javaClass);
            }
            variablesMap.put(javaTerm.getName(), fieldTypeClassName);
        }
        return variablesMap;
    }
}

