/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ListUtilCheck
extends BaseCheck {
    private static final String _MSG_UNNEEDED_ARRAY = "array.unneeded";
    private static final String _MSG_USE_LIST_UTIL_FROM_ARRAY = "list.util.from.array.use";
    private static final String _MSG_USE_LIST_UTIL_IS_EMPTY = "list.util.is.empty.use";
    private static final Log _log = LogFactoryUtil.getLog(ListUtilCheck.class);
    private final Map<String, String> _buildGradleContentsMap = new ConcurrentHashMap<String, String>();

    public int[] getDefaultTokens() {
        return new int[]{27, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String buildGradleContent;
        if (this.isExcludedPath("run.outside.portal.excludes")) {
            return;
        }
        if (detailAST.getType() == 27) {
            this._checkFromArrayCall(detailAST);
            this._checkListIsEmptyCall(detailAST);
            return;
        }
        if (!Objects.equals(this.getTypeName(detailAST, false), "List") || !this.isAssignNewArrayList(detailAST)) {
            return;
        }
        DetailAST nextStatementDetailAST = this._getNextStatementDetailAST(detailAST);
        if (nextStatementDetailAST == null) {
            return;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String variableName = nameDetailAST.getText();
        if (!this._isAddMethodCall(nextStatementDetailAST.getFirstChild(), variableName)) {
            return;
        }
        if ((nextStatementDetailAST = this._getNextStatementDetailAST(nextStatementDetailAST)) == null || nextStatementDetailAST.branchContains(72) || nextStatementDetailAST.branchContains(7)) {
            return;
        }
        List<DetailAST> identDetailASTList = this._getIdentDetailASTList(nextStatementDetailAST, variableName);
        if (identDetailASTList.size() != 1) {
            return;
        }
        DetailAST identDetailAST = identDetailASTList.get(0);
        DetailAST parentDetailAST = identDetailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        while ((nextStatementDetailAST = this._getNextStatementDetailAST(nextStatementDetailAST)) != null) {
            identDetailASTList = this._getIdentDetailASTList(nextStatementDetailAST, variableName);
            if (identDetailASTList.isEmpty()) continue;
            return;
        }
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.contains("/modules/") && ((buildGradleContent = this._getBuildGradleContent(absolutePath)) == null || !buildGradleContent.contains("com.liferay.portal.kernel"))) {
            return;
        }
        this.log(detailAST, _MSG_USE_LIST_UTIL_FROM_ARRAY, new Object[0]);
    }

    private void _checkFromArrayCall(DetailAST methodCallDetailAST) {
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        if (!Objects.equals(fullIdent.getText(), "ListUtil.fromArray")) {
            return;
        }
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        if (exprDetailASTList.size() != 1) {
            return;
        }
        DetailAST exprDetailAST = exprDetailASTList.get(0);
        firstChildDetailAST = exprDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 136) {
            return;
        }
        DetailAST lastChildDetailAST = firstChildDetailAST.getLastChild();
        if (lastChildDetailAST.getType() == 29) {
            this.log(methodCallDetailAST, _MSG_UNNEEDED_ARRAY, new Object[0]);
        }
    }

    private void _checkListEqualsNullAssertion(DetailAST detailAST, String variableName) {
        if (detailAST.getType() != 76) {
            return;
        }
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() != 116) {
            return;
        }
        DetailAST identDetailAST = nextSiblingDetailAST.getFirstChild();
        if (identDetailAST == null || identDetailAST.getType() != 58 || !Objects.equals(identDetailAST.getText(), variableName)) {
            return;
        }
        nextSiblingDetailAST = identDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() != 135) {
            return;
        }
        this.log(detailAST.getParent(), _MSG_USE_LIST_UTIL_IS_EMPTY, new Object[]{variableName});
    }

    private void _checkListIsEmptyCall(DetailAST detailAST) {
        DetailAST dotDetailAST = detailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            return;
        }
        String variableName = this.getVariableName(detailAST);
        if (Validator.isNull(variableName)) {
            return;
        }
        String methodName = this.getMethodName(detailAST);
        String variableTypeName = this.getVariableTypeName(detailAST, variableName, false);
        if (!methodName.equals("isEmpty") || !variableTypeName.equals("List")) {
            return;
        }
        DetailAST nextSiblingDetailAST = dotDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 34) {
            return;
        }
        if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null && nextSiblingDetailAST.getType() != 77) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 110) {
            return;
        }
        DetailAST firstChildDetailAST = parentDetailAST.getFirstChild();
        if (!this.equals(firstChildDetailAST, detailAST)) {
            this._checkListEqualsNullAssertion(firstChildDetailAST, variableName);
        }
    }

    private String _getBuildGradleContent(String absolutePath) {
        String buildGradleLocation = absolutePath;
        int pos;
        while ((pos = buildGradleLocation.lastIndexOf("/")) != -1) {
            String buildGradleContent = this._buildGradleContentsMap.get(buildGradleLocation = buildGradleLocation.substring(0, pos + 1));
            if (buildGradleContent != null) {
                return buildGradleContent;
            }
            File file = new File(buildGradleLocation + "build.gradle");
            if (file.exists()) {
                try {
                    buildGradleContent = FileUtil.read(file);
                    this._buildGradleContentsMap.put(buildGradleLocation, buildGradleContent);
                    return buildGradleContent;
                }
                catch (IOException ioException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(ioException, ioException);
                    }
                    return null;
                }
            }
            buildGradleLocation = StringUtil.replaceLast(buildGradleLocation, '/', "");
        }
        return null;
    }

    private List<DetailAST> _getIdentDetailASTList(DetailAST detailAST, String name) {
        ArrayList<DetailAST> identDetailASTList = new ArrayList<DetailAST>();
        List<DetailAST> childDetailASTList = this.getAllChildTokens(detailAST, true, 58);
        for (DetailAST childDetailAST : childDetailASTList) {
            if (!name.equals(childDetailAST.getText())) continue;
            identDetailASTList.add(childDetailAST);
        }
        return identDetailASTList;
    }

    private DetailAST _getNextStatementDetailAST(DetailAST detailAST) {
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        while (nextSiblingDetailAST != null && nextSiblingDetailAST.getType() == 45) {
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        return nextSiblingDetailAST;
    }

    private boolean _isAddMethodCall(DetailAST detailAST, String variableName) {
        if (detailAST == null || detailAST.getType() != 27) {
            return false;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return false;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        if (!Objects.equals(fullIdent.getText(), variableName + ".add")) {
            return false;
        }
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        if (elistDetailAST.getChildCount() != 1) {
            return true;
        }
        firstChildDetailAST = elistDetailAST.getFirstChild();
        return firstChildDetailAST.getType() != 28 || (firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 135;
    }
}

