/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class AttributeOrderCheck
extends BaseCheck {
    private static final String _MSG_ATTRIBUTE_INCORRECT_ORDER = "attribute.incorrect.order";

    public int[] getDefaultTokens() {
        return new int[]{11};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        DetailAST childDetailAST = detailAST.getFirstChild();
        if (childDetailAST.getType() != 7) {
            return;
        }
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(childDetailAST, false, 28);
        if (exprDetailASTList.size() < 2) {
            return;
        }
        this._checkAttributeOrder(exprDetailASTList);
    }

    private void _checkAttributeOrder(List<DetailAST> exprDetailASTList) {
        String previousName = null;
        for (DetailAST exprDetailAST : exprDetailASTList) {
            DetailAST childDetailAST = exprDetailAST.getFirstChild();
            if (childDetailAST.getType() != 80) continue;
            DetailAST nameDetailAST = childDetailAST.findFirstToken(58);
            String name = nameDetailAST.getText();
            if (previousName != null && previousName.compareToIgnoreCase(name) > 0) {
                this.log(exprDetailAST, _MSG_ATTRIBUTE_INCORRECT_ORDER, new Object[]{previousName, name});
            }
            previousName = name;
        }
    }
}

