/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLPoshiFileCheck
extends BaseFileCheck {
    private static final Log _log = LogFactoryUtil.getLog(XMLPoshiFileCheck.class);
    private static final Pattern _poshiCommandsPattern = Pattern.compile("\\<command.*name=\\\"([^\\\"]*)\\\".*\\>[\\s\\S]*?\\</command\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+");
    private static final Pattern _poshiElementWithNoChildPattern = Pattern.compile("\\\"[\\s]*\\>[\\n\\s\\t]*\\</[a-z\\-]+>");
    private static final Pattern _poshiEndLinesAfterClosingElementPattern = Pattern.compile("(\\</[a-z\\-]+>)(\\n+)\\t*\\<[a-z]+");
    private static final Pattern _poshiEndLinesBeforeClosingElementPattern = Pattern.compile("(\\n+)(\\t*</[a-z\\-]+>)");
    private static final Pattern _poshiEndLinesPattern = Pattern.compile("\\>\\n\\n\\n+(\\t*\\<)");
    private static final Pattern _poshiSetUpPattern = Pattern.compile("\\n[\\t]++\\<set-up\\>([\\s\\S]*?)\\</set-up\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+\\n");
    private static final Pattern _poshiTearDownPattern = Pattern.compile("\\n[\\t]++\\<tear-down\\>([\\s\\S]*?)\\</tear-down\\>[\\n|\\t]*?(?:[^(?:/\\>)]*?--\\>)*+\\n");
    private static final Pattern _poshiVariableLinePattern = Pattern.compile("([\\t]*+)(\\<var.*?name=\\\"([^\\\"]*)\\\".*?/\\>.*+(?:\\</var\\>)??)");
    private static final Pattern _poshiVariablesBlockPattern = Pattern.compile("((?:[\\t]*+\\<var.*?\\>\\n[\\t]*+){2,}?)(?:(?:\\n){1,}+|\\</execute\\>)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (fileName.endsWith(".action") || fileName.endsWith(".function") || fileName.endsWith(".macro") || fileName.endsWith(".testcase")) {
            content = this._formatPoshiXML(fileName, content);
        }
        return content;
    }

    private void _checkPoshiCharactersAfterDefinition(String fileName, String content) {
        if (content.contains("/definition>") && !content.endsWith("/definition>")) {
            this.addMessage(fileName, "Characters found after definition element");
        }
    }

    private void _checkPoshiCharactersBeforeDefinition(String fileName, String content) {
        if (!content.startsWith("<definition")) {
            this.addMessage(fileName, "Characters found before definition element");
        }
    }

    private String _fixPoshiXMLElementWithNoChild(String content) {
        Matcher matcher = _poshiElementWithNoChildPattern.matcher(content);
        while (matcher.find()) {
            content = StringUtil.replace(content, matcher.group(), "\" />");
        }
        return content;
    }

    private String _fixPoshiXMLEndLines(String content) {
        Matcher matcher = _poshiEndLinesPattern.matcher(content);
        while (matcher.find()) {
            String statement = matcher.group();
            String newStatement = StringUtil.replace(statement, matcher.group(), ">\n\n" + matcher.group(1));
            content = StringUtil.replace(content, statement, newStatement);
        }
        return content;
    }

    private String _fixPoshiXMLEndLinesAfterClosingElement(String content) {
        Matcher matcher = _poshiEndLinesAfterClosingElementPattern.matcher(content);
        while (matcher.find()) {
            String newStatement;
            String statement = matcher.group();
            String closingElementName = matcher.group(1);
            if (StringUtil.equalsIgnoreCase("</and>", closingElementName) || StringUtil.equalsIgnoreCase("</elseif>", closingElementName) || StringUtil.equalsIgnoreCase("</not>", closingElementName) || StringUtil.equalsIgnoreCase("</or>", closingElementName) || StringUtil.equalsIgnoreCase("</then>", closingElementName)) {
                newStatement = StringUtil.replace(statement, matcher.group(2), "\n");
                content = StringUtil.replace(content, statement, newStatement);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("</var>", closingElementName)) continue;
            newStatement = StringUtil.replace(statement, matcher.group(2), "\n\n");
            content = StringUtil.replace(content, statement, newStatement);
        }
        return content;
    }

    private String _fixPoshiXMLEndLinesBeforeClosingElement(String content) {
        Matcher matcher = _poshiEndLinesBeforeClosingElementPattern.matcher(content);
        while (matcher.find()) {
            String statement = matcher.group();
            String newStatement = StringUtil.replace(statement, matcher.group(1), "\n");
            content = StringUtil.replace(content, statement, newStatement);
        }
        return content;
    }

    private String _formatPoshiXML(String fileName, String content) throws DocumentException {
        block3: {
            this._checkPoshiCharactersAfterDefinition(fileName, content);
            this._checkPoshiCharactersBeforeDefinition(fileName, content);
            try {
                Document document = SourceUtil.readXML(content);
                Element rootElement = document.getRootElement();
                List commandElements = rootElement.elements("command");
                for (Element commandElement : commandElements) {
                    this.checkElementOrder(fileName, commandElement, "property", null, new ElementComparator());
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug(exception, exception);
            }
        }
        content = this._sortPoshiCommands(content);
        content = this._sortPoshiVariables(content);
        content = this._fixPoshiXMLElementWithNoChild(content);
        content = this._fixPoshiXMLEndLinesAfterClosingElement(content);
        content = this._fixPoshiXMLEndLinesBeforeClosingElement(content);
        return this._fixPoshiXMLEndLines(content);
    }

    private String _sortPoshiCommands(String content) {
        Matcher matcher = _poshiCommandsPattern.matcher(content);
        TreeMap<String, String> commandBlocksMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String previousName = "";
        boolean hasUnsortedCommands = false;
        while (matcher.find()) {
            String commandBlock = matcher.group();
            String commandName = matcher.group(1);
            commandBlocksMap.put(commandName, commandBlock);
            if (!hasUnsortedCommands && commandName.compareToIgnoreCase(previousName) < 0) {
                hasUnsortedCommands = true;
            }
            previousName = commandName;
        }
        if (!hasUnsortedCommands) {
            return content;
        }
        StringBundler sb = new StringBundler();
        matcher = _poshiSetUpPattern.matcher(content);
        if (matcher.find()) {
            String setUpBlock = matcher.group();
            content = StringUtil.removeSubstring(content, setUpBlock);
            sb.append(setUpBlock);
        }
        if ((matcher = _poshiTearDownPattern.matcher(content)).find()) {
            String tearDownBlock = matcher.group();
            content = StringUtil.removeSubstring(content, tearDownBlock);
            sb.append(tearDownBlock);
        }
        for (Map.Entry entry : commandBlocksMap.entrySet()) {
            sb.append("\n\t");
            sb.append((String)entry.getValue());
            sb.append("\n");
        }
        int x = content.indexOf("<command");
        int n = content.lastIndexOf("</command>");
        String commandBlock = content.substring(x, n);
        commandBlock = "\n\t" + commandBlock + "</command>\n";
        String newCommandBlock = sb.toString();
        return StringUtil.replaceFirst(content, commandBlock, newCommandBlock);
    }

    private String _sortPoshiVariables(String content) {
        Matcher matcher = _poshiVariablesBlockPattern.matcher(content);
        while (matcher.find()) {
            Object previousName = "";
            String tabs = "";
            TreeMap<Object, String> variableLinesMap = new TreeMap<Object, String>(String.CASE_INSENSITIVE_ORDER);
            String variableBlock = matcher.group(1);
            variableBlock = variableBlock.trim();
            Matcher variableLineMatcher = _poshiVariableLinePattern.matcher(variableBlock);
            boolean hasUnsortedVariables = false;
            while (variableLineMatcher.find()) {
                if (tabs.equals("")) {
                    tabs = variableLineMatcher.group(1);
                }
                String variableLine = variableLineMatcher.group(2);
                String variableName = variableLineMatcher.group(3);
                variableLinesMap.put(variableName, variableLine);
                if (!hasUnsortedVariables && variableName.compareToIgnoreCase((String)previousName) < 0) {
                    hasUnsortedVariables = true;
                }
                previousName = variableName;
            }
            if (!hasUnsortedVariables) continue;
            StringBundler sb = new StringBundler();
            for (Map.Entry entry : variableLinesMap.entrySet()) {
                sb.append(tabs);
                sb.append((String)entry.getValue());
                sb.append("\n");
            }
            String newVariableBlock = sb.toString();
            newVariableBlock = newVariableBlock.trim();
            content = StringUtil.replaceFirst(content, variableBlock, newVariableBlock);
        }
        return content;
    }
}

